/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.dted;

import java.text.DecimalFormat;

public class DTEDFrameUtil {
    public static float stringToLat(String text_lat) {
        String s_seconds;
        int offset = 0;
        int hemisphere = 1;
        if (text_lat.length() > 7 && text_lat.charAt(6) != '.') {
            offset = 1;
        }
        char[] contents = text_lat.toCharArray();
        String s_degrees = String.valueOf(contents, offset, 2);
        String s_minutes = String.valueOf(contents, 2 + offset, 2);
        if (text_lat.charAt(6 + offset) == '.') {
            s_seconds = String.valueOf(contents, 4 + offset, 4);
            if (text_lat.charAt(8 + offset) == 'S') {
                hemisphere = -1;
            }
        } else {
            s_seconds = String.valueOf(contents, 4 + offset, 2);
            if (text_lat.charAt(6 + offset) == 'S') {
                hemisphere = -1;
            }
        }
        float result = Float.valueOf(s_degrees).floatValue() + Float.valueOf(s_minutes).floatValue() / 60.0f + Float.valueOf(s_seconds).floatValue() / 3600.0f;
        return result *= (float)hemisphere;
    }

    public static float stringToLon(String text_lon) {
        String s_seconds;
        int hemisphere = 1;
        char[] contents = text_lon.toCharArray();
        String s_degrees = String.valueOf(contents, 0, 3);
        String s_minutes = String.valueOf(contents, 3, 2);
        if (text_lon.charAt(7) == '.') {
            s_seconds = String.valueOf(contents, 5, 4);
            if (text_lon.charAt(9) == 'W') {
                hemisphere = -1;
            }
        } else {
            s_seconds = String.valueOf(contents, 5, 2);
            if (text_lon.charAt(7) == 'W') {
                hemisphere = -1;
            }
        }
        float result = Float.valueOf(s_degrees).floatValue() + Float.valueOf(s_minutes).floatValue() / 60.0f + Float.valueOf(s_seconds).floatValue() / 3600.0f;
        return result *= (float)hemisphere;
    }

    public static String latToFileString(float lat, int level) {
        String direction;
        if (lat >= 0.0f) {
            direction = "n";
            lat = (float)Math.floor(lat);
        } else {
            direction = "s";
            lat = (float)Math.ceil(lat * -1.0f);
        }
        DecimalFormat fd = new DecimalFormat("00");
        String result = direction + fd.format(lat) + ".dt" + level;
        return result;
    }

    public static String lonToFileString(float lon) {
        String direction;
        if (lon >= 0.0f) {
            direction = "e";
            lon = (float)Math.floor(lon);
        } else {
            direction = "w";
            lon = (float)Math.ceil(lon * -1.0f);
        }
        DecimalFormat fd = new DecimalFormat("000");
        String result = direction + fd.format(lon);
        return result;
    }
}

