/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.mapTile;

import com.bbn.openmap.dataAccess.mapTile.MapTileCoordinateTransform;
import com.bbn.openmap.dataAccess.mapTile.SimpleEmptyTileHandler;
import com.bbn.openmap.layer.shape.ShapeLayer;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.proj.Mercator;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.PropUtils;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Properties;

public class ShpFileEmptyTileHandler
extends SimpleEmptyTileHandler {
    public static final String LAND_ATTRIBUTES_PROPERTY = "land";
    public static final String SHP_FILE_PROPERTY = "shpFile";
    protected ShapeLayer shapeStuff;
    protected DrawingAttributes landAttributes = DrawingAttributes.getDefaultClone();

    public BufferedImage getImageForEmptyTile(String imagePath, int x, int y, int zoomLevel, MapTileCoordinateTransform mtcTransform, Projection proj) {
        if (this.shapeStuff != null && zoomLevel < this.noCoverageZoom) {
            BufferedImage bi = new BufferedImage(256, 256, 2);
            Graphics g = bi.getGraphics();
            LatLonPoint center = mtcTransform.tileUVToLatLon(new Point2D.Double((double)x + 0.5, (double)y + 0.5), zoomLevel, new LatLonPoint.Double());
            Mercator merc = new Mercator(center, mtcTransform.getScaleForZoom(zoomLevel), 256, 256);
            ((Graphics2D)g).setPaint(this.backgroundAtts.getFillPaint());
            g.fillRect(0, 0, 256, 256);
            if (this.shapeStuff != null) {
                this.shapeStuff.setDrawingAttributes(this.landAttributes);
                this.shapeStuff.renderDataForProjection(merc, g);
            }
            g.dispose();
            return bi;
        }
        return super.getImageForEmptyTile(imagePath, x, y, zoomLevel, mtcTransform, proj);
    }

    public ShapeLayer getShapeStuff() {
        return this.shapeStuff;
    }

    public void setShapeStuff(ShapeLayer shapeStuff) {
        this.shapeStuff = shapeStuff;
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.landAttributes.setProperties(prefix + LAND_ATTRIBUTES_PROPERTY, props);
        String shapeFileName = props.getProperty(prefix + SHP_FILE_PROPERTY);
        if (shapeFileName != null) {
            this.shapeStuff = new ShapeLayer(shapeFileName);
            this.shapeStuff.setDrawingAttributes(this.landAttributes);
            if (props.getProperty(prefix + "noCoverageZoom") == null) {
                this.noCoverageZoom = 20;
            }
        }
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        this.landAttributes.getProperties(props);
        return props;
    }

    public DrawingAttributes getLandAttributes() {
        return this.landAttributes;
    }

    public void setLandAttributes(DrawingAttributes landAttributes) {
        this.landAttributes = landAttributes;
    }
}

