/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.shape.input;

import com.bbn.openmap.dataAccess.shape.DbfTableModel;
import com.bbn.openmap.dataAccess.shape.input.LittleEndianInputStream;
import com.bbn.openmap.util.Debug;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbfInputStream {
    private LittleEndianInputStream _leis = null;
    private String[] _columnNames = null;
    private int[] _lengths = null;
    private byte[] _decimalCounts = null;
    private byte[] _types = null;
    private int _columnCount = -1;
    private int _rowCount = -1;
    private short _headerLength = (short)-1;
    private List<List<Object>> _records = null;

    public DbfInputStream(InputStream is) throws Exception {
        BufferedInputStream bis = new BufferedInputStream(is);
        this._leis = new LittleEndianInputStream(bis);
        this.readHeader();
        this.readFieldDescripters();
        this.readData();
    }

    public String[] getColumnNames() {
        return this._columnNames;
    }

    public int[] getLengths() {
        return this._lengths;
    }

    public byte[] getDecimalCounts() {
        return this._decimalCounts;
    }

    public byte[] getTypes() {
        return this._types;
    }

    public List<List<Object>> getRecords() {
        return this._records;
    }

    public int getColumnCount() {
        return this._columnCount;
    }

    public int getRowCount() {
        return this._rowCount;
    }

    private void readHeader() throws IOException {
        this._leis.readByte();
        this._leis.readByte();
        this._leis.readByte();
        this._leis.readByte();
        this._rowCount = this._leis.readLEInt();
        this._headerLength = this._leis.readLEShort();
        this._leis.readLEShort();
        this._columnCount = (this._headerLength - 32 - 1) / 32;
        this._leis.skipBytes(20);
    }

    private void readFieldDescripters() throws IOException {
        this._columnNames = new String[this._columnCount];
        this._types = new byte[this._columnCount];
        this._lengths = new int[this._columnCount];
        this._decimalCounts = new byte[this._columnCount];
        for (int n = 0; n <= this._columnCount - 1; ++n) {
            this._columnNames[n] = this._leis.readString(11).trim();
            int ix = this._columnNames[n].indexOf(0);
            if (ix > 0) {
                this._columnNames[n] = this._columnNames[n].substring(0, ix);
            }
            this._types[n] = this._leis.readByte();
            this._leis.skipBytes(4);
            this._lengths[n] = this._leis.readUnsignedByte();
            this._decimalCounts[n] = this._leis.readByte();
            this._leis.skipBytes(14);
        }
    }

    public void readData() throws IOException {
        DecimalFormat df = new DecimalFormat();
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.ENGLISH);
        df.setDecimalFormatSymbols(dfs);
        this._leis.skipBytes(2);
        this._records = new ArrayList<List<Object>>(this._rowCount);
        for (int r = 0; r <= this._rowCount - 1; ++r) {
            ArrayList<Object> record = new ArrayList<Object>(this._columnCount);
            for (int c = 0; c <= this._columnCount - 1; ++c) {
                int length = this._lengths[c];
                if (length == -1) {
                    length = 255;
                }
                byte type = this._types[c];
                byte numDecSpaces = this._decimalCounts[c];
                df.setMaximumFractionDigits(numDecSpaces);
                String cell = this._leis.readString(length);
                try {
                    record.add(c, DbfTableModel.getObjectForType(cell, type, df, length));
                    continue;
                }
                catch (ParseException pe) {
                    if (Debug.debugging("shape")) {
                        Debug.error("DbfInputStream:  error parsing column " + c + ", row " + r + ", expected number and got " + cell);
                    }
                    record.add(c, DbfTableModel.appendWhitespaceOrTrim(null, length));
                }
            }
            this._records.add(record);
            this._leis.skipBytes(1);
        }
    }
}

