/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.event.ListenerSupport;
import com.bbn.openmap.event.PanEvent;
import com.bbn.openmap.event.PanListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PanSupport
extends ListenerSupport<PanListener> {
    public PanSupport(Object sourceBean) {
        super(sourceBean);
    }

    public void firePan(int direction) {
        this.firePan(direction, 1.0f);
    }

    public void firePan(int direction, float amount) {
        if (direction < 1300 || direction > 1307) {
            throw new IllegalArgumentException("Bad value, " + direction + " for direction in PanSupport.firePan()");
        }
        float az = PanEvent.dir2Az(direction);
        this.firePan(az);
    }

    public void firePan(float Az) {
        this.firePan(Az, Float.NaN);
    }

    public synchronized void firePan(float az, float c) {
        if (this.isEmpty()) {
            return;
        }
        PanEvent evt = new PanEvent(this.source, az, c);
        for (PanListener listener : this) {
            listener.pan(evt);
        }
    }
}

