/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.geo;

import com.bbn.openmap.geo.Geo;
import com.bbn.openmap.geo.GeoArray;
import com.bbn.openmap.geo.GeoPath;
import com.bbn.openmap.geo.Intersection;

public interface BoundingCircle {
    public Geo getCenter();

    public double getRadius();

    public boolean intersects(BoundingCircle var1);

    public boolean intersects(Geo var1, double var2);

    public static class Impl
    implements BoundingCircle {
        private Geo center;
        private double radius;

        public Impl(Geo center, double radius) {
            this.init(center, radius);
        }

        public Impl(GeoArray arrayPoints) {
            this.init(arrayPoints);
        }

        public Impl(GeoPath path) {
            this.init(path.getPoints());
        }

        public Impl(Geo[] gs) {
            this.init(gs);
        }

        protected void init(Geo[] region) {
            Geo c = Intersection.center(region);
            double r = 0.0;
            int length = region.length;
            for (int i = 0; i < length; ++i) {
                double pr = c.distance(region[i]);
                if (!(pr > r)) continue;
                r = pr;
            }
            this.init(c, r);
        }

        protected void init(GeoArray region) {
            Geo c = Intersection.center(region, new Geo());
            Geo storage = new Geo();
            double r = 0.0;
            int length = region.getSize();
            for (int i = 0; i < length; ++i) {
                double pr = c.distance(region.get(i, storage));
                if (!(pr > r)) continue;
                r = pr;
            }
            this.init(c, r);
        }

        protected void init(Geo center, double radius) {
            this.center = center;
            this.radius = radius;
        }

        public final Geo getCenter() {
            return this.center;
        }

        public final double getRadius() {
            return this.radius;
        }

        public boolean intersects(BoundingCircle bc) {
            return this.intersects(bc.getCenter(), bc.getRadius());
        }

        public boolean intersects(Geo g, double r) {
            return this.center.distance(g) <= this.getRadius() + r;
        }

        public String toString() {
            return "BoundingCircle: center(" + this.center + ") with radius (" + this.radius + ")";
        }

        public static BoundingCircle createFromLatLonDegrees(double[] latlons) {
            return new Impl(GeoArray.Double.createFromLatLonDegrees(latlons));
        }

        public static BoundingCircle createFromLatLonDegrees(float[] latlons) {
            return new Impl(GeoArray.Float.createFromLatLonDegrees(latlons));
        }

        public static BoundingCircle createFromLatLonRadians(double[] latlons) {
            return new Impl(GeoArray.Double.createFromLatLonRadians(latlons));
        }

        public static BoundingCircle createFromLatLonRadians(float[] latlons) {
            return new Impl(GeoArray.Float.createFromLatLonRadians(latlons));
        }
    }
}

