/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.geo;

import com.bbn.openmap.geo.Geo;

public class Rotation {
    protected Geo g;
    double m00;
    double m11;
    double m22;
    double m01;
    double m10;
    double m12;
    double m21;
    double m02;
    double m20;

    public Rotation(Geo g, double angle) {
        this.g = g;
        this.setAngle(angle);
    }

    private void setAngle(double angle) {
        double x = this.g.x();
        double y = this.g.y();
        double z = this.g.z();
        double c = Math.cos(angle);
        double s = Math.sin(angle);
        double b = 1.0 - c;
        double bx = b * x;
        double by = b * y;
        double bz = b * z;
        double bxx = bx * x;
        double bxy = bx * y;
        double bxz = bx * z;
        double byy = by * y;
        double byz = by * z;
        double bzz = bz * z;
        double sx = s * x;
        double sy = s * y;
        double sz = s * z;
        this.m00 = c + bxx;
        this.m11 = c + byy;
        this.m22 = c + bzz;
        this.m01 = -sz + bxy;
        this.m10 = sz + bxy;
        this.m12 = -sx + byz;
        this.m21 = sx + byz;
        this.m02 = sy + bxz;
        this.m20 = -sy + bxz;
    }

    public Geo rotate(Geo v) {
        double x = v.x();
        double y = v.y();
        double z = v.z();
        return new Geo(this.m00 * x + this.m01 * y + this.m02 * z, this.m10 * x + this.m11 * y + this.m12 * z, this.m20 * x + this.m21 * y + this.m22 * z);
    }

    public static final Geo rotate(Geo v1, double angle, Geo v2, Geo ret) {
        double x = v1.x();
        double y = v1.y();
        double z = v1.z();
        double c = Math.cos(angle);
        double s = Math.sin(angle);
        double b = 1.0 - c;
        double bx = b * x;
        double by = b * y;
        double bz = b * z;
        double bxx = bx * x;
        double bxy = bx * y;
        double bxz = bx * z;
        double byy = by * y;
        double byz = by * z;
        double bzz = bz * z;
        double sx = s * x;
        double sy = s * y;
        double sz = s * z;
        double m00 = c + bxx;
        double m11 = c + byy;
        double m22 = c + bzz;
        double m01 = -sz + bxy;
        double m10 = sz + bxy;
        double m12 = -sx + byz;
        double m21 = sx + byz;
        double m02 = sy + bxz;
        double m20 = -sy + bxz;
        double x2 = v2.x();
        double y2 = v2.y();
        double z2 = v2.z();
        if (ret == null) {
            return new Geo(m00 * x2 + m01 * y2 + m02 * z2, m10 * x2 + m11 * y2 + m12 * z2, m20 * x2 + m21 * y2 + m22 * z2);
        }
        ret.initialize(m00 * x2 + m01 * y2 + m02 * z2, m10 * x2 + m11 * y2 + m12 * z2, m20 * x2 + m21 * y2 + m22 * z2);
        return ret;
    }
}

