/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.graphicLoader.netmap;

import com.bbn.openmap.graphicLoader.netmap.ChoiceList;
import com.bbn.openmap.graphicLoader.netmap.NetMapConnector;
import com.bbn.openmap.graphicLoader.netmap.NetMapConstants;
import com.bbn.openmap.graphicLoader.netmap.Symbol;
import com.bbn.openmap.util.Debug;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.Socket;
import java.util.Properties;
import java.util.Vector;

public class NetMapReader
extends Thread
implements NetMapConstants {
    private static Object EOF = new Object();
    private static Object LP = new Object();
    private static Object RP = new Object();
    StreamTokenizer st = null;
    boolean shutdown = false;
    String viewName = null;
    Socket s = null;
    NetMapConnector netmapConn;
    boolean DEBUG = false;
    boolean DEBUG_VERBOSE = false;
    int[] nargs = new int[60];

    public NetMapReader(String host, String port, NetMapConnector connector) throws IOException {
        this(host, port, connector, null);
    }

    public NetMapReader(String host, String port, NetMapConnector connector, String view) throws IOException {
        this.netmapConn = connector;
        if (view != null) {
            this.setView(view);
        }
        this.DEBUG = Debug.debugging("netmap");
        this.DEBUG_VERBOSE = Debug.debugging("netmap_verbose");
        this.s = this.connect(host, port);
    }

    public void setView(String view) {
        this.viewName = view;
    }

    private Socket connect(String host, String portString) throws IOException {
        int port = 0;
        Socket sock = null;
        boolean DEBUG = Debug.debugging("netmap");
        try {
            port = Integer.parseInt(portString, 10);
        }
        catch (NumberFormatException e) {
            if (DEBUG) {
                Debug.output("Illegal name " + host + ":" + portString);
            }
            throw new IOException("Illegal port: " + portString);
        }
        if (DEBUG) {
            Debug.output("Connecting to server " + host + ":" + port);
        }
        try {
            sock = new Socket(host, port);
        }
        catch (IOException e) {
            if (sock != null) {
                sock.close();
            }
            if (DEBUG) {
                Debug.output("Can't connect to " + host + ":" + port + "\n   " + e);
            }
            throw e;
        }
        return sock;
    }

    public ChoiceList getViewList(String host, String port) {
        BufferedReader in = null;
        PrintWriter out = null;
        ChoiceList viewList = null;
        Socket sock = null;
        boolean DEBUG = Debug.debugging("netmap");
        try {
            sock = this.connect(host, port);
            in = new BufferedReader(new InputStreamReader(sock.getInputStream()));
            out = new PrintWriter(sock.getOutputStream(), true);
            out.println("shc cat jmap.views");
        }
        catch (IOException e) {
            Debug.error("NetMapReader: " + e);
            return null;
        }
        viewList = new ChoiceList();
        try {
            String line = null;
            while ((line = in.readLine()) != null) {
                line = line.trim();
                int labelStart = line.indexOf("'");
                int labelEnd = line.lastIndexOf("'");
                String viewLabel = null;
                String viewLine = null;
                if (DEBUG) {
                    Debug.output("View definition: " + line);
                }
                if (labelStart < 0) {
                    viewLine = line;
                    viewLabel = line;
                } else {
                    viewLine = line.substring(0, labelStart) + " " + line.substring(labelEnd + 1);
                    viewLabel = line.substring(labelStart + 1, labelEnd);
                }
                viewList.add(viewLabel.trim(), viewLine.trim());
            }
        }
        catch (IOException e) {
            Debug.error("NetMapReader: Input error: " + e);
            viewList.removeAllElements();
            viewList = null;
        }
        try {
            sock.close();
            this.netmapConn.connectionDown();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return viewList;
    }

    public void shutdown() {
        this.shutdown = true;
    }

    public void run() {
        BufferedReader tdin = null;
        PrintWriter tdout = null;
        if (this.viewName == null) {
            Debug.error("NetMapReader not given a view name to request from the NETMAP server.");
            return;
        }
        while (!this.shutdown) {
            if (this.DEBUG) {
                Debug.output("NetMapReader attempting connection");
            }
            try {
                tdin = new BufferedReader(new InputStreamReader(this.s.getInputStream()));
                tdout = new PrintWriter(this.s.getOutputStream(), true);
                if (this.DEBUG) {
                    Debug.output("Loading view: " + this.viewName);
                }
                tdout.println("jmap '" + this.viewName + "' 768");
                this.s.setSoTimeout(500);
            }
            catch (InterruptedIOException eConnectInterrupted) {
                continue;
            }
            catch (IOException eConnect) {
                Debug.error("NetMapReader: " + eConnect.getMessage() + "; NetMapReader sleeping");
                try {
                    Thread.sleep(40000L);
                }
                catch (Exception exception) {}
                continue;
            }
            if (this.netmapConn == null) continue;
            this.netmapConn.connectionUp();
            while (!this.shutdown) {
                try {
                    String line = null;
                    line = tdin.readLine();
                    if (line == null) break;
                    if (this.DEBUG_VERBOSE) {
                        Debug.output("  read: " + line);
                    }
                    Properties eventProps = this.procline(line);
                    if (this.DEBUG_VERBOSE) {
                        Debug.output("  processed...");
                    }
                    if (!eventProps.isEmpty()) {
                        this.netmapConn.distributeEvent(eventProps);
                        if (!this.DEBUG_VERBOSE) continue;
                        Debug.output("  distributed...");
                        continue;
                    }
                    if (!this.DEBUG_VERBOSE) continue;
                    Debug.output("  ignored...");
                }
                catch (InterruptedIOException eReadInterrupted) {
                }
                catch (Exception e) {
                    Debug.error("NetMapReader exception: " + e.getMessage() + "; in NetMapReader run. ");
                }
            }
            try {
                this.s.close();
                this.netmapConn.connectionDown();
            }
            catch (Exception exception) {}
        }
    }

    protected Properties procline(String cmdline) {
        Vector v = this.tokenize(cmdline);
        if (this.DEBUG_VERBOSE) {
            Debug.output("  parsed: " + v.toString());
        }
        Properties eventProps = new Properties();
        String cmd = v.firstElement().toString();
        int shape = this.nargs[4];
        if (cmd.equals("nobj")) {
            eventProps.put("cmd", "nobj");
            eventProps.put("index", Integer.toString(this.nargs[1]));
            eventProps.put("shape", Integer.toString(this.nargs[4]));
            if (v.elementAt(4) instanceof String) {
                String icon = (String)v.elementAt(4);
                eventProps.put("shape", "11");
                eventProps.put("icon", icon);
                if (this.DEBUG) {
                    Debug.output("NetMapReader: jimage  " + icon);
                }
            }
            if (shape == -1) {
                eventProps.put("shape", "-1");
            } else {
                if (shape == 0) {
                    eventProps.put("shape", "0");
                    eventProps.put("time", Integer.toString(this.nargs[8]));
                } else {
                    eventProps.put("width", Integer.toString(this.nargs[5]));
                    eventProps.put("height", Integer.toString(this.nargs[6]));
                    eventProps.put("status", Integer.toString(this.nargs[7]));
                    eventProps.put("menu", Integer.toString(this.nargs[8]));
                    eventProps.put("label", (String)v.elementAt(9));
                    eventProps.put("name", (String)v.elementAt(11));
                    eventProps.put("joffset", Integer.toString(this.nargs[10]));
                }
                eventProps.put("posx", Integer.toString(this.nargs[2]));
                eventProps.put("posy", Integer.toString(this.nargs[3]));
                String elev = null;
                elev = this.getVal("elev=", cmdline);
                if (elev != null) {
                    eventProps.put("elev", elev);
                }
                String geo = null;
                geo = this.getVal("lat=", cmdline);
                if (geo != null) {
                    eventProps.put("lat", geo);
                }
                if ((geo = this.getVal("lon=", cmdline)) != null) {
                    eventProps.put("lon", geo);
                }
                if ((geo = this.getVal("ip=", cmdline)) != null) {
                    eventProps.put("ip", geo);
                }
            }
        } else if (cmd.equals("nobjstat")) {
            eventProps.put("cmd", "nobjstat");
            eventProps.put("index", Integer.toString(this.nargs[1]));
            eventProps.put("status", Integer.toString(this.nargs[2]));
        } else if (cmd.equals("lobjstat")) {
            eventProps.put("cmd", "lobjstat");
            eventProps.put("index", Integer.toString(this.nargs[1]));
            eventProps.put("status", Integer.toString(this.nargs[2]));
        } else if (cmd.equals("lobj")) {
            eventProps.put("cmd", "lobj");
            eventProps.put("index", Integer.toString(this.nargs[1]));
            eventProps.put("shape", Integer.toString(this.nargs[2]));
            if (shape != -1) {
                eventProps.put("status", Integer.toString(this.nargs[5]));
                eventProps.put("lnode1", Integer.toString(this.nargs[3]));
                eventProps.put("lnode2", Integer.toString(this.nargs[4]));
            }
        } else if (cmd.equals("refresh")) {
            eventProps.put("cmd", "refresh");
        } else if (cmd.equals("update")) {
            eventProps.put("cmd", "update");
        }
        return eventProps;
    }

    protected Vector tokenize(String line) {
        Object ob;
        Vector<Object> v = new Vector<Object>(12, 10);
        this.unitInit(new StringReader(line));
        int cnt = 0;
        while ((ob = this.unit()) != EOF) {
            v.addElement(ob);
            this.nargs[cnt] = ob instanceof Double ? ((Number)ob).intValue() : 0;
            ++cnt;
        }
        return v;
    }

    protected void unitInit(StringReader rdr) {
        this.st = new StreamTokenizer(rdr);
        this.st.commentChar(37);
        this.st.slashSlashComments(true);
        this.st.slashStarComments(true);
        this.st.wordChars(47, 47);
        this.st.wordChars(61, 61);
        this.st.wordChars(58, 58);
    }

    protected Object unit() {
        Object p = this.next();
        if (p == EOF) {
            return EOF;
        }
        if (p == LP) {
            Vector<Object> l = new Vector<Object>(2, 4);
            while (true) {
                Object r;
                if ((r = this.unit()) == RP) {
                    return l;
                }
                if (r == EOF) {
                    return EOF;
                }
                l.addElement(r);
            }
        }
        return p;
    }

    protected Object next() {
        int i = 0;
        try {
            i = this.st.nextToken();
        }
        catch (IOException e) {
            Debug.error("NetMapReader: " + e.toString() + " in toktest\n");
        }
        if (i == -1 || i == 0) {
            return EOF;
        }
        if (i == -3) {
            return new Symbol(this.st.sval, 1);
        }
        if (i == 39 || i == 34) {
            return this.st.sval;
        }
        if (i == -2) {
            return new Double(this.st.nval);
        }
        if (i == 40 || i == 91 || i == 123) {
            return LP;
        }
        if (i == 41 || i == 93 || i == 125) {
            return RP;
        }
        char[] c = new char[]{(char)i};
        return new Symbol(new String(c), 2);
    }

    protected String getVal(String marker, String line) {
        int sTok = 0;
        int eTok = 0;
        sTok = line.toLowerCase().indexOf(marker);
        if (sTok < 0) {
            return null;
        }
        eTok = line.indexOf(" ", sTok);
        if (eTok < 0 && (eTok = line.indexOf("\t", sTok)) < 0) {
            eTok = line.length();
        }
        return line.substring(sTok + marker.length(), eTok);
    }
}

