/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.Environment;
import com.bbn.openmap.event.ListenerSupport;
import com.bbn.openmap.util.Debug;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowSupport
extends ListenerSupport<ComponentListener>
implements ComponentListener,
ActionListener {
    protected Component content;
    protected String title;
    protected Point componentLocation;
    protected Dimension componentSize;
    public static final String DisplayWindowCmd = "displayWindowCmd";
    public static final String KillWindowCmd = "killWindowCmd";
    protected transient WSDisplay display;
    protected static Class defaultWindowSupportDisplayType = Frm.class;
    protected int maxHeight = -1;
    protected int maxWidth = -1;
    protected Class persistentDisplayType;

    public WindowSupport(Component content, String windowTitle) {
        super(content);
        this.setContent(content);
        this.title = windowTitle;
    }

    public WindowSupport(Component content, WSDisplay display) {
        super(content);
        this.setContent(content);
        this.setDisplay(display);
        if (display != null) {
            this.title = display.getTitle();
        }
    }

    public void setComponentLocation(Point p) {
        this.componentLocation = p;
    }

    public Point getComponentLocation() {
        return this.componentLocation;
    }

    public void setComponentSize(Dimension dim) {
        this.componentSize = dim;
    }

    public Dimension getComponentSize() {
        return this.componentSize;
    }

    @Override
    public void componentResized(ComponentEvent e) {
        Component source = (Component)e.getSource();
        this.setComponentSize(source.getSize());
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ((ComponentListener)it.next()).componentResized(e);
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.setComponentLocation(((Component)e.getSource()).getLocation());
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ((ComponentListener)it.next()).componentMoved(e);
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ((ComponentListener)it.next()).componentShown(e);
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ((ComponentListener)it.next()).componentHidden(e);
        }
        Component source = (Component)e.getSource();
        if (this.display == source) {
            this.cleanUp();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command == KillWindowCmd) {
            this.killWindow();
        } else if (command == DisplayWindowCmd) {
            this.displayInWindow();
        }
    }

    protected void finalize() {
        if (Debug.debugging("gc")) {
            Debug.output("WindowSupport being gc'd");
        }
    }

    public void setTitle(String tle) {
        this.title = tle;
        if (this.display != null) {
            this.display.setTitle(tle);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setContent(Component comp) {
        if (this.content instanceof ComponentListener) {
            this.removeComponentListener((ComponentListener)((Object)this.content));
        }
        this.content = comp;
        if (this.display != null) {
            this.display.setContent(comp);
        }
        if (this.content instanceof ComponentListener) {
            this.addComponentListener((ComponentListener)((Object)this.content));
        }
    }

    public Component getContent() {
        return this.content;
    }

    public void setMaxSize(int width, int height) {
        this.maxHeight = height;
        this.maxWidth = width;
    }

    protected WSDisplay createDisplay(Frame owner) {
        Container wsd;
        if (this.persistentDisplayType == null && Environment.getBoolean("openmap.UseInternalFrames")) {
            wsd = new IntrnlFrm(this.title);
        } else {
            Class wTypeClass;
            Class clazz = wTypeClass = this.persistentDisplayType == null ? WindowSupport.getDefaultWindowSupportDisplayType() : this.persistentDisplayType;
            wsd = wTypeClass == Dlg.class ? new Dlg(owner, this.title) : (wTypeClass == IntrnlFrm.class ? new IntrnlFrm(this.title) : new Frm(this.title));
        }
        this.setFavIcon((WSDisplay)((Object)wsd));
        this.setDisplay((WSDisplay)((Object)wsd));
        return wsd;
    }

    protected WSDisplay createDisplay(Frame owner, Class displayType) {
        if (displayType == null) {
            return this.createDisplay(owner);
        }
        Container wsd = displayType == Dlg.class ? new Dlg(owner, this.title) : (displayType == IntrnlFrm.class ? new IntrnlFrm(this.title) : new Frm(this.title));
        this.setDisplay((WSDisplay)((Object)wsd));
        return wsd;
    }

    public static Class getDefaultWindowSupportDisplayType() {
        return defaultWindowSupportDisplayType;
    }

    public static void setDefaultWindowSupportDisplayType(Class defaultWindowSupportDisplayType) {
        WindowSupport.defaultWindowSupportDisplayType = defaultWindowSupportDisplayType;
    }

    public void setDisplay(WSDisplay dis) {
        if (this.display != null) {
            this.display.removeComponentListener(this);
        }
        this.display = dis;
        if (this.display != null) {
            this.display.addComponentListener(this);
            this.display.setContent(this.modifyContent(this.content));
        }
    }

    public Component modifyContent(Component comp) {
        return comp;
    }

    public WSDisplay getDisplay() {
        return this.display;
    }

    public void displayInWindow() {
        this.displayInWindow(null);
    }

    public void displayInWindow(Frame owner) {
        Dimension dim = this.getComponentSize();
        if (dim != null) {
            this.content.setSize(dim);
        }
        this.displayInWindow(owner, -1, -1, -1, -1);
    }

    public void displayInWindow(int x, int y, int width, int height) {
        this.displayInWindow(null, x, y, width, height);
    }

    public void displayInWindow(Frame owner, int x, int y, int width, int height) {
        this.displayInWindow(owner, null, x, y, width, height);
    }

    public void displayInWindow(Frame owner, Class displayType, int x, int y, int width, int height) {
        Point loc;
        if (this.content == null) {
            Debug.message("windowsupport", "WindowSupport asked to display window with null content");
            return;
        }
        if (x < 0 && y < 0 && (loc = this.getComponentLocation()) != null) {
            x = (int)loc.getX();
            y = (int)loc.getY();
        }
        if (this.display != null && displayType != null && !this.display.getClass().getName().equals(displayType.getName())) {
            this.display.dispose();
            this.display = null;
        }
        if (this.display == null) {
            this.display = this.createDisplay(owner, displayType);
        }
        Container displayWindow = this.display.getWindow();
        this.checkBounds(displayWindow, x, y, width, height);
        this.display.show(x, y);
        this.setComponentLocation(displayWindow.getLocation());
        this.setComponentSize(displayWindow.getSize());
    }

    protected void checkBounds(Component comp, int x, int y, int width, int height) {
        if (comp != null) {
            if (width <= 0) {
                width = comp.getWidth();
            }
            if (this.maxWidth > 0 && width > this.maxWidth) {
                width = this.maxWidth;
            }
            if (height <= 0) {
                height = comp.getHeight();
            }
            if (this.maxHeight > 0 && height > this.maxHeight) {
                height = this.maxHeight;
            }
            comp.setBounds(x, y, width, height);
        }
    }

    protected static void setDefaultPosition(Component comp) {
        int w = comp.getWidth();
        int h = comp.getHeight();
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        int width = gd.getDisplayMode().getWidth();
        int height = gd.getDisplayMode().getHeight();
        int x = width / 2 - w / 2;
        int y = height / 2 - h / 2;
        Debug.message("basic", "Screen dimensions are " + gd.getDisplayMode());
        if (Debug.debugging("basic")) {
            Debug.output("Setting PLG frame X and Y from properties to " + x + " " + y);
        }
        comp.setBounds(x, y, w, h);
    }

    public void killWindow() {
        ComponentEvent ce = null;
        if (this.display != null) {
            ce = this.display.kill();
        }
        if (ce != null) {
            this.componentHidden(ce);
        }
    }

    protected void cleanUp() {
        if (this.display != null) {
            this.persistentDisplayType = this.display.getClass();
            WSDisplay wsd = this.display;
            this.setDisplay(null);
            wsd.dispose();
        }
    }

    public void addComponentListener(ComponentListener l) {
        this.add(l);
    }

    public void removeComponentListener(ComponentListener l) {
        this.remove(l);
    }

    public Container getWindow() {
        if (this.display != null) {
            return this.display.getWindow();
        }
        return null;
    }

    protected void setFavIcon(WSDisplay wsd) {
        String iconPath = Environment.get("openmap.favicon");
        if (iconPath != null && wsd instanceof Window) {
            try {
                BufferedImage favIcon = ImageIO.read(WindowSupport.class.getResourceAsStream(iconPath));
                try {
                    Method siiMethod = wsd.getClass().getMethod("setIconImage", BufferedImage.class);
                    siiMethod.invoke((Object)((Window)((Object)wsd)), favIcon);
                }
                catch (NoSuchMethodException e) {
                    Debug.message("windows", e.getMessage());
                }
                catch (SecurityException e) {
                    Debug.message("windows", e.getMessage());
                }
                catch (IllegalAccessException e) {
                    Debug.message("windows", e.getMessage());
                }
                catch (IllegalArgumentException e) {
                    Debug.message("windows", e.getMessage());
                }
                catch (InvocationTargetException e) {
                    Debug.message("windows", e.getMessage());
                }
            }
            catch (IOException e) {
                Debug.message("windows", e.getMessage());
            }
        }
    }

    public static class Frm
    extends JFrame
    implements WSDisplay {
        public Frm(String title) {
            super(title);
            this.setLocation(-1, -1);
        }

        public Frm(String title, boolean undecorated) {
            super(title);
            this.setUndecorated(undecorated);
            this.setLocation(-1, -1);
        }

        public Container getWindow() {
            return this;
        }

        public ComponentEvent kill() {
            this.setVisible(false);
            return new ComponentEvent(this, 103);
        }

        public void setContent(Component content) {
            Container cp = this.getContentPane();
            cp.removeAll();
            cp.add(content);
            this.pack();
        }

        public Dimension getContentSize() {
            return this.getContentPane().getSize();
        }

        public void show(int x, int y) {
            if (!this.isVisible()) {
                Window owner = this.getOwner();
                if (x <= 0 && y <= 0) {
                    if (owner != null) {
                        this.setLocationRelativeTo(owner);
                    } else if (owner == null) {
                        WindowSupport.setDefaultPosition(this);
                    }
                }
                super.setVisible(true);
            }
            this.toFront();
        }
    }

    public static class Dlg
    extends JDialog
    implements WSDisplay {
        public Dlg(Frame owner, String title) {
            super(owner, title);
            Debug.message("windows", "WindowSupport creating frame");
        }

        public Container getWindow() {
            return this;
        }

        public ComponentEvent kill() {
            this.setVisible(false);
            return new ComponentEvent(this, 103);
        }

        public void setContent(Component content) {
            Container cp = this.getContentPane();
            cp.removeAll();
            cp.add(content);
            this.pack();
        }

        public Dimension getContentSize() {
            return this.getContentPane().getSize();
        }

        public void show(int x, int y) {
            if (!this.isVisible()) {
                Window owner = this.getOwner();
                if (x <= 0 && y <= 0) {
                    if (owner != null) {
                        this.setLocationRelativeTo(owner);
                    } else if (owner == null) {
                        WindowSupport.setDefaultPosition(this);
                    }
                }
            }
            super.setVisible(true);
        }
    }

    public static class IntrnlFrm
    extends JInternalFrame
    implements WSDisplay {
        public IntrnlFrm(String title) {
            super(title, true, true, true, true);
            this.setOpaque(true);
            JLayeredPane desktop = Environment.getInternalFrameDesktop();
            Debug.message("windows", "WindowSupport creating internal frame");
            if (desktop != null) {
                desktop.remove(this);
                desktop.add((Component)this, JLayeredPane.PALETTE_LAYER);
            } else {
                Debug.output("WindowSupport:  No desktop set for internal frame");
            }
        }

        public Container getWindow() {
            return this;
        }

        public ComponentEvent kill() {
            this.setVisible(false);
            return new ComponentEvent(this, 103);
        }

        public void setContent(Component content) {
            Container cp = this.getContentPane();
            cp.add(content);
            this.pack();
        }

        public Dimension getContentSize() {
            return this.getContentPane().getSize();
        }

        public void show(int x, int y) {
            if (!this.isVisible()) {
                super.show();
            }
            this.toFront();
        }
    }

    public static interface WSDisplay {
        public void setTitle(String var1);

        public String getTitle();

        public Container getWindow();

        public void setContent(Component var1);

        public void show(int var1, int var2);

        public ComponentEvent kill();

        public void dispose();

        public Dimension getContentSize();

        public void addComponentListener(ComponentListener var1);

        public void removeComponentListener(ComponentListener var1);
    }
}

