/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.menu;

import com.bbn.openmap.PropertyHandler;
import com.bbn.openmap.gui.menu.MapHandlerMenuItem;
import com.bbn.openmap.util.Debug;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class SavePropertiesMenuItem
extends MapHandlerMenuItem
implements ActionListener {
    public SavePropertiesMenuItem() {
        super("Save Map Properties");
        this.addActionListener(this);
    }

    public void actionPerformed(ActionEvent ae) {
        FileOutputStream fos;
        if (this.mapHandler == null) {
            if (Debug.debugging("menu")) {
                Debug.error("SavePropertiesMenuItem: no Map Handler to use");
            }
            return;
        }
        FileDialog fd = new FileDialog(new Frame(), "Saving the map as Properties file...", 1);
        fd.setVisible(true);
        String fileName = fd.getFile();
        String dirName = fd.getDirectory();
        if (fileName == null) {
            Debug.message("savepropertiesmenuitem", "User did not select any file");
            return;
        }
        Debug.message("savepropertiesmenuitem", "User selected file " + dirName + File.separator + fileName);
        File file = new File(new File(dirName), fileName);
        PrintStream ps = null;
        try {
            fos = new FileOutputStream(file);
        }
        catch (IOException fnfe) {
            System.err.println(fnfe.getMessage());
            return;
        }
        ps = new PrintStream(fos);
        PropertyHandler.createOpenMapProperties(this.mapHandler, ps);
        ps.close();
    }
}

