/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.menu;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.event.UndoEvent;
import com.bbn.openmap.event.UndoStackTrigger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JMenuItem;

public class UndoMenuItemStackTrigger
implements UndoStackTrigger,
ActionListener {
    JMenuItem undoMI;
    JMenuItem redoMI;
    protected final List<ActionListener> listeners = Collections.synchronizedList(new ArrayList());
    protected String nothingToUndoString;
    protected String nothingToRedoString;
    protected String undoString;
    protected String redoString;

    public UndoMenuItemStackTrigger() {
        I18n i18n = Environment.getI18n();
        this.nothingToUndoString = i18n.get(this.getClass(), "nothingToUndoString", "Nothing to Undo");
        this.nothingToRedoString = i18n.get(this.getClass(), "nothingToRedoString", "Nothing to Redo");
        this.undoString = i18n.get(this.getClass(), "undoString", "Undo ");
        this.redoString = i18n.get(this.getClass(), "redoString", "Redo ");
        this.undoMI = new JMenuItem(this.nothingToUndoString);
        this.undoMI.setActionCommand("undo");
        this.redoMI = new JMenuItem(this.nothingToRedoString);
        this.redoMI.setActionCommand("redo");
        this.undoMI.addActionListener(this);
        this.redoMI.addActionListener(this);
        this.undoMI.setEnabled(false);
        this.redoMI.setEnabled(false);
    }

    public void addActionListener(ActionListener al) {
        if (!this.listeners.contains(al)) {
            this.listeners.add(al);
        }
    }

    public void removeActionListener(ActionListener al) {
        this.listeners.remove(al);
    }

    public void updateUndoStackStatus(UndoEvent undoEvent, UndoEvent redoEvent) {
        this.undoMI.setEnabled(undoEvent != null);
        this.redoMI.setEnabled(redoEvent != null);
        if (undoEvent != null) {
            this.undoMI.setText(this.undoString + undoEvent.getDescription());
        } else {
            this.undoMI.setText(this.nothingToUndoString);
        }
        if (redoEvent != null) {
            this.redoMI.setText(this.redoString + redoEvent.getDescription());
        } else {
            this.redoMI.setText(this.nothingToRedoString);
        }
    }

    public void actionPerformed(ActionEvent e) {
        ArrayList<ActionListener> listClone = new ArrayList<ActionListener>();
        listClone.addAll(this.listeners);
        for (ActionListener al : listClone) {
            al.actionPerformed(e);
        }
    }

    public JMenuItem getUndoMenuItem() {
        return this.undoMI;
    }

    public JMenuItem getRedoMenuItem() {
        return this.redoMI;
    }
}

