/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.policy;

import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.RenderingHintsRenderPolicy;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.Projection;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.logging.Level;

public class PanningImageRenderPolicy
extends RenderingHintsRenderPolicy {
    protected BufferedImage buffer = null;
    protected Point2D offset = new Point2D.Double();
    protected Point2D oldUL;
    protected float oldScale;
    protected Class<? extends Proj> oldProjType = null;

    public PanningImageRenderPolicy() {
    }

    public PanningImageRenderPolicy(OMGraphicHandlerLayer layer) {
        super(layer);
    }

    public OMGraphicList prepare() {
        if (this.layer != null) {
            Projection proj = this.layer.getProjection();
            if (this.layer.isProjectionOK(proj)) {
                Object ul = proj.getUpperLeft();
                if (this.oldUL != null && !this.oldUL.equals(ul) && this.oldScale == proj.getScale() && proj.getClass().equals(this.oldProjType)) {
                    Point2D currentPoint = proj.forward((Point2D)ul);
                    Point2D oldPoint = proj.forward(this.oldUL);
                    this.offset.setLocation(oldPoint.getX() - currentPoint.getX(), oldPoint.getY() - currentPoint.getY());
                    this.layer.repaint();
                }
                this.oldUL = ul;
                this.oldProjType = ((Proj)proj).getClass();
                this.oldScale = proj.getScale();
                OMGraphicList list = this.layer.prepare();
                this.setBuffer(this.createAndPaintImageBuffer(list));
                return list;
            }
            logger.warning("NULL projection, can't do anything.");
        } else {
            logger.warning("NULL layer, can't do anything.");
        }
        return null;
    }

    public void paint(Graphics g) {
        if (this.layer == null) {
            logger.warning("NULL layer, skipping...");
            return;
        }
        OMGraphicList list = this.layer.getList();
        Projection proj = this.layer.getProjection();
        Graphics2D g2 = (Graphics2D)g;
        if (this.layer.isProjectionOK(proj)) {
            if (this.getBuffer() == null) {
                logger.fine("creating image buffer in paint");
                if (list != null) {
                    this.setBuffer(this.createAndPaintImageBuffer(list));
                }
            }
            BufferedImage bufferedImage = this.getBuffer();
            this.setCompositeOnGraphics(g2);
            if (bufferedImage != null) {
                AffineTransform af = new AffineTransform();
                af.translate(this.offset.getX(), this.offset.getY());
                g2.drawRenderedImage(bufferedImage, af);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("RenderingPolicy:" + this.layer.getName() + ": rendering buffer");
                }
            } else if (list != null) {
                super.setRenderingHints(g);
                list.render(g);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(this.layer.getName() + ": rendering list directly");
                }
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.layer.getName() + ".paint(): " + (list == null ? "NULL list, skipping..." : " skipping due to projection."));
        }
    }

    protected BufferedImage getBuffer() {
        return this.buffer;
    }

    protected void setBuffer(BufferedImage bi) {
        this.offset.setLocation(0.0, 0.0);
        this.buffer = bi;
    }

    protected BufferedImage createAndPaintImageBuffer(OMGraphicList list) {
        BufferedImage bufferedImage = null;
        if (list != null && this.layer != null) {
            int w = this.layer.getProjection().getWidth();
            int h = this.layer.getProjection().getHeight();
            bufferedImage = new BufferedImage(w, h, 2);
            Graphics2D g2d = (Graphics2D)bufferedImage.getGraphics();
            super.setRenderingHints(g2d);
            list.render(g2d);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this.layer.getName() + ": rendering list into buffer");
            }
        }
        return bufferedImage;
    }
}

