/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMArrowHead;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicAdapter;
import java.awt.Color;
import java.awt.geom.GeneralPath;

public abstract class OMAbstractLine
extends OMGraphicAdapter
implements OMGraphic {
    protected float[][] xpoints = new float[0][0];
    protected float[][] ypoints = new float[0][0];
    protected int nsegs = -1;
    protected OMArrowHead arrowhead = null;

    public OMAbstractLine() {
    }

    public OMAbstractLine(int rType, int lType, int dcType) {
        super(rType, lType, dcType);
    }

    public OMAbstractLine(int rType, int lType, int dcType, Color lc, Color fc, Color sc) {
        super(rType, lType, dcType, lc, fc, sc);
    }

    public void addArrowHead(boolean value) {
        if (value) {
            this.setArrowHead(new OMArrowHead(0, 100));
        } else {
            this.arrowhead = null;
        }
    }

    public void setArrowHead(OMArrowHead omah) {
        this.arrowhead = omah;
    }

    public OMArrowHead getArrowHead() {
        return this.arrowhead;
    }

    public boolean hasArrowHead() {
        return this.arrowhead != null;
    }

    public void addArrowHead(int directionType) {
        this.setArrowHead(new OMArrowHead(directionType, 100));
    }

    public void addArrowHead(int directionType, int location) {
        this.setArrowHead(new OMArrowHead(directionType, location));
    }

    public void addArrowHead(int directionType, int location, int tipWidth, int arrowLength) {
        this.setArrowHead(new OMArrowHead(directionType, location, tipWidth, arrowLength));
    }

    public int getWingTip() {
        if (this.arrowhead != null) {
            return this.arrowhead.getWingTip();
        }
        return 0;
    }

    public int getWingLength() {
        if (this.arrowhead != null) {
            return this.arrowhead.getWingLength();
        }
        return 0;
    }

    public int getArrowLocation() {
        if (this.arrowhead != null) {
            return this.arrowhead.getLocation();
        }
        return 0;
    }

    public int getArrowDirectionType() {
        if (this.arrowhead != null) {
            return this.arrowhead.getArrowDirectionType();
        }
        return 0;
    }

    public GeneralPath createArrowHeads() {
        return OMArrowHead.createArrowHeads(0, 100, this, OMArrowHead.DEFAULT_WINGTIP, OMArrowHead.DEFAULT_WINGLENGTH);
    }

    public void restore(OMGraphic source) {
        super.restore(source);
        if (source instanceof OMAbstractLine) {
            OMAbstractLine lineSource = (OMAbstractLine)source;
            OMArrowHead sah = lineSource.getArrowHead();
            if (sah != null) {
                OMArrowHead destArrowHead = new OMArrowHead(sah.getArrowDirectionType(), sah.getLocation(), sah.getWingTip(), sah.getWingLength());
                this.setArrowHead(destArrowHead);
            }
            this.nsegs = lineSource.nsegs;
        }
    }
}

