/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMRasterObject;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.io.Serializable;

public class OMBitmap
extends OMRasterObject
implements Serializable {
    public OMBitmap() {
        super(0, 0, 0);
    }

    public OMBitmap(double lt, double ln, int w, int h, byte[] bytes) {
        super(1, 0, 0);
        this.lat = lt;
        this.lon = ln;
        this.width = w;
        this.height = h;
        this.bits = bytes;
    }

    public OMBitmap(int x1, int y1, int w, int h, byte[] bytes) {
        super(2, 0, 0);
        this.x = x1;
        this.y = y1;
        this.width = w;
        this.height = h;
        this.bits = bytes;
    }

    public OMBitmap(double lt, double ln, int offset_x1, int offset_y1, int w, int h, byte[] bytes) {
        super(3, 0, 0);
        this.lat = lt;
        this.lon = ln;
        this.x = offset_x1;
        this.y = offset_y1;
        this.width = w;
        this.height = h;
        this.bits = bytes;
    }

    public void setBits(byte[] values) {
        super.setBits(values);
        if (values.length * 8 != this.height * this.width) {
            Debug.output("OMBitmap: new byte[] size (" + values.length + ") (*8) doesn't match [height*width (" + this.height * this.width + ")]");
        }
    }

    protected int[] computePixels(byte[] bits) {
        int i;
        int[] masks = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
        int nPixels = this.width * this.height;
        int[] iPixels = new int[nPixels];
        if (bits == null || bits.length * 8 < nPixels) {
            System.err.println("OMBitmap.computePixels(): not enough bits!");
            return iPixels;
        }
        Paint paint = this.getDisplayPaint();
        int foreground = paint instanceof Color ? ((Color)paint).getRGB() : Color.black.getRGB();
        paint = this.getFillPaint();
        int background = paint instanceof Color ? ((Color)paint).getRGB() : OMGraphic.clear.getRGB();
        int defaultColor = Integer.MIN_VALUE;
        int excess = this.width % 8;
        int bytes_per_row = this.width / 8;
        if (excess > 0) {
            Debug.message("omGraphics", "OMBitmap.computePixels(): excess byte");
            ++bytes_per_row;
        }
        Debug.message("omGraphics", "OMBitmap.computePixels(): bits.length = " + bits.length);
        int npix = 0;
        for (i = 0; i < this.height; ++i) {
            int w = 0;
            for (int j = 0; j < bytes_per_row; ++j) {
                int idx = i * bytes_per_row + j;
                int k = 0;
                while (k < 8 & w < this.width & npix < nPixels) {
                    int set = masks[k] & bits[idx];
                    iPixels[npix] = set > 0 ? foreground : background;
                    ++k;
                    ++w;
                    ++npix;
                }
            }
        }
        if (npix < nPixels - 1) {
            for (i = npix; i < nPixels; ++i) {
                iPixels[i] = defaultColor;
            }
        }
        return iPixels;
    }

    public boolean generate(Projection proj) {
        if (!this.position(proj)) {
            Debug.message("omgraphic", "OMBitmap: positioning failed in generate!");
            return false;
        }
        if (this.getNeedToRegenerate() || this.bitmap == null) {
            int[] imagePixels = this.computePixels(this.bits);
            this.pixels = imagePixels;
            BufferedImage bi = new BufferedImage(this.width, this.height, 2);
            bi.setRGB(0, 0, this.width, this.height, imagePixels, 0, this.width);
            this.setImage(bi);
        }
        if (this.imageFilter != null) {
            this.setImage(this.filterImage(this.bitmap));
        }
        this.setShape();
        this.setNeedToRegenerate(false);
        return true;
    }

    public void setLinePaint(Paint value) {
        super.setLinePaint(value);
        if (!this.selected) {
            this.setNeedToRegenerate(true);
        }
    }

    public void setSelectPaint(Paint value) {
        super.setSelectPaint(value);
        if (this.selected) {
            this.setNeedToRegenerate(true);
        }
    }

    public void setFillPaint(Paint value) {
        super.setFillPaint(value);
        this.setNeedToRegenerate(true);
    }

    public void select() {
        if (!this.isSelected()) {
            super.select();
            this.setNeedToRegenerate(true);
        }
    }

    public void deselect() {
        if (this.isSelected()) {
            super.deselect();
            this.setNeedToRegenerate(true);
        }
    }
}

