/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.geom;

import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.geom.BasicGeometry;
import com.bbn.openmap.proj.DrawUtil;
import com.bbn.openmap.proj.GeoProj;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;

public abstract class PolygonGeometry
extends BasicGeometry
implements Serializable,
OMGeometry {
    protected float[][] xpoints = new float[0][0];
    protected float[][] ypoints = new float[0][0];
    protected boolean isPolygon = true;
    protected boolean doShapes = true;

    protected PolygonGeometry() {
    }

    public void setDoShapes(boolean set) {
        this.doShapes = set;
    }

    public boolean getDoShapes() {
        return this.doShapes;
    }

    protected void setIsPolygon(boolean set) {
        this.isPolygon = set;
    }

    public boolean getIsPolygon() {
        return this.isPolygon;
    }

    protected abstract GeneralPath createShape();

    public float distance(double x, double y) {
        if (this.getShape() != null) {
            return super.distance(x, y);
        }
        float distance = Float.POSITIVE_INFINITY;
        if (this.getNeedToRegenerate()) {
            return distance;
        }
        float[][] xpts = this.xpoints;
        float[][] ypts = this.ypoints;
        int len = xpts.length;
        for (int i = 0; i < len; ++i) {
            float[] _x = xpts[i];
            float[] _y = ypts[i];
            if (DrawUtil.inside_polygon(_x, _y, x, y)) {
                return 0.0f;
            }
            float temp = DrawUtil.closestPolyDistance(_x, _y, x, y, false);
            if (!(temp < distance)) continue;
            distance = temp;
        }
        return distance;
    }

    public synchronized GeneralPath getShape() {
        GeneralPath shape = super.getShape();
        if (shape == null && !this.getNeedToRegenerate() && !this.doShapes) {
            shape = this.createShape();
            this.setShape(shape);
        }
        return shape;
    }

    public static class Offset
    extends XY {
        public static final int COORDMODE_ORIGIN = 0;
        public static final int COORDMODE_PREVIOUS = 1;
        protected double lat = 0.0;
        protected double lon = 0.0;
        protected int coordMode = 0;

        public Offset(double latPoint, double lonPoint, float[] xypoints, int cMode) {
            this.setLocation(latPoint, lonPoint, 0, xypoints);
            this.setCoordMode(cMode);
        }

        public Offset(double latPoint, double lonPoint, float[] xPoints, float[] yPoints, int cMode) {
            this.setLocation(latPoint, lonPoint, 0, xPoints, yPoints);
            this.setCoordMode(cMode);
        }

        public void setLocation(double latPoint, double lonPoint, int units, float[] xypoints) {
            if (units == 0) {
                this.lat = ProjMath.degToRad(latPoint);
                this.lon = ProjMath.degToRad(lonPoint);
            } else {
                this.lat = latPoint;
                this.lon = lonPoint;
            }
            int end = xypoints.length >> 1;
            this.xs = new float[end];
            this.ys = new float[end];
            int i = 0;
            int j = 0;
            while (i < end) {
                this.xs[i] = xypoints[j];
                this.ys[i] = xypoints[j + 1];
                ++i;
                j += 2;
            }
            this.setNeedToRegenerate(true);
        }

        public void setLocation(double latPoint, double lonPoint, int units, float[] xPoints, float[] yPoints) {
            if (units == 0) {
                this.lat = ProjMath.degToRad(latPoint);
                this.lon = ProjMath.degToRad(lonPoint);
            } else {
                this.lat = latPoint;
                this.lon = lonPoint;
            }
            this.xs = xPoints;
            this.ys = yPoints;
            this.setNeedToRegenerate(true);
        }

        public void setCoordMode(int coordMode) {
            this.coordMode = coordMode;
        }

        public int getCoordMode() {
            return this.coordMode;
        }

        public void setLat(double lat) {
            this.lat = ProjMath.degToRad(lat);
            this.setNeedToRegenerate(true);
        }

        public double getLat() {
            return ProjMath.radToDeg(this.lat);
        }

        public void setLon(double lon) {
            this.lon = ProjMath.degToRad(lon);
            this.setNeedToRegenerate(true);
        }

        public double getLon() {
            return ProjMath.radToDeg(this.lon);
        }

        public boolean generate(Projection proj) {
            if (proj == null) {
                Debug.message("omgraphic", "OMPoly: null projection in generate!");
                this.setNeedToRegenerate(true);
                return false;
            }
            if (this.xs == null) {
                Debug.message("omgraphic", "OMPoly offset rendertype null coordinates");
                return false;
            }
            int npts = this.xs.length;
            float[] _x = new float[npts];
            float[] _y = new float[npts];
            Point origin = new Point();
            if (proj instanceof GeoProj) {
                ((GeoProj)proj).forward(this.lat, this.lon, (Point2D)origin, true);
            } else {
                proj.forward(Math.toDegrees(this.lat), Math.toDegrees(this.lon), (Point2D)origin);
            }
            if (this.coordMode == 0) {
                for (int i = 0; i < npts; ++i) {
                    _x[i] = this.xs[i] + (float)origin.x;
                    _y[i] = this.ys[i] + (float)origin.y;
                }
            } else {
                _x[0] = this.xs[0] + (float)origin.x;
                _y[0] = this.ys[0] + (float)origin.y;
                for (int i = 1; i < npts; ++i) {
                    _x[i] = this.xs[i] + _x[i - 1];
                    _y[i] = this.ys[i] + _y[i - 1];
                }
            }
            this.xpoints = new float[1][0];
            this.xpoints[0] = _x;
            this.ypoints = new float[1][0];
            this.ypoints[0] = _y;
            this.setShape(this.doShapes ? this.createShape() : null);
            this.setNeedToRegenerate(false);
            return true;
        }

        public int getRenderType() {
            return 3;
        }
    }

    public static class XY
    extends PolygonGeometry {
        protected float[] xs = null;
        protected float[] ys = null;

        protected XY() {
        }

        public XY(float[] xypoints) {
            this.setLocation(xypoints);
        }

        public XY(float[] xPoints, float[] yPoints) {
            this.setLocation(xPoints, yPoints);
        }

        public void setLocation(float[] xypoints) {
            int end = xypoints.length >> 1;
            this.xs = new float[end];
            this.ys = new float[end];
            int i = 0;
            int j = 0;
            while (i < end) {
                this.xs[i] = xypoints[j];
                this.ys[i] = xypoints[j + 1];
                ++i;
                j += 2;
            }
            this.setNeedToRegenerate(true);
        }

        public void setLocation(float[] xPoints, float[] yPoints) {
            this.xs = xPoints;
            this.ys = yPoints;
            this.setNeedToRegenerate(true);
        }

        public void setXs(float[] x) {
            this.xs = x;
            this.setNeedToRegenerate(true);
        }

        public float[] getXs() {
            return this.xs;
        }

        public void setYs(float[] y) {
            this.ys = y;
            this.setNeedToRegenerate(true);
        }

        public float[] getYs() {
            return this.ys;
        }

        public boolean generate(Projection proj) {
            if (proj == null) {
                Debug.message("omgraphic", "OMPoly: null projection in generate!");
                this.setNeedToRegenerate(true);
                return false;
            }
            if (this.xs == null) {
                Debug.message("omgraphic", "OMPoly x/y rendertype null coordinates");
                return false;
            }
            this.xpoints = new float[1][0];
            this.xpoints[0] = this.xs;
            this.ypoints = new float[1][0];
            this.ypoints[0] = this.ys;
            if (this.doShapes) {
                this.setShape(this.createShape());
            } else {
                this.setShape(null);
            }
            this.setNeedToRegenerate(false);
            return true;
        }

        protected GeneralPath createShape() {
            if (this.getNeedToRegenerate()) {
                return null;
            }
            return BasicGeometry.createShape(this.xpoints[0], this.ypoints[0], this.isPolygon);
        }

        public int getRenderType() {
            return 2;
        }
    }

    public static class LL
    extends PolygonGeometry {
        protected double[] rawllpts = null;
        protected int nsegs = -1;

        public LL(double[] llPoints, int units, int lType, int nsegs) {
            this.setLineType(lType);
            this.setLocation(llPoints, units);
            this.setNumSegs(nsegs);
        }

        public LL(double[] llPoints, int units, int lType) {
            this(llPoints, units, lType, -1);
        }

        public void setLocation(double[] llPoints, int units) {
            if (units == 0) {
                ProjMath.arrayDegToRad(llPoints);
            }
            this.rawllpts = llPoints;
            this.setNeedToRegenerate(true);
        }

        public double[] getLatLonArray() {
            return this.rawllpts;
        }

        public void setNumSegs(int nsegs) {
            this.nsegs = nsegs;
        }

        public int getNumSegs() {
            return this.nsegs;
        }

        public boolean generate(Projection proj) {
            this.setNeedToRegenerate(true);
            if (proj == null) {
                Debug.message("omgraphic", "OMPoly: null projection in generate!");
                return false;
            }
            ArrayList<float[]> vector = proj instanceof GeoProj ? ((GeoProj)proj).forwardPoly(this.rawllpts, this.lineType, this.nsegs, this.isPolygon) : proj.forwardPoly(this.rawllpts, this.isPolygon);
            int size = vector.size();
            if (!this.doShapes) {
                this.xpoints = new float[size / 2][0];
                this.ypoints = new float[this.xpoints.length][0];
            }
            GeneralPath projectedShape = null;
            int i = 0;
            int j = 0;
            while (i < size) {
                if (this.doShapes) {
                    GeneralPath gp = BasicGeometry.createShape(vector.get(i), vector.get(i + 1), this.isPolygon);
                    projectedShape = LL.appendShapeEdge(projectedShape, gp, false);
                } else {
                    this.xpoints[j] = vector.get(i);
                    this.ypoints[j] = vector.get(i + 1);
                }
                i += 2;
                ++j;
            }
            this.setShape(projectedShape);
            this.setNeedToRegenerate(false);
            return true;
        }

        protected GeneralPath createShape() {
            if (this.getNeedToRegenerate()) {
                return null;
            }
            int size = this.xpoints.length;
            GeneralPath projectedShape = null;
            for (int i = 0; i < size; ++i) {
                GeneralPath gp = BasicGeometry.createShape(this.xpoints[i], this.ypoints[i], this.isPolygon);
                projectedShape = LL.appendShapeEdge(projectedShape, gp, false);
            }
            return projectedShape;
        }

        public int getRenderType() {
            return 1;
        }
    }
}

