/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.time;

import com.bbn.openmap.omGraphics.time.TemporalPoint;
import com.bbn.openmap.omGraphics.time.TemporalRecord;
import com.bbn.openmap.omGraphics.time.TemporalRecordComparator;
import com.bbn.openmap.omGraphics.time.TemporalSupport;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.proj.coords.LatLonPoint;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemporalPointSupport
extends TemporalSupport {
    protected int renderType = 0;

    public TemporalPointSupport(int renderType) {
        this.renderType = renderType;
    }

    public TreeSet<TemporalPoint> createTemporalSet() {
        if (this.temporals == null) {
            this.temporals = new TreeSet<TemporalRecord>(new TemporalRecordComparator());
        }
        return this.temporals;
    }

    public Iterator<TemporalPoint> iterator() {
        return this.temporals.iterator();
    }

    @Override
    protected TemporalRecord interpolate(long time, TemporalRecord previous, TemporalRecord next) {
        TemporalRecord ret = null;
        double top = time - previous.getTime();
        double bottom = next.getTime() - previous.getTime();
        double percent = top / bottom;
        switch (this.renderType) {
            case 2: {
                ret = super.interpolate(time, previous, next);
                break;
            }
            default: {
                Point2D prevPt = ((TemporalPoint)previous).getLocation();
                Point2D nextPt = ((TemporalPoint)next).getLocation();
                LatLonPoint prevLL = prevPt instanceof LatLonPoint ? (LatLonPoint)prevPt : new LatLonPoint.Double(prevPt);
                LatLonPoint nextLL = nextPt instanceof LatLonPoint ? (LatLonPoint)nextPt : new LatLonPoint.Double(nextPt);
                double[] pts = GreatCircle.greatCircle(prevLL.getRadLat(), prevLL.getRadLon(), nextLL.getRadLat(), nextLL.getRadLon(), 100, true);
                int index = (int)(2.0 * Math.floor(100.0 * percent));
                ret = new TemporalPoint(new LatLonPoint.Double(pts[index], pts[index + 1], true), time);
            }
        }
        return ret;
    }
}

