/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.plugin.esri;

import com.bbn.openmap.Layer;
import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MouseDelegator;
import com.bbn.openmap.dataAccess.shape.DbfTableModel;
import com.bbn.openmap.dataAccess.shape.EsriGraphicList;
import com.bbn.openmap.dataAccess.shape.EsriPolyline;
import com.bbn.openmap.dataAccess.shape.EsriPolylineList;
import com.bbn.openmap.dataAccess.shape.output.DbfOutputStream;
import com.bbn.openmap.dataAccess.shape.output.ShpOutputStream;
import com.bbn.openmap.dataAccess.shape.output.ShxOutputStream;
import com.bbn.openmap.event.NavMouseMode;
import com.bbn.openmap.event.SelectMouseMode;
import com.bbn.openmap.gui.DefaultHelpMenu;
import com.bbn.openmap.gui.LayersMenu;
import com.bbn.openmap.gui.MouseModePanel;
import com.bbn.openmap.gui.OMToolSet;
import com.bbn.openmap.gui.ToolPanel;
import com.bbn.openmap.layer.GraticuleLayer;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.plugin.esri.EsriLayer;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class ExampleApplication
extends JFrame {
    private EsriLayer _drawableLayer = null;
    private MapBean _mapBean = new MapBean();
    private Layer[] _layers = null;
    private LayerHandler _layerHandler = null;
    private OMToolSet _omts = null;
    private ToolPanel _toolPanel = null;
    private JMenuBar _menuBar = new JMenuBar();
    private MouseDelegator _mouseDelegator = null;
    private MouseModePanel _mouseModePanel = null;
    private DefaultHelpMenu _defaultHelpMenu = null;
    private JMenu _fileMenu = null;
    private LayersMenu _layersMenu = null;
    private JMenuItem _openFileChooser = null;
    private JMenuItem _saveFileChooser = null;
    private JMenuItem _showTable = null;
    private JMenuItem _httpExample = null;
    private JMenuItem _exit = null;
    private JMenuItem _addShape = null;
    private JMenuItem _setModel = null;

    public ExampleApplication() {
        this._toolPanel = new ToolPanel();
        this._omts = new OMToolSet();
        this._omts.findAndInit(this._mapBean);
        this._mouseDelegator = new MouseDelegator(this._mapBean);
        this._mouseModePanel = new MouseModePanel(this._mouseDelegator);
        NavMouseMode nmm = new NavMouseMode();
        SelectMouseMode smm = new SelectMouseMode();
        this._mouseDelegator.addMouseMode(nmm);
        this._mouseDelegator.addMouseMode(smm);
        this.setupUI();
    }

    public String getRemoteFile() {
        Object[] urls = new Object[]{"http://www.somewebserver.com/omdemo/resources/cities", "http://www.somewebserver.com/omdemo/resources/rivers", "http://www.somewebserver.com/omdemo/resources/southwest", "http://www.somewebserver.com/omdemo/resources/states"};
        String url = (String)JOptionPane.showInputDialog(null, "Select a url", "Input", 1, null, urls, urls[0]);
        return url;
    }

    private EsriLayer pickEsriLayer() {
        Layer[] layers = this._layerHandler.getLayers();
        Vector<String> vector = new Vector<String>();
        for (int n = 0; n <= layers.length - 1; ++n) {
            if (!(layers[n] instanceof EsriLayer)) continue;
            String name = layers[n].getName();
            vector.add(name);
        }
        Object[] objects = vector.toArray();
        if (objects.length > 0) {
            String selected = (String)JOptionPane.showInputDialog(null, "Choose one", "Input", 1, null, objects, objects[0]);
            for (int n = 0; n <= layers.length - 1; ++n) {
                String name = layers[n].getName();
                if (!name.equalsIgnoreCase(selected)) continue;
                return (EsriLayer)layers[n];
            }
        }
        return null;
    }

    public void setupUI() {
        this.getContentPane().setLayout(new BorderLayout());
        this.setSize(640, 480);
        this._mapBean.setCenter(new LatLonPoint.Double(43.0, -95.0));
        this._mapBean.setScale(1.2E8f);
        this._layers = new Layer[1];
        Properties props = new Properties();
        props.put("prettyName", "Graticule");
        props.put("showRuler", "true");
        props.put("show1And5Lines", "true");
        props.put("threshold", "2");
        props.put("10DegreeColor", "FF000000");
        props.put("5DegreeColor", "FF009900");
        props.put("1DegreeColor", "FF003300");
        props.put("equatorColor", "FFFF0000");
        props.put("dateLineColor", "FF000099");
        props.put("specialLineColor", "FF000000");
        props.put("textColor", "FF000000");
        GraticuleLayer graticule = new GraticuleLayer();
        graticule.setProperties(props);
        this._layers[0] = graticule;
        this._layerHandler = new LayerHandler(this._layers);
        this._layerHandler.addLayerListener(this._mapBean);
        this._layersMenu = new LayersMenu(this._layerHandler);
        this._fileMenu = new JMenu("File");
        this._httpExample = new JMenuItem("HTTP Example");
        this._httpExample.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    String url = ExampleApplication.this.stripExtension(ExampleApplication.this.getRemoteFile(), "shp");
                    URL dbf = null;
                    URL shp = null;
                    URL shx = null;
                    dbf = new URL(url + ".dbf");
                    shp = new URL(url + ".shp");
                    shx = new URL(url + ".shx");
                    EsriLayer layer = new EsriLayer(url, dbf, shp, shx);
                    ExampleApplication.this._layerHandler.addLayer(layer);
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
        });
        this._showTable = new JMenuItem("Show Table");
        this._showTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EsriLayer layer = ExampleApplication.this.pickEsriLayer();
                ExampleApplication.this.showTable(layer);
            }
        });
        this._setModel = new JMenuItem("Set Model");
        this._setModel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    ExampleApplication.this._drawableLayer = new EsriLayer("Drawable Layer", 3, 1);
                    ExampleApplication.this._drawableLayer.setName("Drawable Layer");
                    ExampleApplication.this._layerHandler.addLayer(ExampleApplication.this._drawableLayer);
                    DbfTableModel model = new DbfTableModel(1);
                    model.setDecimalCount(0, (byte)0);
                    model.setLength(0, 10);
                    model.setColumnName(0, "Column1");
                    model.setType(0, (byte)67);
                    ExampleApplication.this._drawableLayer.setModel(model);
                    ExampleApplication.this._addShape.setEnabled(true);
                    ExampleApplication.this._setModel.setEnabled(false);
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
        });
        this._addShape = new JMenuItem("Add Shape");
        this._addShape.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EsriPolylineList shapeData = new EsriPolylineList();
                ArrayList<Object> tabularData = new ArrayList<Object>();
                double[] part0 = new double[]{35.0, -120.0, -25.0, -95.0, 56.0, -30.0};
                double[] part1 = new double[]{-15.0, -110.0, 13.0, -80.0, -25.0, 10.0};
                EsriPolyline poly0 = new EsriPolyline(part0, 0, 2);
                EsriPolyline poly1 = new EsriPolyline(part1, 0, 2);
                shapeData.add(poly0);
                shapeData.add(poly1);
                shapeData.generate(ExampleApplication.this._mapBean.getProjection());
                tabularData.add(0, "a value");
                ExampleApplication.this._drawableLayer.addRecord(shapeData, tabularData);
                ExampleApplication.this._drawableLayer.repaint();
            }
        });
        this._openFileChooser = new JMenuItem("Add Shape File");
        this._openFileChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setFileFilter(new EsriFilter());
                int returnVal = fileChooser.showOpenDialog(null);
                if (returnVal == 0) {
                    try {
                        File shp = fileChooser.getSelectedFile();
                        String s = shp.getCanonicalPath();
                        int pos1 = s.lastIndexOf(46);
                        String name = s.substring(0, pos1);
                        File shx = new File(s.substring(0, pos1) + ".shx");
                        File dbf = new File(s.substring(0, pos1) + ".dbf");
                        EsriLayer layer = new EsriLayer(name, dbf.toURI().toURL(), shp.toURI().toURL(), shx.toURI().toURL());
                        ExampleApplication.this._layerHandler.addLayer(layer);
                    }
                    catch (Exception exception) {
                        System.out.println(exception);
                    }
                }
            }
        });
        this._exit = new JMenuItem("Exit");
        this._exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        this._saveFileChooser = new JMenuItem("Save File");
        this._saveFileChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EsriLayer layer = ExampleApplication.this.pickEsriLayer();
                if (layer != null) {
                    JFileChooser fileChooser = new JFileChooser();
                    fileChooser.setFileFilter(new EsriFilter());
                    int returnVal = fileChooser.showSaveDialog(null);
                    if (returnVal == 0) {
                        try {
                            File file = fileChooser.getSelectedFile();
                            String path = file.getCanonicalPath();
                            EsriGraphicList list = layer.getEsriGraphicList();
                            ShpOutputStream pos = new ShpOutputStream(new FileOutputStream(path + ".shp"));
                            int[][] indexData = pos.writeGeometry(list);
                            ShxOutputStream xos = new ShxOutputStream(new FileOutputStream(path + ".shx"));
                            xos.writeIndex(indexData, list.getType(), list.getExtents());
                            DbfOutputStream dos = new DbfOutputStream(new FileOutputStream(path + ".dbf"));
                            dos.writeModel(layer.getModel());
                        }
                        catch (Exception exception) {
                            System.out.println(exception);
                        }
                    }
                }
            }
        });
        this._fileMenu.add(this._openFileChooser);
        this._fileMenu.add(this._saveFileChooser);
        this._fileMenu.add(new JSeparator());
        this._fileMenu.add(this._showTable);
        this._fileMenu.add(new JSeparator());
        this._fileMenu.add(this._httpExample);
        this._fileMenu.add(new JSeparator());
        this._fileMenu.add(this._setModel);
        this._addShape.setEnabled(false);
        this._fileMenu.add(this._addShape);
        this._fileMenu.add(new JSeparator());
        this._fileMenu.add(this._exit);
        this._defaultHelpMenu = new DefaultHelpMenu();
        this._menuBar.add(this._fileMenu);
        this._menuBar.add(this._layersMenu);
        this._menuBar.add(this._defaultHelpMenu);
        this._omts.add(this._mouseModePanel);
        this._toolPanel.add(this._omts);
        this.setJMenuBar(this._menuBar);
        this.getContentPane().add((Component)this._toolPanel, "North");
        this.getContentPane().add((Component)this._mapBean, "Center");
        this.setVisible(true);
    }

    public void showTable(final EsriLayer layer) {
        JFrame frame = new JFrame("Table");
        DbfTableModel model = layer.getModel();
        JTable table = new JTable(model);
        JScrollPane pane = new JScrollPane(table);
        frame.getContentPane().add((Component)pane, "Center");
        ListSelectionModel lsm = table.getSelectionModel();
        lsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm2 = (ListSelectionModel)e.getSource();
                if (!lsm2.isSelectionEmpty()) {
                    int index = lsm2.getMinSelectionIndex();
                    EsriGraphicList list = layer.getEsriGraphicList();
                    OMGraphic graphic = list.getOMGraphicAt(index);
                    graphic.select();
                    list.generate(ExampleApplication.this._mapBean.getProjection());
                    layer.repaint();
                }
            }
        });
        frame.setSize(400, 300);
        frame.setVisible(true);
    }

    private String stripExtension(String file, String extension) {
        if (file.endsWith(extension)) {
            int index = file.lastIndexOf(46);
            String s = file.substring(0, index);
            return s;
        }
        return file;
    }

    public static void main(String[] args) {
        Debug.init();
        ExampleApplication example = new ExampleApplication();
        example.setVisible(true);
    }

    private class EsriFilter
    extends FileFilter {
        private EsriFilter() {
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(f);
            if (extension != null) {
                return extension.equalsIgnoreCase("shp");
            }
            return false;
        }

        private String getExtension(File f) {
            String ext = null;
            String s = f.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                ext = s.substring(i + 1).toLowerCase();
            }
            return ext;
        }

        public String getDescription() {
            return "Feature Data Source";
        }
    }
}

