/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.Serializable;

public class Cartesian
extends Proj
implements Projection,
Serializable {
    public static final transient String CartesianName = "Cartesian";
    protected double leftLimit;
    protected double rightLimit;
    protected double topLimit;
    protected double bottomLimit;
    protected Point2D limitAnchorPoint;
    protected double scaleFactor;
    protected transient double hWidth;
    protected transient double hHeight;
    protected transient double SFScale;
    protected transient AffineTransform transform1;
    protected transient AffineTransform transform2;
    protected transient AffineTransform transform4;

    public Cartesian(Point2D center, float scale, int width, int height) {
        super(center, scale, width, height);
    }

    public void init() {
        this.scaleFactor = 1.0E8;
        this.leftLimit = Double.NEGATIVE_INFINITY;
        this.rightLimit = Double.POSITIVE_INFINITY;
        this.topLimit = Double.POSITIVE_INFINITY;
        this.bottomLimit = Double.NEGATIVE_INFINITY;
    }

    protected void computeParameters() {
        this.hWidth = (double)this.width / 2.0;
        this.hHeight = (double)this.height / 2.0;
        this.SFScale = this.scaleFactor / this.scale;
        this.checkLimits();
        this.transform1 = AffineTransform.getTranslateInstance(-this.centerX, -this.centerY);
        this.transform2 = AffineTransform.getScaleInstance(this.SFScale, -this.SFScale);
        this.transform4 = AffineTransform.getTranslateInstance(this.hWidth, this.hHeight);
    }

    protected void checkLimits() {
        if (this.leftLimit != Double.NEGATIVE_INFINITY || this.rightLimit != Double.POSITIVE_INFINITY || this.topLimit != Double.POSITIVE_INFINITY || this.bottomLimit != Double.NEGATIVE_INFINITY) {
            this.checkLimits(true);
        }
    }

    protected void checkLimits(boolean checkScale) {
        double newScale;
        Point2D p1;
        Point2D p2;
        if (this.limitAnchorPoint != null) {
            this.centerX = this.limitAnchorPoint.getX();
            this.centerY = this.limitAnchorPoint.getY();
        }
        if ((p2 = this.checkUpperLimits()) != null) {
            this.centerX = p2.getX();
            this.centerY = p2.getY();
        }
        if ((p1 = this.checkLowerLimits()) != null) {
            this.centerX = p1.getX();
            this.centerY = p1.getY();
        }
        if (checkScale && p1 != null && p2 != null && (newScale = this.checkScaleAgainstLimits()) != this.scale) {
            this.scale = newScale;
            this.SFScale = this.scaleFactor / this.scale;
            this.checkLimits(false);
        }
    }

    protected Point2D checkLowerLimits() {
        Point2D.Double p1 = new Point2D.Double();
        Point2D p2 = null;
        double moveX = 0.0;
        double moveY = 0.0;
        this.inverse(0.0, (double)this.height, p1);
        if (((Point2D)p1).getX() < this.leftLimit) {
            p2 = this.forward(this.centerY, this.leftLimit, p2);
            moveX = p2.getX();
        }
        if (((Point2D)p1).getY() < this.bottomLimit) {
            p2 = this.forward(this.bottomLimit, this.centerX, p2);
            moveY = (double)this.height - p2.getY();
        }
        if (p2 != null) {
            this.inverse(this.hWidth + moveX, this.hHeight - moveY, p2);
        }
        return p2;
    }

    protected Point2D checkUpperLimits() {
        Point2D.Double p1 = new Point2D.Double();
        Point2D p2 = null;
        double moveX = 0.0;
        double moveY = 0.0;
        this.inverse((double)this.width, 0.0, p1);
        if (((Point2D)p1).getX() > this.rightLimit) {
            p2 = this.forward(this.centerY, this.rightLimit, p2);
            moveX = (double)this.width - p2.getX();
        }
        if (((Point2D)p1).getY() > this.topLimit) {
            p2 = this.forward(this.topLimit, this.centerX, p2);
            moveY = p2.getY();
        }
        if (p2 != null) {
            this.inverse(this.hWidth - moveX, this.hHeight + moveY, p2);
        }
        return p2;
    }

    protected double checkScaleAgainstLimits() {
        Point2D p1 = this.getUpperLeft();
        Point2D p2 = this.getLowerRight();
        double x = p1.getX();
        double y = p1.getY();
        if (this.topLimit != Double.POSITIVE_INFINITY) {
            y = this.topLimit;
        }
        if (this.leftLimit != Double.NEGATIVE_INFINITY) {
            x = this.leftLimit;
        }
        p1.setLocation(x, y);
        x = p2.getX();
        y = p2.getY();
        if (this.bottomLimit != Double.NEGATIVE_INFINITY) {
            y = this.bottomLimit;
        }
        if (this.rightLimit != Double.POSITIVE_INFINITY) {
            x = this.rightLimit;
        }
        p2.setLocation(x, y);
        return this.getScale(p1, p2, p1, p2);
    }

    public Point2D forward(double wy, double wx, Point2D mapPoint) {
        double x = (wx - this.centerX) * this.SFScale + this.hWidth;
        double y = this.hHeight - (wy - this.centerY) * this.SFScale;
        if (mapPoint == null) {
            mapPoint = new Point2D.Double(x, y);
        } else {
            mapPoint.setLocation(x, y);
        }
        return mapPoint;
    }

    public Point2D inverse(double x, double y, Point2D worldPoint) {
        double worldPointX = (x - this.hWidth) / this.SFScale + this.centerX;
        double worldPointY = (this.hHeight - y) / this.SFScale + this.centerY;
        if (worldPoint == null) {
            worldPoint = new Point2D.Double(worldPointX, worldPointY);
        } else {
            worldPoint.setLocation(worldPointX, worldPointY);
        }
        return worldPoint;
    }

    public void pan(double Az, double c) {
        double currentX = this.centerX;
        double currentY = this.centerY;
        this.setCenter(new Point2D.Double(currentX -= c * Math.sin(Math.toRadians(Az) + Math.PI), currentY -= c * Math.cos(Math.toRadians(Az) + Math.PI)));
    }

    public void pan(double Az) {
        this.pan(Az, this.getUpperLeft().distance(this.getLowerRight()) / 4.0);
    }

    public String getName() {
        return CartesianName;
    }

    public float getScale(Point2D ulWorldPoint, Point2D lrWorldPoint, Point2D point1, Point2D point2) {
        try {
            double deltaPix;
            double worldCoords;
            double dx = Math.abs(lrWorldPoint.getX() - ulWorldPoint.getX());
            double dy = Math.abs(lrWorldPoint.getY() - ulWorldPoint.getY());
            if (dx <= dy) {
                worldCoords = dx;
                deltaPix = Math.abs(point2.getX() - point1.getX());
            } else {
                worldCoords = dy;
                deltaPix = Math.abs(point2.getY() - point1.getY());
            }
            return (float)(worldCoords / deltaPix * this.scaleFactor);
        }
        catch (NullPointerException npe) {
            Debug.error("CartesianProjection.getScale(): caught null pointer exception.");
            return Float.MAX_VALUE;
        }
    }

    public boolean isPlotable(double lat, double lon) {
        return true;
    }

    public Point2D getCenter() {
        return new Point2D.Double(this.centerX, this.centerY);
    }

    public double getBottomLimit() {
        return this.bottomLimit;
    }

    public void setBottomLimit(double bottomLimit) {
        this.bottomLimit = bottomLimit;
        this.computeParameters();
    }

    public double getLeftLimit() {
        return this.leftLimit;
    }

    public void setLeftLimit(double leftLimit) {
        this.leftLimit = leftLimit;
        this.computeParameters();
    }

    public Point2D getLimitAnchorPoint() {
        return this.limitAnchorPoint;
    }

    public void setLimitAnchorPoint(Point2D limitAnchorPoint) {
        this.limitAnchorPoint = limitAnchorPoint;
        this.computeParameters();
    }

    public double getRightLimit() {
        return this.rightLimit;
    }

    public void setRightLimit(double rightLimit) {
        this.rightLimit = rightLimit;
        this.computeParameters();
    }

    public double getTopLimit() {
        return this.topLimit;
    }

    public void setTopLimit(double topLimit) {
        this.topLimit = topLimit;
        this.computeParameters();
    }

    public void setLimits(double top, double bottom, double left, double right, Point2D anchor) {
        this.topLimit = top;
        this.bottomLimit = bottom;
        this.leftLimit = left;
        this.rightLimit = right;
        this.limitAnchorPoint = anchor;
        this.computeParameters();
    }
}

