/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.proj.GeoProj;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Cylindrical
extends GeoProj {
    protected transient Point world;
    protected transient int half_world;

    public Cylindrical(LatLonPoint center, float scale, int width, int height) {
        super(center, scale, width, height);
    }

    @Override
    public String toString() {
        return " world(" + this.world.x + "," + this.world.y + ")" + super.toString();
    }

    @Override
    protected void init() {
        super.init();
        this.minscale = Math.ceil(this.planetPixelCircumference / 2.147483647E9);
        if (this.minscale < 1.0) {
            this.minscale = 1.0;
        }
    }

    @Override
    protected void computeParameters() {
        if (this.scale < this.minscale) {
            this.scale = this.minscale;
        }
        this.maxscale = Math.floor(this.planetPixelCircumference / (double)this.width);
        if (this.maxscale < this.minscale) {
            this.maxscale = this.minscale;
        }
        if (this.scale > this.maxscale) {
            this.scale = this.maxscale;
        }
        this.scaled_radius = this.planetPixelRadius / this.scale;
        if (this.world == null) {
            this.world = new Point(0, 0);
        }
        this.world.x = (int)(this.planetPixelCircumference / this.scale);
        this.half_world = this.world.x / 2;
        this.XSCALE_THRESHOLD = (int)(this.planetPixelCircumference / 64000.0);
        if (Debug.debugging("proj")) {
            Debug.output("Cylindrical.computeParameters(): world.x = " + this.world.x + " half_world = " + this.half_world + " XSCALE_THRESHOLD = " + this.XSCALE_THRESHOLD);
        }
    }

    @Override
    public LatLonPoint getUpperLeft() {
        return this.inverse(0.0, 0.0, new LatLonPoint.Double());
    }

    @Override
    public LatLonPoint getLowerRight() {
        return this.inverse(this.width - 1, this.height - 1, new LatLonPoint.Double());
    }

    @Override
    public boolean forwardRaw(float[] rawllpts, int rawoff, float[] xcoords, float[] ycoords, boolean[] visible, int copyoff, int copylen) {
        Point2D.Float temp = new Point2D.Float();
        int end = copylen + copyoff;
        int i = copyoff;
        int j = rawoff;
        while (i < end) {
            this.forward(rawllpts[j], rawllpts[j + 1], (Point2D)temp, true);
            xcoords[i] = (float)((Point2D)temp).getX();
            ycoords[i] = (float)((Point2D)temp).getY();
            visible[i] = true;
            ++i;
            j += 2;
        }
        return true;
    }

    @Override
    public boolean forwardRaw(double[] rawllpts, int rawoff, float[] xcoords, float[] ycoords, boolean[] visible, int copyoff, int copylen) {
        Point2D.Float temp = new Point2D.Float();
        int end = copylen + copyoff;
        int i = copyoff;
        int j = rawoff;
        while (i < end) {
            this.forward(rawllpts[j], rawllpts[j + 1], (Point2D)temp, true);
            xcoords[i] = (float)((Point2D)temp).getX();
            ycoords[i] = (float)((Point2D)temp).getY();
            visible[i] = true;
            ++i;
            j += 2;
        }
        return true;
    }

    @Override
    protected ArrayList<float[]> _forwardPoly(float[] rawllpts, int ltype, int nsegs, boolean isFilled) {
        int j;
        int i;
        int flag = 0;
        int min = 0;
        int max = 0;
        float xadj = 0.0f;
        int len = rawllpts.length >> 1;
        if (len < 2) {
            return new ArrayList<float[]>(0);
        }
        if (this.isComplicatedLineType(ltype)) {
            return this.doPolyDispatch(rawllpts, ltype, nsegs, isFilled);
        }
        Point2D.Float temp = new Point2D.Float(0.0f, 0.0f);
        float[] xs = new float[len];
        float[] ys = new float[len];
        this.forward(rawllpts[0], rawllpts[1], (Point2D)temp, true);
        float xp = (float)((Point2D)temp).getX();
        xs[0] = (float)((Point2D)temp).getX();
        ys[0] = (float)((Point2D)temp).getY();
        int n = 1;
        int k = 2;
        while (n < len) {
            this.forward(rawllpts[k], rawllpts[k + 1], (Point2D)temp, true);
            xs[n] = (float)((Point2D)temp).getX();
            ys[n] = (float)((Point2D)temp).getY();
            if (Math.abs(xp - xs[n]) >= (float)this.half_world) {
                min = (flag += xp < xs[n] ? -1 : 1) < min ? flag : min;
                max = flag > max ? flag : max;
                xadj = flag * this.world.x;
            }
            xp = (float)((Point2D)temp).getX();
            if (flag != 0) {
                int n2 = n;
                xs[n2] = xs[n2] + xadj;
            }
            ++n;
            k += 2;
        }
        ArrayList<float[]> ret_val = null;
        ret_val = new ArrayList<float[]>(2 + 2 * (max + (min *= -1)));
        ret_val.add(xs);
        ret_val.add(ys);
        float[] altx = null;
        for (i = 1; i <= min; ++i) {
            altx = new float[xs.length];
            xadj = i * this.world.x;
            for (j = 0; j < altx.length; ++j) {
                altx[j] = xs[j] + xadj;
            }
            ret_val.add(altx);
            ret_val.add(ys);
        }
        for (i = 1; i <= max; ++i) {
            altx = new float[xs.length];
            xadj = -i * this.world.x;
            for (j = 0; j < altx.length; ++j) {
                altx[j] = xs[j] + xadj;
            }
            ret_val.add(altx);
            ret_val.add(ys);
        }
        return ret_val;
    }

    @Override
    protected ArrayList<float[]> _forwardPoly(double[] rawllpts, int ltype, int nsegs, boolean isFilled) {
        int j;
        int i;
        int flag = 0;
        int min = 0;
        int max = 0;
        float xadj = 0.0f;
        int len = rawllpts.length >> 1;
        if (len < 2) {
            return new ArrayList<float[]>(0);
        }
        if (this.isComplicatedLineType(ltype)) {
            return this.doPolyDispatch(rawllpts, ltype, nsegs, isFilled);
        }
        Point2D.Float temp = new Point2D.Float(0.0f, 0.0f);
        float[] xs = new float[len];
        float[] ys = new float[len];
        this.forward(rawllpts[0], rawllpts[1], (Point2D)temp, true);
        float xp = (float)((Point2D)temp).getX();
        xs[0] = (float)((Point2D)temp).getX();
        ys[0] = (float)((Point2D)temp).getY();
        int n = 1;
        int k = 2;
        while (n < len) {
            this.forward(rawllpts[k], rawllpts[k + 1], (Point2D)temp, true);
            xs[n] = (float)((Point2D)temp).getX();
            ys[n] = (float)((Point2D)temp).getY();
            if (Math.abs(xp - xs[n]) >= (float)this.half_world) {
                min = (flag += xp < xs[n] ? -1 : 1) < min ? flag : min;
                max = flag > max ? flag : max;
                xadj = flag * this.world.x;
            }
            xp = (float)((Point2D)temp).getX();
            if (flag != 0) {
                int n2 = n;
                xs[n2] = xs[n2] + xadj;
            }
            ++n;
            k += 2;
        }
        ArrayList<float[]> ret_val = null;
        ret_val = new ArrayList<float[]>(2 + 2 * (max + (min *= -1)));
        ret_val.add(xs);
        ret_val.add(ys);
        float[] altx = null;
        for (i = 1; i <= min; ++i) {
            altx = new float[xs.length];
            xadj = i * this.world.x;
            for (j = 0; j < altx.length; ++j) {
                altx[j] = xs[j] + xadj;
            }
            ret_val.add(altx);
            ret_val.add(ys);
        }
        for (i = 1; i <= max; ++i) {
            altx = new float[xs.length];
            xadj = -i * this.world.x;
            for (j = 0; j < altx.length; ++j) {
                altx[j] = xs[j] + xadj;
            }
            ret_val.add(altx);
            ret_val.add(ys);
        }
        return ret_val;
    }

    public static final void dumpPoly(float[] rawllpts, float[] xs, float[] ys) {
        Debug.output("poly:");
        int i = 0;
        for (int j = 0; j < xs.length; ++j) {
            System.out.print("[" + ProjMath.radToDeg(rawllpts[i]) + "," + ProjMath.radToDeg(rawllpts[i + 1]) + "]=");
            Debug.output("(" + xs[j] + "," + ys[j] + ")");
            i += 2;
        }
        Debug.output("");
    }

    public static final void dumpPoly(double[] rawllpts, float[] xs, float[] ys) {
        Debug.output("poly:");
        int i = 0;
        for (int j = 0; j < xs.length; ++j) {
            System.out.print("[" + ProjMath.radToDeg(rawllpts[i]) + "," + ProjMath.radToDeg(rawllpts[i + 1]) + "]=");
            Debug.output("(" + xs[j] + "," + ys[j] + ")");
            i += 2;
        }
        Debug.output("");
    }

    @Override
    public String getName() {
        return "Cylindrical";
    }
}

