/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.proj.ProjectionStackTrigger;
import com.bbn.openmap.util.Debug;
import java.io.Serializable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectionStackSupport
implements Serializable {
    private transient ArrayList<ProjectionStackTrigger> triggers;

    public synchronized void add(ProjectionStackTrigger pt) {
        if (this.triggers == null) {
            this.triggers = new ArrayList();
        }
        if (!this.triggers.contains(pt)) {
            this.triggers.add(pt);
        }
    }

    public synchronized void remove(ProjectionStackTrigger pt) {
        if (this.triggers == null) {
            return;
        }
        this.triggers.remove(pt);
    }

    public synchronized ArrayList<ProjectionStackTrigger> getTriggers() {
        if (this.triggers == null) {
            return null;
        }
        return (ArrayList)this.triggers.clone();
    }

    public int size() {
        return this.triggers.size();
    }

    public void fireStackStatus(boolean enableBackProjections, boolean enableForwardProjections) {
        ArrayList<ProjectionStackTrigger> targets = this.getTriggers();
        if (this.triggers == null) {
            return;
        }
        for (ProjectionStackTrigger target : targets) {
            if (Debug.debugging("projectionstack")) {
                Debug.output("ProjectionStackSupport.fireStackStatus(): target is: " + target);
            }
            target.updateProjectionStackStatus(enableBackProjections, enableForwardProjections);
        }
    }
}

