/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.icon;

import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.tools.icon.IconPart;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class BasicIconPart
implements IconPart,
Cloneable {
    protected AffineTransform baseTransform;
    protected Shape geometry;
    protected Shape clip;
    protected DrawingAttributes renderingAttributes = null;
    protected boolean gradient = false;

    public BasicIconPart(Shape shape) {
        this(shape, null, DrawingAttributes.DEFAULT);
    }

    public BasicIconPart(Shape shape, AffineTransform transform) {
        this(shape, transform, DrawingAttributes.DEFAULT);
    }

    public BasicIconPart(Shape shape, DrawingAttributes da) {
        this(shape, null, da);
    }

    public BasicIconPart(Shape shape, AffineTransform transform, DrawingAttributes da) {
        this.geometry = shape;
        if (transform == null) {
            transform = new AffineTransform();
        }
        this.baseTransform = transform;
        this.setRenderingAttributes(da);
    }

    protected DrawingAttributes getAttributesForRendering(DrawingAttributes da) {
        return this.getRenderingAttributes();
    }

    public void render(Graphics g, int width, int height) {
        this.render(g, width, height, null);
    }

    public void render(Graphics g, int width, int height, DrawingAttributes appDA) {
        AffineTransform transform = AffineTransform.getScaleInstance((double)width / 100.0, (double)height / 100.0);
        transform.concatenate(this.baseTransform);
        Shape clip = this.getClip();
        if (clip != null) {
            g.setClip(new GeneralPath(clip).createTransformedShape(transform));
        }
        Shape shape = new GeneralPath(this.geometry).createTransformedShape(transform);
        this.getAttributesForRendering(appDA).render((Graphics2D)g, shape, this.gradient);
    }

    public void setGradient(boolean value) {
        this.gradient = value;
    }

    public boolean isGradient() {
        return this.gradient;
    }

    public void setClip(Shape clipArea) {
        this.clip = clipArea;
    }

    public Shape getClip() {
        return this.clip;
    }

    public void setGeometry(Shape shape) {
        this.geometry = shape;
    }

    public Shape getGeometry() {
        return this.geometry;
    }

    public void setTransform(AffineTransform af) {
        this.baseTransform = af;
    }

    public AffineTransform getTransform() {
        return this.baseTransform;
    }

    public void setRenderingAttributes(DrawingAttributes da) {
        this.renderingAttributes = da;
    }

    public DrawingAttributes getRenderingAttributes() {
        if (this.renderingAttributes == null) {
            return DrawingAttributes.DEFAULT;
        }
        return this.renderingAttributes;
    }

    public Object clone() {
        BasicIconPart clone = null;
        try {
            clone = (BasicIconPart)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return clone;
    }
}

