/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.j3d;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.tools.j3d.LayerMapContent;
import com.bbn.openmap.tools.j3d.MapContent;
import com.bbn.openmap.tools.j3d.OM3DManager;
import com.bbn.openmap.tools.j3d.OMKeyBehavior;
import com.bbn.openmap.util.Debug;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Background;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.TransformGroup;
import javax.swing.JFrame;

public class MapContentManager
extends OM3DManager {
    protected MapContentManager() {
    }

    public MapContentManager(MapHandler mapHandler, int contentMask) {
        this(mapHandler, new Background(0.0f, 0.0f, 0.0f), contentMask);
    }

    public MapContentManager(MapHandler mapHandler, Background background, int contentMask) {
        this.createWorld(mapHandler, background, contentMask);
    }

    protected void createWorld(MapHandler mapHandler, Background background, int contentMask) {
        this.setSceneBackground(background);
        this.addMapContent(mapHandler, this.objRootBG, contentMask);
    }

    public void compileUniverse() {
        this.universe.makeLive();
    }

    public void addBehavior(Behavior behavior) {
        this.objRootBG.addChild((Node)behavior);
    }

    protected void addMapContent(MapHandler mapHandler, BranchGroup worldGroup, int contentMask) {
        Projection projection = null;
        if (mapHandler != null) {
            MapBean mapBean = (MapBean)mapHandler.get("com.bbn.openmap.MapBean");
            if (mapBean != null) {
                projection = mapBean.getProjection();
            }
            TransformGroup mapTransformGroup = new TransformGroup();
            mapTransformGroup.setCapability(17);
            mapTransformGroup.setCapability(18);
            Debug.message((String)"3d", (String)"OM3DViewer: adding map content");
            BoundingSphere bs = new BoundingSphere(ORIGIN, this.boundsDimension);
            this.background.setApplicationBounds((Bounds)bs);
            mapTransformGroup.addChild((Node)this.background);
            this.createMapContent(mapTransformGroup, mapHandler, contentMask);
            AmbientLight ambientLight = new AmbientLight();
            ambientLight.setInfluencingBounds((Bounds)bs);
            worldGroup.addChild((Node)ambientLight);
            Behavior beh = this.getMotionBehavior((TransformGroup)this.getCamera().getNode(), projection);
            beh.setSchedulingBounds((Bounds)bs);
            worldGroup.addChild((Node)beh);
            worldGroup.addChild((Node)mapTransformGroup);
        }
    }

    protected void createMapContent(TransformGroup mapTransformGroup, MapHandler mapHandler, int contentMask) {
        if ((contentMask & 1) != 0) {
            mapTransformGroup.addChild((Node)this.createLayerMapContent(mapHandler));
        }
        mapTransformGroup.addChild((Node)this.createMapContent(mapHandler, contentMask));
    }

    protected Group createLayerMapContent(MapHandler mapHandler) {
        return new LayerMapContent(mapHandler);
    }

    protected Group createMapContent(MapHandler mapHandler, int contentMask) {
        return new MapContent(mapHandler, contentMask);
    }

    public Behavior getMotionBehavior(TransformGroup cameraTransform, Projection projection) {
        return new OMKeyBehavior(cameraTransform, projection);
    }

    public static JFrame getFrame(String title, int width, int height, MapHandler mapHandler, Background background, int contentMask) {
        JFrame frame = new JFrame(title);
        frame.setSize(width, height);
        frame.getContentPane().setLayout(new BorderLayout());
        MapContentManager mc3d = new MapContentManager(mapHandler, background, contentMask);
        mc3d.compileUniverse();
        frame.getContentPane().add("Center", (Component)mc3d.getCanvas());
        return frame;
    }
}

