/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.community.io;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.util.TGMessageDialogUtil;
import org.herac.tuxguitar.app.view.main.TGWindow;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.community.TGCommunitySingleton;
import org.herac.tuxguitar.community.auth.TGCommunityAuthDialog;
import org.herac.tuxguitar.community.io.TGShareFile;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UILegendPanel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIReadOnlyTextField;
import org.herac.tuxguitar.ui.widget.UITextArea;
import org.herac.tuxguitar.ui.widget.UITextField;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;

public class TGShareFileDialog {
    private TGContext context;
    private TGShareFile file;
    private Runnable onSuccess;
    private String errors;

    public TGShareFileDialog(TGContext context, TGShareFile file, String errors, Runnable onSuccess) {
        this.context = context;
        this.file = file;
        this.errors = errors;
        this.onSuccess = onSuccess;
    }

    public void open() {
        this.open(TGWindow.getInstance((TGContext)this.context).getWindow());
    }

    public void open(UIWindow parent) {
        UIFactory uiFactory = TGApplication.getInstance((TGContext)this.context).getFactory();
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(parent, true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
        dialog.setText(TuxGuitar.getProperty((String)"tuxguitar-community.share-dialog.title"));
        UITableLayout groupLayout = new UITableLayout();
        UILegendPanel group = uiFactory.createLegendPanel((UIContainer)dialog);
        group.setLayout((UILayout)groupLayout);
        group.setText(TuxGuitar.getProperty((String)"tuxguitar-community.share-dialog.details"));
        dialogLayout.set((UIControl)group, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(350.0f), null, null);
        UILabel usernameLabel = uiFactory.createLabel((UIContainer)group);
        usernameLabel.setText(TuxGuitar.getProperty((String)"tuxguitar-community.share-dialog.details.user") + ":");
        groupLayout.set((UIControl)usernameLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UIReadOnlyTextField usernameText = uiFactory.createReadOnlyTextField((UIContainer)group);
        usernameText.setText(TGCommunitySingleton.getInstance(this.getContext()).getAuth().getUsername());
        usernameText.setText(TGCommunitySingleton.getInstance(this.getContext()).getAuth().getUsername());
        groupLayout.set((UIControl)usernameText, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UIButton usernameChooser = uiFactory.createButton((UIContainer)group);
        usernameChooser.setText("...");
        usernameChooser.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                new TGCommunityAuthDialog(TGShareFileDialog.this.getContext(), new Runnable(){

                    @Override
                    public void run() {
                        TGCommunitySingleton.getInstance(TGShareFileDialog.this.getContext()).getAuth().update();
                        usernameText.setText(TGCommunitySingleton.getInstance(TGShareFileDialog.this.getContext()).getAuth().getUsername());
                    }
                }, null).open(dialog);
            }
        });
        groupLayout.set((UIControl)usernameChooser, Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_CENTER, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        UILabel titleLabel = uiFactory.createLabel((UIContainer)group);
        titleLabel.setText(TuxGuitar.getProperty((String)"tuxguitar-community.share-dialog.details.title") + ":");
        groupLayout.set((UIControl)titleLabel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UITextField titleText = uiFactory.createTextField((UIContainer)group);
        titleText.setText(this.file.getTitle());
        groupLayout.set((UIControl)titleText, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(2));
        groupLayout.set((UIControl)titleText, "packed_width", (Object)Float.valueOf(0.0f));
        UILabel tagkeysLabel = uiFactory.createLabel((UIContainer)group);
        tagkeysLabel.setText(TuxGuitar.getProperty((String)"tuxguitar-community.share-dialog.details.tagkeys") + ":");
        groupLayout.set((UIControl)tagkeysLabel, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UITextField tagkeysText = uiFactory.createTextField((UIContainer)group);
        tagkeysText.setText(this.file.getTagkeys());
        groupLayout.set((UIControl)tagkeysText, Integer.valueOf(3), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(2));
        groupLayout.set((UIControl)tagkeysText, "packed_width", (Object)Float.valueOf(0.0f));
        UILabel descriptionLabel = uiFactory.createLabel((UIContainer)group);
        descriptionLabel.setText(TuxGuitar.getProperty((String)"tuxguitar-community.share-dialog.details.description") + ":");
        groupLayout.set((UIControl)descriptionLabel, Integer.valueOf(4), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UITextArea descriptionText = uiFactory.createTextArea((UIContainer)group, true, false);
        descriptionText.setText(this.file.getDescription());
        groupLayout.set((UIControl)descriptionText, Integer.valueOf(4), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(2), null, Float.valueOf(100.0f), null);
        groupLayout.set((UIControl)descriptionText, "packed_width", (Object)Float.valueOf(0.0f));
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty((String)"ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGShareFileDialog.this.update(titleText.getText(), tagkeysText.getText(), descriptionText.getText());
                TGShareFileDialog.this.onFinish(dialog, TGShareFileDialog.this.onSuccess);
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGShareFileDialog.this.onFinish(dialog, null);
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        if (this.errors != null) {
            TGMessageDialogUtil.errorMessage((TGContext)this.context, (UIWindow)dialog, (String)this.errors);
        }
        TGDialogUtil.openDialog((UIWindow)dialog, (int)5);
    }

    public void onFinish(UIWindow dialog, Runnable runnable) {
        dialog.dispose();
        if (runnable != null) {
            runnable.run();
        }
    }

    public void update(String title, String tagkeys, String description) {
        this.file.setTitle(title);
        this.file.setTagkeys(tagkeys);
        this.file.setDescription(description);
    }

    public TGContext getContext() {
        return this.context;
    }
}

