/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.tef;

import java.util.Iterator;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGTrack;

class TGSongAdjuster {
    protected TGSong song;
    protected TGSongManager manager;

    public TGSongAdjuster(TGSongManager manager, TGSong song) {
        this.manager = manager;
        this.song = song;
    }

    public TGSong process() {
        Iterator tracks = this.song.getTracks();
        while (tracks.hasNext()) {
            TGTrack track = (TGTrack)tracks.next();
            Iterator measures = track.getMeasures();
            while (measures.hasNext()) {
                TGMeasure measure = (TGMeasure)measures.next();
                this.process(measure);
            }
        }
        return this.song;
    }

    public void process(TGMeasure measure) {
        this.manager.getMeasureManager().orderBeats(measure);
        this.adjustBeats(measure);
    }

    public void adjustBeats(TGMeasure measure) {
        TGBeat previous = null;
        boolean finish = true;
        long measureStart = measure.getStart();
        long measureEnd = measureStart + measure.getLength();
        for (int i = 0; i < measure.countBeats(); ++i) {
            TGBeat beat = measure.getBeat(i);
            long beatStart = beat.getStart();
            long beatLength = beat.getVoice(0).getDuration().getTime();
            if (previous != null) {
                long previousStart = previous.getStart();
                long previousLength = previous.getVoice(0).getDuration().getTime();
                if (beat.getVoice(0).isRestVoice() && beat.isChordBeat()) {
                    TGBeat candidate = null;
                    TGBeat next = this.manager.getMeasureManager().getFirstBeat(measure.getBeats());
                    while (next != null && (candidate == null || next.getStart() <= beat.getStart())) {
                        if (!next.getVoice(0).isRestVoice() && !next.isChordBeat()) {
                            candidate = next;
                        }
                        next = this.manager.getMeasureManager().getNextBeat(measure.getBeats(), next);
                    }
                    if (candidate != null) {
                        candidate.setChord(beat.getChord());
                    }
                    measure.removeBeat(beat);
                    finish = false;
                    break;
                }
                if (previousStart < beatStart && previousStart + previousLength > beatStart) {
                    if (beat.getVoice(0).isRestVoice()) {
                        measure.removeBeat(beat);
                        finish = false;
                        break;
                    }
                    TGDuration duration = TGDuration.fromTime((TGFactory)this.manager.getFactory(), (long)(beatStart - previousStart));
                    previous.getVoice(0).getDuration().copyFrom(duration);
                }
            }
            if (beatStart + beatLength > measureEnd) {
                if (beat.getVoice(0).isRestVoice()) {
                    measure.removeBeat(beat);
                    finish = false;
                    break;
                }
                TGDuration duration = TGDuration.fromTime((TGFactory)this.manager.getFactory(), (long)(measureEnd - beatStart));
                beat.getVoice(0).getDuration().copyFrom(duration);
            }
            previous = beat;
        }
        if (!finish) {
            this.adjustBeats(measure);
        }
    }
}

