/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models.effects;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.song.factory.TGFactory;

public abstract class TGEffectTremoloBar {
    public static final int MAX_POSITION_LENGTH = 12;
    public static final int MAX_VALUE_LENGTH = 12;
    private List<TremoloBarPoint> points = new ArrayList<TremoloBarPoint>();

    public void addPoint(int position, int value) {
        this.points.add(new TremoloBarPoint(position, value));
    }

    public List<TremoloBarPoint> getPoints() {
        return this.points;
    }

    public TGEffectTremoloBar clone(TGFactory factory) {
        TGEffectTremoloBar effect = factory.newEffectTremoloBar();
        for (TremoloBarPoint point : this.getPoints()) {
            effect.addPoint(point.getPosition(), point.getValue());
        }
        return effect;
    }

    public class TremoloBarPoint {
        private int position;
        private int value;

        public TremoloBarPoint(int position, int value) {
            this.position = position;
            this.value = value;
        }

        public int getPosition() {
            return this.position;
        }

        public int getValue() {
            return this.value;
        }

        public long getTime(long duration) {
            return duration * (long)this.getPosition() / 12L;
        }

        public Object clone() {
            return new TremoloBarPoint(this.getPosition(), this.getValue());
        }
    }
}

