/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.io.stream;

import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.action.TGActionException;
import org.herac.tuxguitar.action.TGActionInterceptor;
import org.herac.tuxguitar.action.TGActionManager;
import org.herac.tuxguitar.app.io.stream.TGSongStreamAdapterManager;
import org.herac.tuxguitar.app.io.stream.TGSongStreamSettingsHandler;
import org.herac.tuxguitar.io.base.TGSongStreamContext;
import org.herac.tuxguitar.io.base.TGSongStreamProvider;
import org.herac.tuxguitar.util.TGAbstractContext;
import org.herac.tuxguitar.util.TGContext;

public class TGSongStreamActionInterceptor
implements TGActionInterceptor {
    private static final String ATTRIBUTE_DONE = TGSongStreamActionInterceptor.class.getName() + "-done";
    private static final String ATTRIBUTE_STREAM_CONTEXT = TGSongStreamContext.class.getName();
    private static final String ATTRIBUTE_STREAM_PROVIDER = TGSongStreamProvider.class.getName();
    private static final String[] INTERCEPTABLE_ACTIONS = new String[]{"action.song.import", "action.song.export"};
    private TGContext context;

    public TGSongStreamActionInterceptor(TGContext context) {
        this.context = context;
    }

    public TGContext getContext() {
        return this.context;
    }

    public boolean isInterceptable(String id) {
        for (String actionId : INTERCEPTABLE_ACTIONS) {
            if (!actionId.equals(id)) continue;
            return true;
        }
        return false;
    }

    public boolean intercept(String id, TGActionContext context) throws TGActionException {
        if (this.isInterceptable(id) && !this.isDone(context)) {
            return this.processSettingsHandler(id, context);
        }
        return false;
    }

    private boolean isDone(TGActionContext context) {
        return Boolean.TRUE.equals(context.hasAttribute(ATTRIBUTE_DONE));
    }

    public boolean processSettingsHandler(String id, TGActionContext actionContext) {
        TGSongStreamSettingsHandler handler;
        actionContext.setAttribute(ATTRIBUTE_DONE, (Object)Boolean.TRUE);
        TGSongStreamProvider provider = (TGSongStreamProvider)actionContext.getAttribute(ATTRIBUTE_STREAM_PROVIDER);
        if (provider != null && (handler = TGSongStreamAdapterManager.getInstance(this.context).findSettingsHandler(provider.getProviderId())) != null) {
            TGSongStreamContext streamContext = (TGSongStreamContext)actionContext.getAttribute(ATTRIBUTE_STREAM_CONTEXT);
            if (streamContext == null) {
                streamContext = new TGSongStreamContext();
                streamContext.addContext((TGAbstractContext)actionContext);
                actionContext.setAttribute(ATTRIBUTE_STREAM_CONTEXT, (Object)streamContext);
            }
            handler.handleSettings(streamContext, this.createExecuteActionThread(id, actionContext));
            return true;
        }
        return false;
    }

    public Runnable createExecuteActionThread(final String id, final TGActionContext context) {
        return new Runnable(){

            @Override
            public void run() {
                new Thread(TGSongStreamActionInterceptor.this.createExecuteActionRunnable(id, context)).start();
            }
        };
    }

    public Runnable createExecuteActionRunnable(final String id, final TGActionContext context) {
        return new Runnable(){

            @Override
            public void run() {
                TGSongStreamActionInterceptor.this.executeAction(id, context);
            }
        };
    }

    public void executeAction(String id, TGActionContext context) {
        TGActionManager tgActionManager = TGActionManager.getInstance((TGContext)this.getContext());
        tgActionManager.execute(id, context);
    }
}

