/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.jack.synthesizer.settings;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.dialog.channel.TGChannelSettingsDialog;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.gm.GMChannelRoute;
import org.herac.tuxguitar.gm.GMChannelRouter;
import org.herac.tuxguitar.gm.GMChannelRouterConfigurator;
import org.herac.tuxguitar.jack.synthesizer.settings.JackMidiPlayerListener;
import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.player.base.MidiPlayerException;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGChannelParameter;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UIDisposeEvent;
import org.herac.tuxguitar.ui.event.UIDisposeListener;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.widget.UICheckBox;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIDropDownSelect;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UILegendPanel;
import org.herac.tuxguitar.ui.widget.UISelectItem;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.error.TGErrorManager;

public class JackChannelSettingsDialog
implements TGChannelSettingsDialog {
    public static final short MAX_CHANNELS = 16;
    public static final short DEFAULT_INSTRUMENT_CHANNEL_1 = 0;
    public static final short DEFAULT_INSTRUMENT_CHANNEL_2 = 1;
    public static final short DEFAULT_PERCUSSION_CHANNEL = 9;
    public static final String CHANNELS_DATA = "channels";
    private TGContext context;
    private TGSong song;
    private TGChannel channel;
    private GMChannelRouter router;
    private UIWindow dialog;
    private UIDropDownSelect<Integer> gmChannel1Combo;
    private UIDropDownSelect<Integer> gmChannel2Combo;
    private UICheckBox exclusiveButton;
    private JackMidiPlayerListener jackMidiPlayerListener;

    public JackChannelSettingsDialog(TGContext context, TGChannel channel, TGSong song) {
        this.context = context;
        this.song = song;
        this.channel = channel;
        this.router = new GMChannelRouter();
        this.jackMidiPlayerListener = new JackMidiPlayerListener(this.context, this);
    }

    public void open(UIWindow parent) {
        this.configureRouter(true);
        UIFactory uiFactory = TGApplication.getInstance((TGContext)this.context).getFactory();
        UITableLayout dialogLayout = new UITableLayout();
        this.dialog = uiFactory.createWindow(parent, false, false);
        this.dialog.setLayout((UILayout)dialogLayout);
        this.dialog.setText(TuxGuitar.getProperty((String)"jack.settings.channel.dialog"));
        UITableLayout groupLayout = new UITableLayout();
        UILegendPanel group = uiFactory.createLegendPanel((UIContainer)this.dialog);
        group.setLayout((UILayout)groupLayout);
        group.setText(TuxGuitar.getProperty((String)"jack.settings.channel.gm.tip"));
        dialogLayout.set((UIControl)group, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel gmChannel1Label = uiFactory.createLabel((UIContainer)group);
        gmChannel1Label.setText(TuxGuitar.getProperty((String)"jack.settings.channel.gm.channel.label-1") + ":");
        groupLayout.set((UIControl)gmChannel1Label, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        this.gmChannel1Combo = uiFactory.createDropDownSelect((UIContainer)group);
        this.gmChannel1Combo.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                JackChannelSettingsDialog.this.updateChannel();
            }
        });
        groupLayout.set(this.gmChannel1Combo, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UILabel gmChannel2Label = uiFactory.createLabel((UIContainer)group);
        gmChannel2Label.setText(TuxGuitar.getProperty((String)"jack.settings.channel.gm.channel.label-2") + ":");
        groupLayout.set((UIControl)gmChannel2Label, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        this.gmChannel2Combo = uiFactory.createDropDownSelect((UIContainer)group);
        this.gmChannel2Combo.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                JackChannelSettingsDialog.this.updateChannel();
            }
        });
        groupLayout.set(this.gmChannel2Combo, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UITableLayout optionsLayout = new UITableLayout();
        UILegendPanel optionsGroup = uiFactory.createLegendPanel((UIContainer)this.dialog);
        optionsGroup.setLayout((UILayout)optionsLayout);
        optionsGroup.setText(TuxGuitar.getProperty((String)"options"));
        dialogLayout.set((UIControl)optionsGroup, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.exclusiveButton = uiFactory.createCheckBox((UIContainer)optionsGroup);
        this.exclusiveButton.setText(TuxGuitar.getProperty((String)"jack.settings.channel.exclusive.port"));
        this.exclusiveButton.setSelected(this.isExclusive());
        this.exclusiveButton.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                JackChannelSettingsDialog.this.updateExclusive();
            }
        });
        this.updateDefaultExclusiveChannels();
        this.updateChannelCombos();
        this.updateControls();
        this.addMidiPlayerListener();
        this.dialog.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                JackChannelSettingsDialog.this.removeMidiPlayerListener();
            }
        });
        TGDialogUtil.openDialog((UIWindow)this.dialog, (int)5);
    }

    public void close() {
        if (this.isOpen()) {
            this.dialog.dispose();
        }
    }

    public boolean isOpen() {
        return this.dialog != null && !this.dialog.isDisposed();
    }

    public void addMidiPlayerListener() {
        MidiPlayer.getInstance((TGContext)this.context).addListener((TGEventListener)this.jackMidiPlayerListener);
    }

    public void removeMidiPlayerListener() {
        MidiPlayer.getInstance((TGContext)this.context).removeListener((TGEventListener)this.jackMidiPlayerListener);
    }

    public void updateControls() {
        if (this.dialog != null && !this.dialog.isDisposed()) {
            boolean playerRunning = TuxGuitar.getInstance().getPlayer().isRunning();
            this.gmChannel1Combo.setEnabled(!playerRunning && !this.channel.isPercussionChannel() && this.gmChannel1Combo.getItemCount() > 0);
            this.gmChannel2Combo.setEnabled(!playerRunning && !this.channel.isPercussionChannel() && this.gmChannel2Combo.getItemCount() > 0);
            this.exclusiveButton.setEnabled(!playerRunning);
        }
    }

    private void configureRouter(boolean updateChannel) {
        if (!this.isExclusive()) {
            GMChannelRouterConfigurator gmChannelRouterConfigurator = new GMChannelRouterConfigurator(this.router);
            gmChannelRouterConfigurator.configureRouter(this.findGmChannels());
            if (updateChannel) {
                this.updateChannelFromRouter();
            }
        }
    }

    private void updateChannelCombos() {
        if (this.isExclusive()) {
            this.reloadExclusiveChannelCombos();
        } else {
            this.reloadGMChannelCombos();
        }
        this.updateControls();
    }

    private void reloadExclusiveChannelCombos() {
        ArrayList<Integer> channels = new ArrayList<Integer>();
        for (int i = 0; i < 16; ++i) {
            channels.add(new Integer(i));
        }
        int channel1 = this.getIntegerChannelParameter(this.channel, "gm-channel-1", -1);
        int channel2 = this.getIntegerChannelParameter(this.channel, "gm-channel-2", -1);
        this.reloadChannelCombo(this.gmChannel1Combo, channels, channel1, "jack.settings.channel.gm.channel.value-1");
        this.reloadChannelCombo(this.gmChannel2Combo, channels, channel2, "jack.settings.channel.gm.channel.value-2");
    }

    private void reloadGMChannelCombos() {
        GMChannelRoute route = this.router.getRoute(this.channel.getChannelId());
        List channels = this.router.getFreeChannels(route);
        this.reloadChannelCombo(this.gmChannel1Combo, channels, route.getChannel1(), "jack.settings.channel.gm.channel.value-1");
        this.reloadChannelCombo(this.gmChannel2Combo, channels, route.getChannel2(), "jack.settings.channel.gm.channel.value-2");
    }

    private void reloadChannelCombo(UIDropDownSelect<Integer> combo, List<Integer> channels, int selected, String valueKey) {
        if (!(combo.getData(CHANNELS_DATA) instanceof List) || this.isDifferentList(channels, (List)combo.getData(CHANNELS_DATA))) {
            combo.removeItems();
            combo.setData(CHANNELS_DATA, channels);
            for (Integer channel : channels) {
                combo.addItem(new UISelectItem(TuxGuitar.getProperty((String)valueKey, (String[])new String[]{channel.toString()}), (Object)channel));
            }
        }
        combo.setSelectedValue((Object)selected);
    }

    public void updateExclusive() {
        boolean exclusive = this.exclusiveButton.isSelected();
        this.setChannelParameter(this.channel, "jack-port-exclusive", Boolean.toString(exclusive));
        this.removeChannelParameter(this.channel, "gm-channel-1");
        this.removeChannelParameter(this.channel, "gm-channel-2");
        this.configureRouter(true);
        this.updateDefaultExclusiveChannels();
        this.updateChannelCombos();
        this.updatePlayerChannels();
    }

    public void updateChannel() {
        Integer channel1Selection = (Integer)this.gmChannel1Combo.getSelectedValue();
        Integer channel2Selection = (Integer)this.gmChannel2Combo.getSelectedValue();
        int channel1 = channel1Selection != null ? channel1Selection : -1;
        int channel2 = channel2Selection != null ? channel2Selection : -1;
        this.setChannelParameter(this.channel, "gm-channel-1", Integer.toString(channel1));
        this.setChannelParameter(this.channel, "gm-channel-2", Integer.toString(channel2));
        this.configureRouter(false);
        this.updatePlayerChannels();
    }

    public void updateChannelFromRouter() {
        GMChannelRoute route = this.router.getRoute(this.channel.getChannelId());
        if (this.findChannelParameter(this.channel, "gm-channel-1") == null) {
            this.setChannelParameter(this.channel, "gm-channel-1", Integer.toString(route.getChannel1()));
        }
        if (this.findChannelParameter(this.channel, "gm-channel-2") == null) {
            this.setChannelParameter(this.channel, "gm-channel-2", Integer.toString(route.getChannel2()));
        }
    }

    public void updateDefaultExclusiveChannels() {
        if (this.isExclusive()) {
            int channel1 = this.channel.isPercussionChannel() ? 9 : 0;
            int channel2 = this.channel.isPercussionChannel() ? 9 : 1;
            this.setChannelParameter(this.channel, "gm-channel-1", Integer.toString(channel1));
            this.setChannelParameter(this.channel, "gm-channel-2", Integer.toString(channel2));
        }
    }

    public void updatePlayerChannels() {
        try {
            if (!MidiPlayer.getInstance((TGContext)this.context).isRunning()) {
                MidiPlayer.getInstance((TGContext)this.context).updateChannels();
            }
        }
        catch (MidiPlayerException e) {
            TGErrorManager.getInstance((TGContext)this.context).handleError((Throwable)e);
        }
    }

    private void setChannelParameter(TGChannel tgChannel, String key, String value) {
        TGChannelParameter tgChannelParameter = this.findOrCreateChannelParameter(tgChannel, key);
        tgChannelParameter.setValue(value);
    }

    private TGChannelParameter findChannelParameter(TGChannel tgChannel, String key) {
        Iterator it = tgChannel.getParameters();
        while (it.hasNext()) {
            TGChannelParameter parameter = (TGChannelParameter)it.next();
            if (!parameter.getKey().equals(key)) continue;
            return parameter;
        }
        return null;
    }

    private TGChannelParameter findOrCreateChannelParameter(TGChannel tgChannel, String key) {
        TGChannelParameter tgChannelParameter = this.findChannelParameter(tgChannel, key);
        if (tgChannelParameter == null) {
            tgChannelParameter = TuxGuitar.getInstance().getSongManager().getFactory().newChannelParameter();
            tgChannelParameter.setKey(key);
            tgChannel.addParameter(tgChannelParameter);
        }
        return tgChannelParameter;
    }

    private int getIntegerChannelParameter(TGChannel tgChannel, String key, int nullValue) {
        TGChannelParameter tgChannelParameter = this.findChannelParameter(tgChannel, key);
        if (tgChannelParameter != null && tgChannelParameter.getValue() != null) {
            return Integer.parseInt(tgChannelParameter.getValue());
        }
        return nullValue;
    }

    private void removeChannelParameter(TGChannel tgChannel, String key) {
        int index = -1;
        int count = tgChannel.countParameters();
        for (int i = 0; i < count; ++i) {
            TGChannelParameter parameter = tgChannel.getParameter(i);
            if (!parameter.getKey().equals(key)) continue;
            index = i;
        }
        if (index >= 0) {
            tgChannel.removeParameter(index);
        }
    }

    private boolean isDifferentList(List<?> list1, List<?> list2) {
        if (list1.size() != list2.size()) {
            return true;
        }
        for (int i = 0; i < list1.size(); ++i) {
            if (list1.get(i).equals(list2.get(i))) continue;
            return true;
        }
        return false;
    }

    private boolean isExclusive(TGChannel tgChannel) {
        TGChannelParameter tgChannelParameter = this.findChannelParameter(tgChannel, "jack-port-exclusive");
        if (tgChannelParameter != null) {
            return Boolean.TRUE.toString().equals(tgChannelParameter.getValue());
        }
        return false;
    }

    private boolean isExclusive() {
        return this.isExclusive(this.channel);
    }

    private Iterator<TGChannel> findGmChannels() {
        ArrayList<TGChannel> tgChannels = new ArrayList<TGChannel>();
        int count = this.song.countChannels();
        for (int i = 0; i < count; ++i) {
            TGChannel tgChannel = this.song.getChannel(i);
            if (this.isExclusive(tgChannel)) continue;
            tgChannels.add(tgChannel);
        }
        return tgChannels.iterator();
    }
}

