/*
 * Decompiled with CFR 0.152.
 */
package com.ranfa.lib;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.ranfa.lib.SettingJSONProperty;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class Settings {
    private static final String FILEPATH = "settings.json";

    public static boolean fileExists() {
        Path path = Paths.get(FILEPATH, new String[0]);
        return Files.exists(path, new LinkOption[0]);
    }

    public static boolean needToCheckVersion() {
        boolean res = true;
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode node = mapper.readTree(new File(FILEPATH));
            res = node.get("checkVersion").asBoolean();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }

    public static boolean needToCheckLibraryUpdates() {
        boolean res = true;
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode node = mapper.readTree(new File(FILEPATH));
            res = node.get("checkLibraryUpdates").asBoolean();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }

    public static int getWindowWidth() {
        int res = 640;
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode node = mapper.readTree(new File(FILEPATH));
            res = node.get("windowWidth").asInt();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res < 1 ? 640 : res;
    }

    public static int getWindowHeight() {
        int res = 360;
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode node = mapper.readTree(new File(FILEPATH));
            res = node.get("windowHeight").asInt();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res < 1 ? 360 : res;
    }

    public static int getSongsLimit() {
        int res = 3;
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode node = mapper.readTree(new File(FILEPATH));
            res = node.get("songLimit").asInt();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res < 1 ? 3 : res;
    }

    public static boolean saveScoreLog() {
        boolean res = false;
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode node = mapper.readTree(new File(FILEPATH));
            res = node.get("saveScoreLog").asBoolean();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }

    public static boolean outputDebugSentences() {
        boolean res = false;
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode node = mapper.readTree(new File(FILEPATH));
            res = node.get("outputDebugSentences").asBoolean();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }

    public static boolean writeDownJSON() {
        boolean res = true;
        SettingJSONProperty property = new SettingJSONProperty();
        property.setCheckVersion(true);
        property.setCheckLibraryUpdates(true);
        property.setWindowWidth(640);
        property.setWindowHeight(360);
        property.setSongLimit(3);
        property.setSaveScoreLog(false);
        property.setOutputDebugSentences(false);
        ObjectWriter writer = new ObjectMapper().writer((PrettyPrinter)new DefaultPrettyPrinter());
        try {
            writer.writeValue(Paths.get(FILEPATH, new String[0]).toFile(), (Object)property);
        }
        catch (IOException e) {
            res = false;
        }
        return res;
    }
}

