/*
 * Decompiled with CFR 0.152.
 */
package com.ranfa.lib;

import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.ranfa.lib.SettingJSONProperty;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Settings {
    private static final String FILEPATH = "generated/settings.json";
    private static Logger logger = LoggerFactory.getLogger(Settings.class);

    public static boolean fileExists() {
        Path path = Paths.get(FILEPATH, new String[0]);
        return Files.exists(path, new LinkOption[0]);
    }

    public static boolean needToCheckVersion() {
        boolean res = true;
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode node = mapper.readTree(new File(FILEPATH));
            res = node.get("checkVersion").asBoolean();
        }
        catch (IOException e) {
            logger.error("Couldn't read setting file.", (Throwable)e);
        }
        return res;
    }

    public static boolean needToCheckLibraryUpdates() {
        boolean res = true;
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode node = mapper.readTree(new File(FILEPATH));
            res = node.get("checkLibraryUpdates").asBoolean();
        }
        catch (IOException e) {
            logger.error("Couldn't read setting file.", (Throwable)e);
        }
        return res;
    }

    public static int getWindowWidth() {
        int res = 960;
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode node = mapper.readTree(new File(FILEPATH));
            res = node.get("windowWidth").asInt();
        }
        catch (IOException e) {
            logger.error("Couldn't read setting file.", (Throwable)e);
        }
        return res < 1 ? 640 : res;
    }

    public static int getWindowHeight() {
        int res = 540;
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode node = mapper.readTree(new File(FILEPATH));
            res = node.get("windowHeight").asInt();
        }
        catch (IOException e) {
            logger.error("Couldn't read setting file.", (Throwable)e);
        }
        return res < 1 ? 360 : res;
    }

    public static int getSongsLimit() {
        int res = 3;
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode node = mapper.readTree(new File(FILEPATH));
            res = node.get("songLimit").asInt();
        }
        catch (IOException e) {
            logger.error("Couldn't read setting file.", (Throwable)e);
        }
        return res < 1 ? 3 : res;
    }

    public static boolean saveScoreLog() {
        boolean res = false;
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode node = mapper.readTree(new File(FILEPATH));
            res = node.get("saveScoreLog").asBoolean();
        }
        catch (IOException e) {
            logger.error("Couldn't read setting file.", (Throwable)e);
        }
        return res;
    }

    public static boolean writeDownJSON() {
        boolean res = true;
        SettingJSONProperty property = new SettingJSONProperty();
        property.setCheckVersion(true);
        property.setCheckLibraryUpdates(true);
        property.setWindowWidth(960);
        property.setWindowHeight(540);
        property.setSongLimit(3);
        property.setSaveScoreLog(false);
        ObjectWriter writer = new ObjectMapper().writer(new DefaultPrettyPrinter());
        try {
            writer.writeValue(Paths.get(FILEPATH, new String[0]).toFile(), (Object)property);
        }
        catch (IOException e) {
            logger.error("Couldn't write down setting file.", (Throwable)e);
            res = false;
        }
        return res;
    }
}

