/*
 * Decompiled with CFR 0.152.
 */
package com.ranfa.main;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.ranfa.lib.CheckVersion;
import com.ranfa.lib.Easter;
import com.ranfa.lib.ManualUpdateThreadImpl;
import com.ranfa.lib.SettingJSONProperty;
import com.ranfa.lib.Settings;
import com.ranfa.lib.Suffix;
import com.ranfa.lib.TwitterIntegration;
import com.ranfa.lib.Version;
import com.ranfa.lib.concurrent.CountedThreadFactory;
import com.ranfa.lib.database.EstimateAlbumTypeCycle;
import com.ranfa.lib.database.Scraping;
import com.ranfa.lib.database.Song;
import com.ranfa.lib.handler.CrashHandler;
import com.ranfa.lib.songinfo.FetchFromAPI;
import com.ranfa.main.Messages;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.LayoutManager;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Version(major=4, minor=0, patch=1, suffix=Suffix.BETA)
public class DelesteRandomSelector
extends JFrame {
    private static ArrayList<Song> selectedSongsList = new ArrayList();
    private JPanel contentPane;
    private SettingJSONProperty property = new SettingJSONProperty();
    private String[] integratorArray;
    private boolean integratorBool = false;
    private CompletableFuture<Void> softwareUpdateFuture = null;
    private CompletableFuture<Void> albumTypeEstimateFuture = null;
    private String albumType = Messages.MSGAlbumTypeBeingCalculated.toString();
    private Logger logger = LoggerFactory.getLogger(DelesteRandomSelector.class);
    private ManualUpdateThreadImpl impl;
    private List<Song> toolIntegrateList;
    private FetchFromAPI fetchData;
    private List<Map<String, String>> listToolMapData;
    private CompletableFuture<List<Map<String, String>>> listToolMapDataFuture;
    private Easter easter;
    private JPanel panelMain;
    private JPanel panelNorthMain;
    private JLabel labelTitle;
    private JLabel labelVersion;
    private JPanel panelWestMain;
    private JLabel labelDifficulty;
    private JComboBox<String[]> comboDifficultySelect;
    private JComboBox<String[]> comboAttribute;
    private JLabel labelLevel;
    private JSpinner spinnerLevel;
    private JCheckBox checkLessLv;
    private JCheckBox checkMoreLv;
    private JLabel labelLvCaution;
    private JPanel panelEastMain;
    private JButton btnImport;
    private JButton btnConfig;
    private JButton btnStart;
    private JButton btnManualUpdate;
    private JButton btnTwitterIntegration;
    private JButton btnExit;
    private JPanel panelCenterMain;
    private JScrollPane scrollPane;
    private JTextArea textArea;
    private JTabbedPane tabbedPane;
    private JPanel panelInfo;
    private JPanel panelNorthTool;
    private JLabel labelSubToolTitle;
    private JLabel labelVersionTool;
    private JPanel panelCenterTool;
    private JLabel labelInfoPlaySongs;
    private JLabel labelSongNameToolTitle;
    private JLabel labelSongNameToolTip;
    private JLabel labelAttributeToolTitle;
    private JLabel labelAttributeToolTip;
    private JLabel labelDifficultyToolTitle;
    private JLabel labelDifficultyToolTip;
    private JLabel labelLevelToolTitle;
    private JLabel labelLevelToolTip;
    private JLabel labelNotesToolTitle;
    private JLabel labelNotesToolTip;
    private JButton btnPrevSongTool;
    private JButton btnNextSongTool;
    private JLabel labelSlashTool;
    private JLabel labelCurrentSongOrderTool;
    private JLabel labelSongLimitTool;
    private JLabel labelLyricToolTitle;
    private JLabel labelLyricToolTip;
    private JLabel labelComposerToolTitle;
    private JLabel labelArrangeToolTitle;
    private JLabel labelComposerToolTip;
    private JLabel labelArrangeToolTip;
    private JLabel labelMemberToolTitle;
    private JLabel labelMemberToolTip;
    private JButton btnMoreInfoTool;
    BiConsumer<ArrayList<Song>, ArrayList<Song>> updateConsumer = (list1, list2) -> {
        this.logger.info("Checking database updates...");
        if (list1.size() > list2.size()) {
            long time = System.currentTimeMillis();
            this.logger.info("{} Update detected.", (Object)(list1.size() - list2.size()));
            Scraping.writeToJson(list1);
            this.logger.info("Update completed in {} ms", (Object)(System.currentTimeMillis() - time));
            this.logger.info("Updated database size: {}", (Object)list1.size());
        } else {
            this.logger.info("database is up-to-date.");
        }
    };
    Runnable setEnabled = () -> {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e1) {
            this.logger.error("Thread has been interrupted during waiting cooldown.", (Throwable)e1);
        }
        this.btnImport.setEnabled(true);
        this.btnImport.setText(Messages.MSGNarrowingDownSongs.toString());
    };
    private JLabel labelToolProgress;
    public static JProgressBar progressTool;
    public static JLabel labelInfoProgressSongName;
    private JPanel panelScore;
    private JPanel panelScoreNorth;
    private JPanel panelScoreCenter;
    private JLabel labelScoreTitle;
    private JLabel labelScoreVersion;

    public static void main(String[] args) {
        EventQueue.invokeLater(() -> {
            try {
                DelesteRandomSelector frame = new DelesteRandomSelector();
                frame.setVisible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public DelesteRandomSelector() {
        ExecutorService es = Executors.newCachedThreadPool(new CountedThreadFactory(() -> "DRS", "AsyncEventInquerier", false));
        this.contentPane = new JPanel();
        CompletableFuture.runAsync(() -> {
            CrashHandler handle = new CrashHandler();
            handle.outSystemInfo();
        }, es).whenCompleteAsync((ret, ex) -> {
            if (ex != null) {
                this.logger.error("Exception was thrown during concurrent process", ex);
                CrashHandler handle = new CrashHandler((Throwable)ex);
                if (ex instanceof NullPointerException) {
                    handle.execute();
                }
                handle = new CrashHandler(new IllegalStateException((Throwable)ex));
                handle.execute();
            }
        }, (Executor)es);
        boolean isFirst = !Scraping.databaseExists();
        CompletableFuture.runAsync(() -> {
            if (isFirst) {
                JOptionPane.showMessageDialog(this, Messages.MSGDatabaseNotExist.toString());
                if (!Scraping.writeToJson(Scraping.getWholeData())) {
                    JOptionPane.showMessageDialog(this, "Exception:NullPointerException\nCannot Keep up! Please re-download this Application!");
                    throw new NullPointerException("FATAL: cannot continue!");
                }
            }
        }, es).whenCompleteAsync((ret, ex) -> {
            if (ex != null) {
                this.logger.error("Exception was thrown during concurrent process", ex);
                CrashHandler handle = new CrashHandler((Throwable)ex);
                if (ex instanceof NullPointerException) {
                    handle.execute();
                }
                handle = new CrashHandler(new IllegalStateException((Throwable)ex));
                handle.execute();
            }
        }, (Executor)es);
        CompletableFuture<ArrayList> getFromJsonFuture = CompletableFuture.supplyAsync(() -> Scraping.getFromJson(), es);
        CompletableFuture<ArrayList> getWholeDataFuture = CompletableFuture.supplyAsync(() -> Scraping.getWholeData(), es);
        CompletableFuture.runAsync(() -> {
            if (!Settings.fileExists() && !Settings.writeDownJSON()) {
                JOptionPane.showMessageDialog(this, "Exception:NullPointerException\nPlease see crash report for more detail.");
                CrashHandler handle = new CrashHandler("Failed to generate setting file.", new NullPointerException("FATAL: cannot continue!"));
                handle.execute();
            }
        }, es).whenCompleteAsync((ret, ex) -> {
            if (ex != null) {
                this.logger.error("Exception was thrown during concurrent process", ex);
                CrashHandler handle = new CrashHandler((Throwable)ex);
                if (ex instanceof NullPointerException) {
                    handle.execute();
                }
                handle = new CrashHandler(new IllegalStateException((Throwable)ex));
                handle.execute();
            }
            this.logger.debug("Loading settings...");
            this.property.setCheckLibraryUpdates(Settings.needToCheckLibraryUpdates());
            this.property.setCheckVersion(Settings.needToCheckVersion());
            this.property.setWindowWidth(Settings.getWindowWidth());
            this.property.setWindowHeight(Settings.getWindowHeight());
            this.property.setSongLimit(Settings.getSongsLimit());
            this.property.setSaveScoreLog(Settings.saveScoreLog());
            this.logger.debug("Load settings done.");
            this.logger.debug("Version check: {}", (Object)this.property.isCheckVersion());
            this.logger.debug("Library update check: {}", (Object)this.property.isCheckLibraryUpdates());
            this.logger.debug("Window Width: {}", (Object)this.property.getWindowWidth());
            this.logger.debug("Window Height: {}", (Object)this.property.getWindowHeight());
            this.logger.debug("Song Limit: {}", (Object)this.property.getSongLimit());
            this.logger.debug("SaveScoreLog: {}", (Object)this.property.isSaveScoreLog());
            this.setBounds(100, 100, this.property.getWindowWidth(), this.property.getWindowHeight());
            if (this.property.isCheckVersion()) {
                this.softwareUpdateFuture = CompletableFuture.runAsync(() -> CheckVersion.needToBeUpdated(), es);
            }
            if (this.property.isCheckLibraryUpdates()) {
                CompletionStage updatedFuture = getWholeDataFuture.thenAcceptBothAsync(getFromJsonFuture, this.updateConsumer, (Executor)es);
                ((CompletableFuture)updatedFuture).thenRunAsync(this.setEnabled, es);
            }
        }, (Executor)es);
        CompletableFuture.runAsync(() -> {
            EstimateAlbumTypeCycle.Initialization();
            if (Files.exists(Paths.get("generated/albumCycle.json", new String[0]), new LinkOption[0])) {
                this.albumType = EstimateAlbumTypeCycle.getCurrentCycle();
            }
        }, es).whenCompleteAsync((ret, ex) -> {
            if (ex != null) {
                this.logger.error("Exception was thrown during concurrent process", ex);
                CrashHandler handle = new CrashHandler(new IllegalStateException((Throwable)ex));
                handle.execute();
            }
        }, (Executor)es);
        getWholeDataFuture.thenAcceptAsync(list -> this.logger.info("Scraping data size:" + list.size()), (Executor)es);
        getFromJsonFuture.thenAcceptAsync(list -> this.logger.info("Currently database size:" + list.size()), (Executor)es);
        CompletableFuture.runAsync(() -> {
            this.easter = new Easter();
            this.setTitle(this.easter.getTodaysBirth());
        }, es);
        this.logger.debug("Version: {}", (Object)CheckVersion.getVersion());
        this.setDefaultCloseOperation(3);
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new CardLayout(0, 0));
        this.panelMain = new JPanel();
        this.panelMain.setLayout(new BorderLayout(0, 0));
        this.panelNorthMain = new JPanel();
        this.panelMain.add((Component)this.panelNorthMain, "North");
        this.panelNorthMain.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"829px"), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode((String)"center:94px")}, new RowSpec[]{RowSpec.decode((String)"20px")}));
        this.labelTitle = new JLabel(Messages.MSGTitle.toString());
        this.labelTitle.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 1, 16));
        this.panelNorthMain.add((Component)this.labelTitle, "1, 1, center, top");
        this.labelVersion = new JLabel(CheckVersion.getVersion());
        this.labelVersion.setFont(new Font("SansSerif", 1, 12));
        this.panelNorthMain.add((Component)this.labelVersion, "3, 1, center, center");
        this.panelWestMain = new JPanel();
        this.panelMain.add((Component)this.panelWestMain, "West");
        this.panelWestMain.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode((String)"120px")}, new RowSpec[]{FormSpecs.LINE_GAP_ROWSPEC, RowSpec.decode((String)"25px"), FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(41dlu;default)")}));
        this.labelDifficulty = new JLabel(Messages.MSGSelectDifficulty.toString());
        this.labelDifficulty.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 1, 13));
        this.panelWestMain.add((Component)this.labelDifficulty, "2, 2, center, center");
        this.comboDifficultySelect = new JComboBox();
        this.comboDifficultySelect.setModel(new DefaultComboBoxModel<String>(new String[]{Messages.MSGNonSelected.toString(), "DEBUT", "REGULAR", "PRO", "MASTER", "MASTER+", "\u24c1MASTER+", "LIGHT", "TRICK", "PIANO", "FORTE", "WITCH"}));
        this.comboDifficultySelect.setFont(new Font("Dialog", 1, 12));
        this.panelWestMain.add(this.comboDifficultySelect, "2, 4, fill, fill");
        this.comboAttribute = new JComboBox();
        this.comboAttribute.setModel(new DefaultComboBoxModel<String>(new String[]{Messages.MSGNonSelected.toString(), "\u5168\u30bf\u30a4\u30d7", "\u30ad\u30e5\u30fc\u30c8", "\u30af\u30fc\u30eb", "\u30d1\u30c3\u30b7\u30e7\u30f3"}));
        this.comboAttribute.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 1, 13));
        this.panelWestMain.add(this.comboAttribute, "2, 6, fill, top");
        this.labelLevel = new JLabel(Messages.MSGSongLevel.toString());
        this.labelLevel.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 1, 13));
        this.panelWestMain.add((Component)this.labelLevel, "2, 8, center, center");
        this.spinnerLevel = new JSpinner();
        this.panelWestMain.add((Component)this.spinnerLevel, "2, 10, fill, center");
        this.checkLessLv = new JCheckBox(Messages.MSGBelowSpecificLevel.toString());
        this.checkLessLv.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 1, 13));
        this.panelWestMain.add((Component)this.checkLessLv, "2, 12, left, top");
        this.checkMoreLv = new JCheckBox(Messages.MSGOverSpecificLevel.toString());
        this.checkMoreLv.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 1, 13));
        this.panelWestMain.add((Component)this.checkMoreLv, "2, 14, left, top");
        this.labelLvCaution = new JLabel(Messages.MSGLevelCheckboxInfo.toString());
        this.labelLvCaution.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 1, 13));
        this.panelWestMain.add((Component)this.labelLvCaution, "2, 16, left, center");
        this.panelEastMain = new JPanel();
        this.panelMain.add((Component)this.panelEastMain, "East");
        this.panelEastMain.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode((String)"100px")}, new RowSpec[]{FormSpecs.LINE_GAP_ROWSPEC, RowSpec.decode((String)"77px"), FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(36dlu;default)"), FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        this.btnImport = new JButton(Messages.MSGUpdatingDatabase.toString());
        this.btnImport.addActionListener(e -> CompletableFuture.runAsync(() -> {
            if (this.impl != null && !this.impl.getFlag()) {
                JOptionPane.showMessageDialog(null, Messages.MSGManualUpdateNotCompleteYet.toString());
            }
            ArrayList<Song> fromJson = Scraping.getFromJson();
            ArrayList<Song> specificlevelList = Scraping.getSpecificLevelSongs(fromJson, (Integer)this.spinnerLevel.getValue(), this.checkLessLv.isSelected(), this.checkMoreLv.isSelected());
            ArrayList<Song> specificDifficultyList = Scraping.getSpecificDifficultySongs(specificlevelList, this.comboDifficultySelect.getSelectedItem().toString());
            ArrayList<Song> specificAttributeList = Scraping.getSpecificAttributeSongs(specificDifficultyList, this.comboAttribute.getSelectedItem().toString());
            ArrayList<Song> specificTypeList = Scraping.getSpecificAlbumTypeSongs(specificAttributeList, EstimateAlbumTypeCycle.getCurrentCycle());
            if (!selectedSongsList.isEmpty()) {
                selectedSongsList.clear();
            }
            selectedSongsList.addAll(this.comboDifficultySelect.getSelectedItem().equals("MASTER+") || this.comboDifficultySelect.getSelectedItem().equals("\u24c1MASTER+") ? specificTypeList : specificAttributeList);
            this.logger.info("Songs are selected.We are Ready to go.");
            JOptionPane.showMessageDialog(null, Messages.MSGCompleteNarrowDown.toString());
        }, es).whenCompleteAsync((ret, ex) -> {
            if (ex != null) {
                this.logger.error("Exception was thrown during concurrent process", ex);
                CrashHandler handle = new CrashHandler(new IllegalStateException((Throwable)ex));
                handle.execute();
            }
        }, (Executor)es));
        this.btnImport.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 1, 13));
        this.btnImport.setEnabled(false);
        this.panelEastMain.add((Component)this.btnImport, "2, 2, fill, fill");
        this.btnConfig = new JButton(Messages.MSGConfigurations.toString());
        this.btnConfig.addActionListener(e -> CompletableFuture.runAsync(() -> {
            ProcessBuilder builder = new ProcessBuilder("java", "-jar", "Configurations.jar");
            try {
                builder.start();
            }
            catch (IOException e1) {
                this.logger.error("Exception was thrown during concurrent process", (Throwable)e1);
                CrashHandler handle = new CrashHandler(new IllegalStateException(e1));
                handle.execute();
            }
        }, es).whenCompleteAsync((ret, ex) -> {
            if (ex != null) {
                this.logger.error("Exception was thrown during concurrent process", ex);
                CrashHandler handle = new CrashHandler(new IllegalStateException((Throwable)ex));
                handle.execute();
            }
        }, (Executor)es));
        this.panelEastMain.add((Component)this.btnConfig, "2, 6, fill, fill");
        this.btnStart = new JButton(Messages.MSGCalcStart.toString());
        this.btnStart.addActionListener(e -> CompletableFuture.runAsync(() -> {
            Random random = new Random(System.currentTimeMillis());
            this.toolIntegrateList = new ArrayList<Song>();
            StringBuilder paneBuilder = new StringBuilder();
            this.integratorArray = new String[this.property.getSongLimit()];
            int i = 0;
            while (i < this.property.getSongLimit()) {
                int randomInt = random.nextInt(selectedSongsList.size());
                String typeString = this.comboDifficultySelect.getSelectedItem().equals("MASTER+") || this.comboDifficultySelect.getSelectedItem().equals("\u24c1MASTER+") ? EstimateAlbumTypeCycle.getCurrentCycle() : "";
                paneBuilder.append(i + 1).append(Messages.MSGNumberOfSongs.toString()).append(" ").append(selectedSongsList.get(randomInt).getAttribute()).append("[").append(selectedSongsList.get(randomInt).getDifficulty()).append("]\u300c").append(selectedSongsList.get(randomInt).getName()).append("\u300d\uff01(Lv:").append(selectedSongsList.get(randomInt).getLevel()).append(" ").append(typeString).append(")\n\n");
                this.integratorArray[i] = String.valueOf(selectedSongsList.get(randomInt).getName()) + "(Lv" + selectedSongsList.get(randomInt).getLevel() + ")\n";
                this.toolIntegrateList.add(selectedSongsList.get(randomInt));
                ++i;
            }
            paneBuilder.append(Messages.MSGThisPhrase.toString()).append(this.property.getSongLimit()).append(Messages.MSGPlayPhrase.toString());
            this.textArea.setText(paneBuilder.toString());
            this.integratorBool = true;
            this.logger.info("show up completed.");
            this.labelCurrentSongOrderTool.setText("null");
            progressTool.setValue(0);
            this.listToolMapDataFuture = CompletableFuture.supplyAsync(() -> {
                List<String> data = this.toolIntegrateList.stream().map(s -> s.getName()).collect(Collectors.toList());
                this.fetchData = new FetchFromAPI(data.toArray(new String[0]));
                return this.fetchData.getInformation();
            }, es);
            this.logger.debug("api fetch inquery published");
        }, es).whenCompleteAsync((ret, ex) -> {
            if (ex != null) {
                this.logger.error("Exception was thrown during concurrent process", ex);
                CrashHandler handle = new CrashHandler(new IllegalStateException((Throwable)ex));
                handle.execute();
            }
        }, (Executor)es));
        this.btnStart.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 1, 13));
        this.panelEastMain.add((Component)this.btnStart, "2, 4, fill, fill");
        this.btnManualUpdate = new JButton(Messages.MSGManualUpdate.toString());
        this.btnManualUpdate.addActionListener(e -> {
            this.impl = new ManualUpdateThreadImpl();
            CompletableFuture.runAsync(this.impl, es).whenCompleteAsync((t, u) -> {
                if (u != null) {
                    this.logger.warn("Exception while processing update manually.", u);
                    CrashHandler handle = new CrashHandler(new IllegalStateException((Throwable)u));
                    handle.execute();
                    JOptionPane.showMessageDialog(null, "There was a problem during processing library update manually.\nIf this appears repeatedly, please contact developer with your app log.");
                }
            }, (Executor)es);
        });
        this.panelEastMain.add((Component)this.btnManualUpdate, "2, 8, fill, fill");
        this.btnTwitterIntegration = new JButton(Messages.MSGTwitterIntegration.toString());
        this.btnTwitterIntegration.addActionListener(e -> CompletableFuture.runAsync(() -> {
            boolean authorizationStatus = TwitterIntegration.authorization();
            String updatedStatus = Messages.MSGUsingThisAppPhrase.toString();
            int lengthLimit = updatedStatus.length();
            boolean isBroken = false;
            if (!this.integratorBool) {
                JOptionPane.showMessageDialog(null, Messages.MSGNotPlayYet.toString());
                return;
            }
            String[] stringArray = this.integratorArray;
            int n = this.integratorArray.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                updatedStatus = String.valueOf(updatedStatus) + element;
                if ((lengthLimit += element.length()) > 69) {
                    isBroken = true;
                    break;
                }
                ++n2;
            }
            updatedStatus = isBroken ? String.valueOf(updatedStatus) + Messages.MSGTwitterPlayOtherwisePhrase.toString() + "\n#DelesteRandomSelector #\u30c7\u30ec\u30b9\u30c6 " : String.valueOf(updatedStatus) + Messages.MSGTwitterPlayOnlyPhrase.toString() + "\n#DelesteRandomSelector #\u30c7\u30ec\u30b9\u30c6 ";
            this.logger.info("status message constructed.");
            lengthLimit = updatedStatus.length();
            if (authorizationStatus) {
                int option = JOptionPane.showConfirmDialog(null, String.valueOf(Messages.MSGTwitterIntegrationConfirm.toString()) + updatedStatus + Messages.MSGStringLength.toString() + lengthLimit);
                this.logger.info("user seletced: " + option);
                switch (option) {
                    case 0: {
                        TwitterIntegration.PostTwitter(updatedStatus);
                        this.logger.info("Success to update the status.");
                        JOptionPane.showMessageDialog(null, Messages.MSGCompletePost.toString());
                        break;
                    }
                    case 1: {
                        this.logger.info("There is no will to post.");
                        break;
                    }
                    case 2: {
                        this.logger.info("The Operation was canceled by user.");
                        break;
                    }
                }
            } else {
                this.logger.info("seems to reject the permission.it should need try again.");
            }
        }, es).whenCompleteAsync((ret, ex) -> {
            if (ex != null) {
                this.logger.error("Exception was thrown during concurrent process", ex);
                CrashHandler handle = new CrashHandler(new IllegalStateException((Throwable)ex));
                handle.execute();
            }
        }, (Executor)es));
        this.btnTwitterIntegration.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 1, 11));
        this.panelEastMain.add((Component)this.btnTwitterIntegration, "2, 10, fill, fill");
        this.btnExit = new JButton(Messages.MSGTerminate.toString());
        this.btnExit.addActionListener(e -> {
            if (this.softwareUpdateFuture.isDone() || this.albumTypeEstimateFuture.isDone() || !this.impl.getFlag()) {
                this.logger.info("Requested Exit by Button.");
                this.logger.info("Shut down thread pool.");
                es.shutdown();
                System.exit(0);
            } else {
                JOptionPane.showMessageDialog(null, Messages.MSGInternalYpdateNotDoneYet.toString());
            }
        });
        this.btnExit.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 1, 13));
        this.panelEastMain.add((Component)this.btnExit, "2, 12, fill, fill");
        this.panelCenterMain = new JPanel();
        this.panelMain.add((Component)this.panelCenterMain, "Center");
        this.panelCenterMain.setLayout(new BorderLayout(0, 0));
        this.scrollPane = new JScrollPane();
        this.panelCenterMain.add(this.scrollPane);
        this.textArea = new JTextArea();
        this.textArea.setText(String.valueOf(Messages.MSGNarrowDownProcedure.toString()) + this.property.getSongLimit() + Messages.MSGCurrentAlbumType.toString() + this.albumType);
        this.textArea.setEditable(false);
        this.scrollPane.setViewportView(this.textArea);
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.addChangeListener(e -> CompletableFuture.runAsync(() -> {
            this.labelToolProgress.setText(Messages.MSGAPIWaitAPIFetch.toString());
            String currentTabName = this.tabbedPane.getTitleAt(this.tabbedPane.getSelectedIndex());
            if (currentTabName.equals("SongInfo") && this.labelCurrentSongOrderTool.getText().equals("null")) {
                this.logger.info("Detected switching tool tab");
                this.listToolMapData = this.listToolMapDataFuture.join();
                if (this.toolIntegrateList == null) {
                    return;
                }
                Song firstSong = this.toolIntegrateList.get(0);
                Map<Object, Object> fetchMap = new HashMap();
                for (Map<String, String> tmpMap : this.listToolMapData) {
                    String normalizeLocalName;
                    String normalizeApiName = Normalizer.normalize(tmpMap.get("songname").toString(), Normalizer.Form.NFKD);
                    if (!normalizeApiName.equals(normalizeLocalName = Normalizer.normalize(firstSong.getName(), Normalizer.Form.NFKD))) continue;
                    fetchMap = tmpMap;
                    break;
                }
                this.labelSongNameToolTip.setText(firstSong.getName());
                this.labelAttributeToolTip.setText(firstSong.getAttribute());
                this.labelDifficultyToolTip.setText(firstSong.getDifficulty());
                this.labelLevelToolTip.setText(String.valueOf(firstSong.getLevel()));
                this.labelNotesToolTip.setText(String.valueOf(firstSong.getNotes()));
                this.labelCurrentSongOrderTool.setText("1");
                this.labelLyricToolTip.setText((String)fetchMap.get("lyric"));
                this.labelComposerToolTip.setText((String)fetchMap.get("composer"));
                this.labelArrangeToolTip.setText((String)fetchMap.get("arrange"));
                this.labelMemberToolTip.setText("<html><body>" + (String)fetchMap.get("member") + "</html></body>");
            }
        }, es).whenCompleteAsync((ret, ex) -> {
            this.labelToolProgress.setText("Information parse Complete.");
            if (ex != null) {
                this.logger.error("Exception was thrown during concurrent process", ex);
                CrashHandler handle = new CrashHandler(new IllegalStateException((Throwable)ex));
                handle.execute();
            }
        }, (Executor)es));
        this.tabbedPane.addTab("Main", null, this.panelMain, null);
        this.contentPane.add((Component)this.tabbedPane, "name_307238585319500");
        this.panelInfo = new JPanel();
        this.tabbedPane.addTab("SongInfo", null, this.panelInfo, null);
        this.panelInfo.setLayout(new BorderLayout(0, 0));
        this.panelNorthTool = new JPanel();
        this.panelInfo.add((Component)this.panelNorthTool, "North");
        this.panelNorthTool.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"center:max(524dlu;default)"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(30dlu;default)")}, new RowSpec[]{RowSpec.decode((String)"max(16dlu;default)")}));
        this.labelSubToolTitle = new JLabel("\u697d\u66f2\u60c5\u5831");
        this.labelSubToolTitle.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 0, 16));
        this.panelNorthTool.add((Component)this.labelSubToolTitle, "1, 1");
        this.labelVersionTool = new JLabel(CheckVersion.getVersion());
        this.labelVersionTool.setFont(new Font("SansSerif", 1, 12));
        this.panelNorthTool.add((Component)this.labelVersionTool, "3, 1");
        this.panelCenterTool = new JPanel();
        this.panelInfo.add((Component)this.panelCenterTool, "Center");
        this.panelCenterTool.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(40dlu;default)"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"10dlu"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"10dlu"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(12dlu;default)"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(90dlu;default)"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(14dlu;default)"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(14dlu;default)"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(90dlu;default)"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(90dlu;default)")}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        this.labelInfoPlaySongs = new JLabel(Messages.MSGInfoPlayedSongs.toString());
        this.labelInfoPlaySongs.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 0, 12));
        this.panelCenterTool.add((Component)this.labelInfoPlaySongs, "2, 2, center, default");
        this.labelSongNameToolTitle = new JLabel(Messages.MSGInfoSongName.toString());
        this.labelSongNameToolTitle.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 0, 12));
        this.panelCenterTool.add((Component)this.labelSongNameToolTitle, "2, 6, center, default");
        this.labelSongNameToolTip = new JLabel(Messages.MSGInfoWait.toString());
        this.labelSongNameToolTip.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 0, 12));
        this.panelCenterTool.add((Component)this.labelSongNameToolTip, "10, 6, center, default");
        this.labelLyricToolTitle = new JLabel(Messages.MSGInfoLyricsBy.toString());
        this.labelLyricToolTitle.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 0, 12));
        this.panelCenterTool.add((Component)this.labelLyricToolTitle, "17, 6, center, default");
        this.labelLyricToolTip = new JLabel(Messages.MSGInfoWait.toString());
        this.labelLyricToolTip.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 0, 12));
        this.panelCenterTool.add((Component)this.labelLyricToolTip, "25, 6, center, default");
        this.labelAttributeToolTitle = new JLabel(Messages.MSGInfoSongAttribute.toString());
        this.labelAttributeToolTitle.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 0, 12));
        this.panelCenterTool.add((Component)this.labelAttributeToolTitle, "2, 10, center, default");
        this.labelAttributeToolTip = new JLabel(Messages.MSGInfoWait.toString());
        this.labelAttributeToolTip.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 0, 12));
        this.panelCenterTool.add((Component)this.labelAttributeToolTip, "10, 10, center, default");
        this.labelComposerToolTitle = new JLabel(Messages.MSGInfoComposedBy.toString());
        this.labelComposerToolTitle.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 0, 12));
        this.panelCenterTool.add((Component)this.labelComposerToolTitle, "17, 10, center, default");
        this.labelComposerToolTip = new JLabel(Messages.MSGInfoWait.toString());
        this.labelComposerToolTip.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 0, 12));
        this.panelCenterTool.add((Component)this.labelComposerToolTip, "25, 10, center, default");
        this.labelDifficultyToolTitle = new JLabel(Messages.MSGInfoSongDifficulty.toString());
        this.labelDifficultyToolTitle.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 0, 12));
        this.panelCenterTool.add((Component)this.labelDifficultyToolTitle, "2, 14, center, default");
        this.labelDifficultyToolTip = new JLabel(Messages.MSGInfoWait.toString());
        this.labelDifficultyToolTip.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 0, 12));
        this.panelCenterTool.add((Component)this.labelDifficultyToolTip, "10, 14, center, default");
        this.labelArrangeToolTitle = new JLabel(Messages.MSGInfoArrangedBy.toString());
        this.labelArrangeToolTitle.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 0, 12));
        this.panelCenterTool.add((Component)this.labelArrangeToolTitle, "17, 14, center, default");
        this.labelArrangeToolTip = new JLabel(Messages.MSGInfoWait.toString());
        this.labelArrangeToolTip.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 0, 12));
        this.panelCenterTool.add((Component)this.labelArrangeToolTip, "25, 14, center, default");
        this.labelLevelToolTitle = new JLabel(Messages.MSGInfoSongLevel.toString());
        this.labelLevelToolTitle.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 0, 12));
        this.panelCenterTool.add((Component)this.labelLevelToolTitle, "2, 18, center, default");
        this.labelLevelToolTip = new JLabel(Messages.MSGInfoWait.toString());
        this.labelLevelToolTip.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 0, 12));
        this.panelCenterTool.add((Component)this.labelLevelToolTip, "10, 18, center, default");
        this.labelMemberToolTitle = new JLabel(Messages.MSGInfoMember.toString());
        this.labelMemberToolTitle.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 0, 12));
        this.panelCenterTool.add((Component)this.labelMemberToolTitle, "17, 18, center, default");
        this.labelMemberToolTip = new JLabel(Messages.MSGInfoWait.toString());
        this.labelMemberToolTip.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 0, 12));
        this.panelCenterTool.add((Component)this.labelMemberToolTip, "25, 18, center, default");
        this.labelNotesToolTitle = new JLabel(Messages.MSGInfoSongNotes.toString());
        this.labelNotesToolTitle.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 0, 12));
        this.panelCenterTool.add((Component)this.labelNotesToolTitle, "2, 22, center, default");
        this.labelNotesToolTip = new JLabel(Messages.MSGInfoWait.toString());
        this.labelNotesToolTip.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 0, 12));
        this.panelCenterTool.add((Component)this.labelNotesToolTip, "10, 22, center, default");
        this.btnNextSongTool = new JButton("next");
        this.btnNextSongTool.addActionListener(e -> CompletableFuture.runAsync(() -> {
            int currentIndex = Integer.parseInt(this.labelCurrentSongOrderTool.getText()) - 1;
            if (currentIndex != this.property.getSongLimit() - 1) {
                Song nextSong = this.toolIntegrateList.get(currentIndex + 1);
                this.logger.info("currently : {} Next: {}", (Object)(currentIndex + 1), (Object)(currentIndex + 2));
                this.logger.info("nextSong: {}", (Object)nextSong);
                Map<Object, Object> fetchMap = new HashMap();
                for (Map<String, String> tmpMap : this.listToolMapData) {
                    String normalizeLocalName;
                    String normalizeApiName = Normalizer.normalize(tmpMap.get("songname").toString(), Normalizer.Form.NFKD);
                    if (!normalizeApiName.equals(normalizeLocalName = Normalizer.normalize(nextSong.getName(), Normalizer.Form.NFKD))) continue;
                    fetchMap = tmpMap;
                    break;
                }
                this.labelSongNameToolTip.setText(nextSong.getName());
                this.labelAttributeToolTip.setText(nextSong.getAttribute());
                this.labelDifficultyToolTip.setText(nextSong.getDifficulty());
                this.labelLevelToolTip.setText(String.valueOf(nextSong.getLevel()));
                this.labelNotesToolTip.setText(String.valueOf(nextSong.getNotes()));
                this.labelCurrentSongOrderTool.setText(String.valueOf(currentIndex + 2));
                this.labelLyricToolTip.setText((String)fetchMap.get("lyric"));
                this.labelComposerToolTip.setText((String)fetchMap.get("composer"));
                this.labelArrangeToolTip.setText((String)fetchMap.get("arrange"));
                this.labelMemberToolTip.setText("<html><body>" + (String)fetchMap.get("member") + "</html></body>");
            }
        }, es).whenCompleteAsync((ret, ex) -> {
            if (ex != null) {
                this.logger.error("Exception was thrown during concurrent process", ex);
            }
        }, (Executor)es));
        this.btnPrevSongTool = new JButton("prev");
        this.btnPrevSongTool.addActionListener(e -> CompletableFuture.runAsync(() -> {
            int currentIndex = Integer.parseInt(this.labelCurrentSongOrderTool.getText()) - 1;
            if (currentIndex != 0) {
                Song prevSong = this.toolIntegrateList.get(currentIndex - 1);
                this.logger.info("currently : {} Next: {}", (Object)(currentIndex + 1), (Object)currentIndex);
                this.logger.info("prevSong: {}", (Object)prevSong);
                Map<Object, Object> fetchMap = new HashMap();
                for (Map<String, String> tmpMap : this.listToolMapData) {
                    String normalizeLocalName;
                    String normalizeApiName = Normalizer.normalize(tmpMap.get("songname").toString(), Normalizer.Form.NFKD);
                    if (!normalizeApiName.equals(normalizeLocalName = Normalizer.normalize(prevSong.getName(), Normalizer.Form.NFKD))) continue;
                    fetchMap = tmpMap;
                    break;
                }
                this.labelSongNameToolTip.setText(prevSong.getName());
                this.labelAttributeToolTip.setText(prevSong.getAttribute());
                this.labelDifficultyToolTip.setText(prevSong.getDifficulty());
                this.labelLevelToolTip.setText(String.valueOf(prevSong.getLevel()));
                this.labelNotesToolTip.setText(String.valueOf(prevSong.getNotes()));
                this.labelCurrentSongOrderTool.setText(String.valueOf(currentIndex));
                this.labelLyricToolTip.setText((String)fetchMap.get("lyric"));
                this.labelComposerToolTip.setText((String)fetchMap.get("composer"));
                this.labelArrangeToolTip.setText((String)fetchMap.get("arrange"));
                this.labelMemberToolTip.setText("<html><body>" + (String)fetchMap.get("member") + "</html></body>");
            }
        }, es).whenCompleteAsync((ret, ex) -> {
            if (ex != null) {
                this.logger.error("Exception was thrown during concurrent process", ex);
            }
        }, (Executor)es));
        this.btnPrevSongTool.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 0, 12));
        this.panelCenterTool.add((Component)this.btnPrevSongTool, "10, 28");
        this.labelCurrentSongOrderTool = new JLabel("null");
        this.panelCenterTool.add((Component)this.labelCurrentSongOrderTool, "12, 28");
        this.labelSlashTool = new JLabel("/");
        this.panelCenterTool.add((Component)this.labelSlashTool, "14, 28");
        this.labelSongLimitTool = new JLabel(String.valueOf(this.property.getSongLimit()));
        this.panelCenterTool.add((Component)this.labelSongLimitTool, "15, 28");
        this.btnNextSongTool.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 0, 12));
        this.panelCenterTool.add((Component)this.btnNextSongTool, "17, 28");
        this.btnMoreInfoTool = new JButton(Messages.MSGInfoOpenBrowser.toString());
        this.btnMoreInfoTool.addActionListener(e -> CompletableFuture.runAsync(() -> {
            int currentIndex = Integer.parseInt(this.labelCurrentSongOrderTool.getText()) - 1;
            Song currentSong = this.toolIntegrateList.get(currentIndex);
            Map<Object, Object> fetchMap = new HashMap();
            for (Map<String, String> tmpMap : this.listToolMapData) {
                String normalizeLocalName;
                String normalizeApiName = Normalizer.normalize(tmpMap.get("songname").toString(), Normalizer.Form.NFKD);
                if (!normalizeApiName.equals(normalizeLocalName = Normalizer.normalize(currentSong.getName(), Normalizer.Form.NFKD))) continue;
                fetchMap = tmpMap;
                break;
            }
            Desktop desk = Desktop.getDesktop();
            String api = (String)fetchMap.get("link");
            try {
                URI uri = new URI(api);
                this.logger.info("Opening default browser with : {}", (Object)uri);
                desk.browse(uri);
            }
            catch (IOException | URISyntaxException e1) {
                JOptionPane.showMessageDialog(null, "\u3053\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u306f\u4eee\u3067\u3059\u3002Exception : " + e1.getClass().getSimpleName());
                this.logger.error("Exception while opening default browser.", (Throwable)e1);
            }
        }, es).whenCompleteAsync((ret, ex) -> {
            if (ex != null) {
                this.logger.warn("Exception was thrown during action events.", ex);
            }
        }, (Executor)es));
        this.btnMoreInfoTool.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 0, 12));
        this.panelCenterTool.add((Component)this.btnMoreInfoTool, "25, 28");
        this.labelToolProgress = new JLabel(Messages.MSGAPIWaitAPIFetch.toString());
        this.labelToolProgress.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 0, 12));
        this.panelCenterTool.add((Component)this.labelToolProgress, "10, 32, center, default");
        progressTool = new JProgressBar();
        progressTool.setStringPainted(true);
        progressTool.setValue(0);
        progressTool.setMaximum(this.property.getSongLimit());
        this.panelCenterTool.add((Component)progressTool, "17, 32");
        labelInfoProgressSongName = new JLabel("Processing:");
        labelInfoProgressSongName.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 0, 12));
        this.panelCenterTool.add((Component)labelInfoProgressSongName, "10, 34");
        this.panelScore = new JPanel();
        this.tabbedPane.addTab("Scores", null, this.panelScore, null);
        this.panelScore.setLayout(new BorderLayout(0, 0));
        this.panelScoreNorth = new JPanel();
        this.panelScore.add((Component)this.panelScoreNorth, "North");
        this.panelScoreNorth.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"828px"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(53dlu;default)")}, new RowSpec[]{RowSpec.decode((String)"20px")}));
        this.labelScoreTitle = new JLabel("\u30b9\u30b3\u30a2\u3001\u30d5\u30a1\u30f3\u8a08\u7b97");
        this.labelScoreTitle.setFont(new Font("UD \u30c7\u30b8\u30bf\u30eb \u6559\u79d1\u66f8\u4f53 NP-B", 0, 16));
        this.panelScoreNorth.add((Component)this.labelScoreTitle, "1, 1, center, center");
        this.labelScoreVersion = new JLabel(CheckVersion.getVersion());
        this.labelScoreVersion.setFont(new Font("SansSerif", 1, 12));
        this.panelScoreNorth.add((Component)this.labelScoreVersion, "3, 1, center, default");
        this.panelScoreCenter = new JPanel();
        this.panelScore.add((Component)this.panelScoreCenter, "Center");
        if (isFirst || !this.property.isCheckLibraryUpdates()) {
            this.setEnabled.run();
        }
    }
}

