/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattServer;
import android.bluetooth.BluetoothGattServerCallback;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.AdvertiseCallback;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertiseSettings;
import android.bluetooth.le.BluetoothLeAdvertiser;
import android.content.Context;
import android.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;

public class QtBluetoothLEServer {
    private static final String TAG = "QtBluetoothGattServer";
    long qtObject = 0L;
    private Context qtContext = null;
    private final BluetoothAdapter mBluetoothAdapter;
    private BluetoothGattServer mGattServer = null;
    private BluetoothLeAdvertiser mLeAdvertiser = null;
    private String mRemoteName = "";
    private String mRemoteAddress = "";
    private static final UUID CLIENT_CHARACTERISTIC_CONFIGURATION_UUID = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
    ClientCharacteristicManager clientCharacteristicManager = new ClientCharacteristicManager();
    private BluetoothGattServerCallback mGattServerListener = new BluetoothGattServerCallback(){

        public void onConnectionStateChange(BluetoothDevice bluetoothDevice, int n, int n2) {
            int n3;
            Log.w((String)QtBluetoothLEServer.TAG, (String)("Our gatt server connection state changed, new state: " + n2 + " " + n));
            super.onConnectionStateChange(bluetoothDevice, n, n2);
            int n4 = 0;
            switch (n2) {
                case 0: {
                    n4 = 0;
                    QtBluetoothLEServer.this.clientCharacteristicManager.markDeviceConnectivity(bluetoothDevice, false);
                    QtBluetoothLEServer.this.mGattServer.close();
                    break;
                }
                case 2: {
                    QtBluetoothLEServer.this.clientCharacteristicManager.markDeviceConnectivity(bluetoothDevice, true);
                    n4 = 2;
                }
            }
            QtBluetoothLEServer.this.mRemoteName = bluetoothDevice.getName();
            QtBluetoothLEServer.this.mRemoteAddress = bluetoothDevice.getAddress();
            switch (n) {
                case 0: {
                    n3 = 0;
                    break;
                }
                default: {
                    Log.w((String)QtBluetoothLEServer.TAG, (String)("Unhandled error code on peripheral connectionStateChanged: " + n + " " + n2));
                    n3 = n;
                }
            }
            QtBluetoothLEServer.this.leServerConnectionStateChange(QtBluetoothLEServer.this.qtObject, n3, n4);
        }

        public void onServiceAdded(int n, BluetoothGattService bluetoothGattService) {
            super.onServiceAdded(n, bluetoothGattService);
        }

        public void onCharacteristicReadRequest(BluetoothDevice bluetoothDevice, int n, int n2, BluetoothGattCharacteristic bluetoothGattCharacteristic) {
            try {
                byte[] byArray = Arrays.copyOfRange(bluetoothGattCharacteristic.getValue(), n2, bluetoothGattCharacteristic.getValue().length);
                QtBluetoothLEServer.this.mGattServer.sendResponse(bluetoothDevice, n, 0, n2, byArray);
            }
            catch (Exception exception) {
                Log.w((String)QtBluetoothLEServer.TAG, (String)("onCharacteristicReadRequest: " + n + " " + n2 + " " + bluetoothGattCharacteristic.getValue().length));
                exception.printStackTrace();
                QtBluetoothLEServer.this.mGattServer.sendResponse(bluetoothDevice, n, 257, n2, null);
            }
            super.onCharacteristicReadRequest(bluetoothDevice, n, n2, bluetoothGattCharacteristic);
        }

        public void onCharacteristicWriteRequest(BluetoothDevice bluetoothDevice, int n, BluetoothGattCharacteristic bluetoothGattCharacteristic, boolean bl, boolean bl2, int n2, byte[] byArray) {
            Log.w((String)QtBluetoothLEServer.TAG, (String)"onCharacteristicWriteRequest");
            int n3 = 0;
            boolean bl3 = false;
            if (!bl) {
                if (n2 == 0) {
                    bluetoothGattCharacteristic.setValue(byArray);
                    QtBluetoothLEServer.this.leServerCharacteristicChanged(QtBluetoothLEServer.this.qtObject, bluetoothGattCharacteristic, byArray);
                    bl3 = true;
                } else {
                    Log.w((String)QtBluetoothLEServer.TAG, (String)("onCharacteristicWriteRequest: !preparedWrite, offset " + n2 + ", Not supported"));
                    n3 = 6;
                }
            } else {
                Log.w((String)QtBluetoothLEServer.TAG, (String)("onCharacteristicWriteRequest: preparedWrite, offset " + n2 + ", Not supported"));
                n3 = 6;
            }
            if (bl2) {
                QtBluetoothLEServer.this.mGattServer.sendResponse(bluetoothDevice, n, n3, n2, byArray);
            }
            if (bl3) {
                QtBluetoothLEServer.this.sendNotificationsOrIndications(bluetoothGattCharacteristic);
            }
            super.onCharacteristicWriteRequest(bluetoothDevice, n, bluetoothGattCharacteristic, bl, bl2, n2, byArray);
        }

        public void onDescriptorReadRequest(BluetoothDevice bluetoothDevice, int n, int n2, BluetoothGattDescriptor bluetoothGattDescriptor) {
            byte[] byArray = bluetoothGattDescriptor.getValue();
            try {
                if (bluetoothGattDescriptor.getUuid().equals(CLIENT_CHARACTERISTIC_CONFIGURATION_UUID) && (byArray = QtBluetoothLEServer.this.clientCharacteristicManager.valueFor(bluetoothGattDescriptor.getCharacteristic(), bluetoothDevice)) == null) {
                    byArray = bluetoothGattDescriptor.getValue();
                }
                byArray = Arrays.copyOfRange(byArray, n2, byArray.length);
                QtBluetoothLEServer.this.mGattServer.sendResponse(bluetoothDevice, n, 0, n2, byArray);
            }
            catch (Exception exception) {
                Log.w((String)QtBluetoothLEServer.TAG, (String)("onDescriptorReadRequest: " + n + " " + n2 + " " + byArray.length));
                exception.printStackTrace();
                QtBluetoothLEServer.this.mGattServer.sendResponse(bluetoothDevice, n, 257, n2, null);
            }
            super.onDescriptorReadRequest(bluetoothDevice, n, n2, bluetoothGattDescriptor);
        }

        public void onDescriptorWriteRequest(BluetoothDevice bluetoothDevice, int n, BluetoothGattDescriptor bluetoothGattDescriptor, boolean bl, boolean bl2, int n2, byte[] byArray) {
            int n3 = 0;
            if (!bl) {
                if (n2 == 0) {
                    bluetoothGattDescriptor.setValue(byArray);
                    if (bluetoothGattDescriptor.getUuid().equals(CLIENT_CHARACTERISTIC_CONFIGURATION_UUID)) {
                        QtBluetoothLEServer.this.clientCharacteristicManager.insertOrUpdate(bluetoothGattDescriptor.getCharacteristic(), bluetoothDevice, byArray);
                    }
                    QtBluetoothLEServer.this.leServerDescriptorWritten(QtBluetoothLEServer.this.qtObject, bluetoothGattDescriptor, byArray);
                } else {
                    Log.w((String)QtBluetoothLEServer.TAG, (String)("onDescriptorWriteRequest: !preparedWrite, offset " + n2 + ", Not supported"));
                    n3 = 6;
                }
            } else {
                Log.w((String)QtBluetoothLEServer.TAG, (String)("onDescriptorWriteRequest: preparedWrite, offset " + n2 + ", Not supported"));
                n3 = 6;
            }
            if (bl2) {
                QtBluetoothLEServer.this.mGattServer.sendResponse(bluetoothDevice, n, n3, n2, byArray);
            }
            super.onDescriptorWriteRequest(bluetoothDevice, n, bluetoothGattDescriptor, bl, bl2, n2, byArray);
        }

        public void onExecuteWrite(BluetoothDevice bluetoothDevice, int n, boolean bl) {
            QtBluetoothLEServer.this.mGattServer.sendResponse(bluetoothDevice, n, 6, 0, null);
            super.onExecuteWrite(bluetoothDevice, n, bl);
        }

        public void onNotificationSent(BluetoothDevice bluetoothDevice, int n) {
            super.onNotificationSent(bluetoothDevice, n);
            Log.w((String)QtBluetoothLEServer.TAG, (String)("onNotificationSent" + bluetoothDevice + " " + n));
        }
    };
    private AdvertiseCallback mAdvertiseListener = new AdvertiseCallback(){

        public void onStartSuccess(AdvertiseSettings advertiseSettings) {
            super.onStartSuccess(advertiseSettings);
        }

        public void onStartFailure(int n) {
            Log.e((String)QtBluetoothLEServer.TAG, (String)("Advertising failure: " + n));
            super.onStartFailure(n);
            int n2 = 0;
            switch (n) {
                case 3: {
                    return;
                }
                case 1: {
                    n2 = 1;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 4;
                }
            }
            if (n2 > 0) {
                QtBluetoothLEServer.this.leServerAdvertisementError(QtBluetoothLEServer.this.qtObject, n2);
            }
        }
    };

    public String remoteName() {
        return this.mRemoteName;
    }

    public String remoteAddress() {
        return this.mRemoteAddress;
    }

    public QtBluetoothLEServer(Context context) {
        this.qtContext = context;
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.mBluetoothAdapter == null || this.qtContext == null) {
            Log.w((String)TAG, (String)"Missing Bluetooth adapter or Qt context. Peripheral role disabled.");
            return;
        }
        BluetoothManager bluetoothManager = (BluetoothManager)this.qtContext.getSystemService("bluetooth");
        if (bluetoothManager == null) {
            Log.w((String)TAG, (String)"Bluetooth service not available.");
            return;
        }
        this.mLeAdvertiser = this.mBluetoothAdapter.getBluetoothLeAdvertiser();
        if (!this.mBluetoothAdapter.isMultipleAdvertisementSupported()) {
            Log.w((String)TAG, (String)"Device does not support Bluetooth Low Energy advertisement.");
        } else {
            Log.w((String)TAG, (String)"Let's do BTLE Peripheral.");
        }
    }

    public boolean connectServer() {
        if (this.mGattServer != null) {
            return true;
        }
        BluetoothManager bluetoothManager = (BluetoothManager)this.qtContext.getSystemService("bluetooth");
        if (bluetoothManager == null) {
            Log.w((String)TAG, (String)"Bluetooth service not available.");
            return false;
        }
        this.mGattServer = bluetoothManager.openGattServer(this.qtContext, this.mGattServerListener);
        return this.mGattServer != null;
    }

    public void disconnectServer() {
        if (this.mGattServer == null) {
            return;
        }
        this.mGattServer.close();
        this.mGattServer = null;
        this.mRemoteAddress = "";
        this.mRemoteName = "";
        this.leServerConnectionStateChange(this.qtObject, 0, 0);
    }

    public boolean startAdvertising(AdvertiseData advertiseData, AdvertiseData advertiseData2, AdvertiseSettings advertiseSettings) {
        if (this.mLeAdvertiser == null) {
            return false;
        }
        if (!this.connectServer()) {
            Log.w((String)TAG, (String)"Server::startAdvertising: Cannot open GATT server");
            return false;
        }
        Log.w((String)TAG, (String)"Starting to advertise.");
        this.mLeAdvertiser.startAdvertising(advertiseSettings, advertiseData, advertiseData2, this.mAdvertiseListener);
        return true;
    }

    public void stopAdvertising() {
        if (this.mLeAdvertiser == null) {
            return;
        }
        this.mLeAdvertiser.stopAdvertising(this.mAdvertiseListener);
        Log.w((String)TAG, (String)"Advertisement stopped.");
    }

    public void addService(BluetoothGattService bluetoothGattService) {
        if (!this.connectServer()) {
            Log.w((String)TAG, (String)"Server::addService: Cannot open GATT server");
            return;
        }
        this.mGattServer.addService(bluetoothGattService);
    }

    private void sendNotificationsOrIndications(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        ListIterator<BluetoothDevice> listIterator = this.clientCharacteristicManager.getToBeUpdatedDevices(bluetoothGattCharacteristic).listIterator();
        while (listIterator.hasNext()) {
            BluetoothDevice bluetoothDevice = listIterator.next();
            byte[] byArray = this.clientCharacteristicManager.valueFor(bluetoothGattCharacteristic, bluetoothDevice);
            if (byArray == null) continue;
            if (Arrays.equals(byArray, BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE)) {
                this.mGattServer.notifyCharacteristicChanged(bluetoothDevice, bluetoothGattCharacteristic, false);
                continue;
            }
            if (!Arrays.equals(byArray, BluetoothGattDescriptor.ENABLE_INDICATION_VALUE)) continue;
            this.mGattServer.notifyCharacteristicChanged(bluetoothDevice, bluetoothGattCharacteristic, true);
        }
    }

    public boolean writeCharacteristic(BluetoothGattService bluetoothGattService, UUID uUID, byte[] byArray) {
        BluetoothGattCharacteristic bluetoothGattCharacteristic = null;
        List list = bluetoothGattService.getCharacteristics();
        for (BluetoothGattCharacteristic bluetoothGattCharacteristic2 : list) {
            if (bluetoothGattCharacteristic2.getUuid().equals(uUID) && bluetoothGattCharacteristic == null) {
                bluetoothGattCharacteristic = bluetoothGattCharacteristic2;
                continue;
            }
            if (!bluetoothGattCharacteristic2.getUuid().equals(uUID)) continue;
            Log.w((String)TAG, (String)"Found second char with same UUID. Wrong char may have been selected.");
            break;
        }
        if (bluetoothGattCharacteristic == null) {
            Log.w((String)TAG, (String)"writeCharacteristic: update for unknown characteristic failed");
            return false;
        }
        bluetoothGattCharacteristic.setValue(byArray);
        this.sendNotificationsOrIndications(bluetoothGattCharacteristic);
        return true;
    }

    public boolean writeDescriptor(BluetoothGattService bluetoothGattService, UUID uUID, UUID uUID2, byte[] byArray) {
        BluetoothGattDescriptor bluetoothGattDescriptor = null;
        BluetoothGattCharacteristic bluetoothGattCharacteristic = null;
        List list = bluetoothGattService.getCharacteristics();
        for (BluetoothGattCharacteristic bluetoothGattCharacteristic2 : list) {
            if (!bluetoothGattCharacteristic2.getUuid().equals(uUID)) continue;
            if (bluetoothGattCharacteristic == null) {
                bluetoothGattCharacteristic = bluetoothGattCharacteristic2;
                continue;
            }
            Log.w((String)TAG, (String)"Found second char with same UUID. Wrong char may have been selected.");
            break;
        }
        if (bluetoothGattCharacteristic != null) {
            bluetoothGattDescriptor = bluetoothGattCharacteristic.getDescriptor(uUID2);
        }
        if (bluetoothGattCharacteristic == null || bluetoothGattDescriptor == null) {
            Log.w((String)TAG, (String)("writeDescriptor: update for unknown char or desc failed (" + bluetoothGattCharacteristic + ")"));
            return false;
        }
        bluetoothGattDescriptor.setValue(byArray);
        return true;
    }

    public native void leServerConnectionStateChange(long var1, int var3, int var4);

    public native void leServerAdvertisementError(long var1, int var3);

    public native void leServerCharacteristicChanged(long var1, BluetoothGattCharacteristic var3, byte[] var4);

    public native void leServerDescriptorWritten(long var1, BluetoothGattDescriptor var3, byte[] var4);

    private class ClientCharacteristicManager {
        private final HashMap<BluetoothGattCharacteristic, List<Entry>> notificationStore = new HashMap();

        private ClientCharacteristicManager() {
        }

        public void insertOrUpdate(BluetoothGattCharacteristic bluetoothGattCharacteristic, BluetoothDevice bluetoothDevice, byte[] byArray) {
            if (this.notificationStore.containsKey(bluetoothGattCharacteristic)) {
                List<Entry> list = this.notificationStore.get(bluetoothGattCharacteristic);
                for (int i = 0; i < list.size(); ++i) {
                    if (!list.get((int)i).device.equals((Object)bluetoothDevice)) continue;
                    Entry entry = list.get(i);
                    entry.value = byArray;
                    list.set(i, entry);
                    return;
                }
                Entry entry = new Entry();
                entry.device = bluetoothDevice;
                entry.value = byArray;
                entry.isConnected = true;
                list.add(entry);
                return;
            }
            Entry entry = new Entry();
            entry.device = bluetoothDevice;
            entry.value = byArray;
            entry.isConnected = true;
            LinkedList<Entry> linkedList = new LinkedList<Entry>();
            linkedList.add(entry);
            this.notificationStore.put(bluetoothGattCharacteristic, linkedList);
        }

        public void markDeviceConnectivity(BluetoothDevice bluetoothDevice, boolean bl) {
            for (BluetoothGattCharacteristic bluetoothGattCharacteristic : this.notificationStore.keySet()) {
                List<Entry> list = this.notificationStore.get(bluetoothGattCharacteristic);
                if (list == null) continue;
                ListIterator<Entry> listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    Entry entry = listIterator.next();
                    if (!entry.device.equals((Object)bluetoothDevice)) continue;
                    entry.isConnected = bl;
                }
            }
        }

        List<BluetoothDevice> getToBeUpdatedDevices(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
            ArrayList<BluetoothDevice> arrayList = new ArrayList<BluetoothDevice>();
            if (!this.notificationStore.containsKey(bluetoothGattCharacteristic)) {
                return arrayList;
            }
            ListIterator<Entry> listIterator = this.notificationStore.get(bluetoothGattCharacteristic).listIterator();
            while (listIterator.hasNext()) {
                arrayList.add(listIterator.next().device);
            }
            return arrayList;
        }

        byte[] valueFor(BluetoothGattCharacteristic bluetoothGattCharacteristic, BluetoothDevice bluetoothDevice) {
            if (!this.notificationStore.containsKey(bluetoothGattCharacteristic)) {
                return null;
            }
            List<Entry> list = this.notificationStore.get(bluetoothGattCharacteristic);
            for (int i = 0; i < list.size(); ++i) {
                Entry entry = list.get(i);
                if (!entry.device.equals((Object)bluetoothDevice) || !entry.isConnected) continue;
                return list.get((int)i).value;
            }
            return null;
        }

        private class Entry {
            BluetoothDevice device = null;
            byte[] value = null;
            boolean isConnected = false;

            private Entry() {
            }
        }
    }
}

