/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android;

import android.app.Activity;
import android.app.Service;
import android.content.ClipData;
import android.content.ClipDescription;
import android.content.ClipboardManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.UriPermission;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.provider.DocumentsContract;
import android.util.Log;
import android.view.ContextMenu;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MotionEvent;
import android.view.View;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Semaphore;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.qtproject.qt5.android.QtActivityDelegate;
import org.qtproject.qt5.android.QtServiceDelegate;
import org.qtproject.qt5.android.QtThread;

public class QtNative {
    private static Activity m_activity = null;
    private static boolean m_activityPaused = false;
    private static Service m_service = null;
    private static QtActivityDelegate m_activityDelegate = null;
    private static QtServiceDelegate m_serviceDelegate = null;
    public static Object m_mainActivityMutex = new Object();
    public static final String QtTAG = "Qt JAVA";
    private static ArrayList<Runnable> m_lostActions = new ArrayList();
    private static boolean m_started = false;
    private static boolean m_isKeyboardHiding = false;
    private static int m_displayMetricsScreenWidthPixels = 0;
    private static int m_displayMetricsScreenHeightPixels = 0;
    private static int m_displayMetricsDesktopWidthPixels = 0;
    private static int m_displayMetricsDesktopHeightPixels = 0;
    private static float m_displayMetricsRefreshRate = 60.0f;
    private static double m_displayMetricsXDpi = 0.0;
    private static double m_displayMetricsYDpi = 0.0;
    private static double m_displayMetricsScaledDensity = 1.0;
    private static double m_displayMetricsDensity = 1.0;
    private static int m_oldx;
    private static int m_oldy;
    private static final int m_moveThreshold = 0;
    private static ClipboardManager m_clipboardManager;
    private static Method m_checkSelfPermissionMethod;
    private static Boolean m_tabletEventSupported;
    private static boolean m_usePrimaryClip;
    public static QtThread m_qtThread;
    private static HashMap<String, Uri> m_cachedUris;
    private static ArrayList<String> m_knownDirs;
    private static final String NoPermissionErrorMessage = "No permissions to open Uri";
    private static final Runnable runPendingCppRunnablesRunnable;
    private static ClassLoader m_classLoader;
    public static final int IdCursorHandle = 1;
    public static final int IdLeftHandle = 2;
    public static final int IdRightHandle = 3;

    public static ClassLoader classLoader() {
        return m_classLoader;
    }

    public static void setClassLoader(ClassLoader classLoader) {
        m_classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Activity activity() {
        Object object = m_mainActivityMutex;
        synchronized (object) {
            return m_activity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Service service() {
        Object object = m_mainActivityMutex;
        synchronized (object) {
            return m_service;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QtActivityDelegate activityDelegate() {
        Object object = m_mainActivityMutex;
        synchronized (object) {
            return m_activityDelegate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QtServiceDelegate serviceDelegate() {
        Object object = m_mainActivityMutex;
        synchronized (object) {
            return m_serviceDelegate;
        }
    }

    public static String[] getStringArray(String string) {
        return string.split(",");
    }

    private static Uri getUriWithValidPermission(Context context, String string, String string2) {
        try {
            Uri uri = Uri.parse((String)string);
            String string3 = uri.getScheme();
            if (string3.compareTo("content") != 0) {
                return uri;
            }
            List list = context.getContentResolver().getPersistedUriPermissions();
            String string4 = uri.getPath();
            for (int i = 0; i < list.size(); ++i) {
                Uri uri2 = ((UriPermission)list.get(i)).getUri();
                boolean bl = ((UriPermission)list.get(i)).isReadPermission();
                if (!string2.equals("r")) {
                    bl = ((UriPermission)list.get(i)).isWritePermission();
                }
                if (!uri2.getPath().equals(string4) || !bl) continue;
                return uri2;
            }
            return uri;
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            return null;
        }
    }

    public static boolean openURL(Context context, String string, String string2) {
        Uri uri = QtNative.getUriWithValidPermission(context, string, "r");
        if (uri == null) {
            Log.e((String)QtTAG, (String)"openURL(): No permissions to open Uri");
            return false;
        }
        try {
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            intent.addFlags(1);
            if (!string2.isEmpty()) {
                intent.setDataAndType(uri, string2);
            }
            QtNative.activity().startActivity(intent);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.e((String)QtTAG, (String)"openURL(): Invalid Uri");
            illegalArgumentException.printStackTrace();
            return false;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Log.e((String)QtTAG, (String)"openURL(): Unsupported operation for given Uri");
            unsupportedOperationException.printStackTrace();
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static int openFdForContentUrl(Context context, String string, String string2) {
        Uri uri = m_cachedUris.get(string);
        if (uri == null) {
            uri = QtNative.getUriWithValidPermission(context, string, string2);
        }
        int n = -1;
        if (uri == null) {
            Log.e((String)QtTAG, (String)"openFdForContentUrl(): No permissions to open Uri");
            return n;
        }
        try {
            ContentResolver contentResolver = context.getContentResolver();
            ParcelFileDescriptor parcelFileDescriptor = contentResolver.openFileDescriptor(uri, string2);
            return parcelFileDescriptor.detachFd();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.e((String)QtTAG, (String)"openFdForContentUrl(): Invalid Uri");
            illegalArgumentException.printStackTrace();
        }
        catch (SecurityException securityException) {
            Log.e((String)QtTAG, (String)NoPermissionErrorMessage);
        }
        return n;
    }

    public static long getSize(Context context, String string) {
        long l = -1L;
        Uri uri = m_cachedUris.get(string);
        if (uri == null) {
            uri = QtNative.getUriWithValidPermission(context, string, "r");
        }
        if (uri == null) {
            Log.e((String)QtTAG, (String)NoPermissionErrorMessage);
            return l;
        }
        if (!m_cachedUris.containsKey(string)) {
            m_cachedUris.put(string, uri);
        }
        try {
            ContentResolver contentResolver = context.getContentResolver();
            Cursor cursor = contentResolver.query(uri, new String[]{"_size"}, null, null, null);
            if (cursor != null) {
                if (cursor.moveToFirst()) {
                    l = cursor.getLong(0);
                }
                cursor.close();
            }
            return l;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.e((String)QtTAG, (String)"getSize(): Invalid Uri");
            illegalArgumentException.printStackTrace();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Log.e((String)QtTAG, (String)"getSize(): Unsupported operation for given Uri");
            unsupportedOperationException.printStackTrace();
        }
        catch (SecurityException securityException) {
            Log.e((String)QtTAG, (String)NoPermissionErrorMessage);
        }
        return l;
    }

    public static boolean checkFileExists(Context context, String string) {
        boolean bl = false;
        Uri uri = m_cachedUris.get(string);
        if (uri == null) {
            uri = QtNative.getUriWithValidPermission(context, string, "r");
        }
        if (uri == null) {
            Log.e((String)QtTAG, (String)NoPermissionErrorMessage);
            return bl;
        }
        if (!m_cachedUris.containsKey(string)) {
            m_cachedUris.put(string, uri);
        }
        try {
            ContentResolver contentResolver = context.getContentResolver();
            Cursor cursor = contentResolver.query(uri, null, null, null, null);
            if (cursor != null) {
                bl = true;
                cursor.close();
            }
            return bl;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.e((String)QtTAG, (String)"checkFileExists(): Invalid Uri");
            illegalArgumentException.printStackTrace();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Log.e((String)QtTAG, (String)"checkFileExists(): Unsupported operation for given Uri");
            unsupportedOperationException.printStackTrace();
        }
        catch (SecurityException securityException) {
            Log.e((String)QtTAG, (String)NoPermissionErrorMessage);
        }
        return bl;
    }

    public static boolean checkIfWritable(Context context, String string) {
        return QtNative.getUriWithValidPermission(context, string, "w") != null;
    }

    public static boolean checkIfDir(Context context, String string) {
        boolean bl = false;
        Uri uri = m_cachedUris.get(string);
        if (m_knownDirs.contains(string)) {
            return true;
        }
        if (uri == null) {
            uri = QtNative.getUriWithValidPermission(context, string, "r");
        }
        if (uri == null) {
            Log.e((String)QtTAG, (String)NoPermissionErrorMessage);
            return bl;
        }
        if (!m_cachedUris.containsKey(string)) {
            m_cachedUris.put(string, uri);
        }
        try {
            List list = uri.getPathSegments();
            if (!((String)list.get(0)).equals("tree")) {
                return false;
            }
            ContentResolver contentResolver = context.getContentResolver();
            Uri uri2 = DocumentsContract.buildDocumentUriUsingTree((Uri)uri, (String)DocumentsContract.getTreeDocumentId((Uri)uri));
            if (!uri2.toString().startsWith(uri.toString())) {
                return false;
            }
            Cursor cursor = contentResolver.query(uri2, new String[]{"mime_type"}, null, null, null);
            if (cursor != null) {
                if (cursor.moveToFirst()) {
                    String string2 = new String("vnd.android.document/directory");
                    bl = cursor.getString(0).equals(string2);
                    if (bl) {
                        m_knownDirs.add(string);
                    }
                }
                cursor.close();
            }
            return bl;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.e((String)QtTAG, (String)"checkIfDir(): Invalid Uri");
            illegalArgumentException.printStackTrace();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Log.e((String)QtTAG, (String)"checkIfDir(): Unsupported operation for given Uri");
            unsupportedOperationException.printStackTrace();
        }
        catch (SecurityException securityException) {
            Log.e((String)QtTAG, (String)NoPermissionErrorMessage);
        }
        return false;
    }

    public static String[] listContentsFromTreeUri(Context context, String string) {
        Uri uri = Uri.parse((String)string);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (uri == null) {
            Log.e((String)QtTAG, (String)"listContentsFromTreeUri(): Invalid uri");
            return arrayList.toArray(new String[arrayList.size()]);
        }
        ContentResolver contentResolver = context.getContentResolver();
        Uri uri2 = DocumentsContract.buildDocumentUriUsingTree((Uri)uri, (String)DocumentsContract.getTreeDocumentId((Uri)uri));
        Uri uri3 = DocumentsContract.buildChildDocumentsUriUsingTree((Uri)uri2, (String)DocumentsContract.getDocumentId((Uri)uri2));
        Cursor cursor = null;
        String string2 = new String("vnd.android.document/directory");
        try {
            cursor = contentResolver.query(uri3, new String[]{"document_id", "_display_name", "mime_type"}, null, null, null);
            while (cursor.moveToNext()) {
                String string3 = cursor.getString(1);
                if (!m_cachedUris.containsKey(string + "/" + string3)) {
                    m_cachedUris.put(string + "/" + string3, DocumentsContract.buildDocumentUriUsingTree((Uri)uri, (String)cursor.getString(0)));
                }
                arrayList.add(string3);
                if (!cursor.getString(2).equals(string2)) continue;
                m_knownDirs.add(string + "/" + string3);
            }
            cursor.close();
        }
        catch (Exception exception) {
            Log.w((String)QtTAG, (String)("Failed query: " + exception));
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static void loadQtLibraries(final ArrayList<String> arrayList) {
        m_qtThread.run(new Runnable(){

            @Override
            public void run() {
                if (arrayList == null) {
                    return;
                }
                for (String string : arrayList) {
                    try {
                        File file = new File(string);
                        if (file.exists()) {
                            System.load(string);
                            continue;
                        }
                        Log.i((String)QtNative.QtTAG, (String)("Can't find '" + string + "'"));
                    }
                    catch (SecurityException securityException) {
                        Log.i((String)QtNative.QtTAG, (String)("Can't load '" + string + "'"), (Throwable)securityException);
                    }
                    catch (Exception exception) {
                        Log.i((String)QtNative.QtTAG, (String)("Can't load '" + string + "'"), (Throwable)exception);
                    }
                }
            }
        });
    }

    public static void loadBundledLibraries(final ArrayList<String> arrayList, final String string) {
        m_qtThread.run(new Runnable(){

            @Override
            public void run() {
                if (arrayList == null) {
                    return;
                }
                for (String string4 : arrayList) {
                    try {
                        String string2 = "lib" + string4 + ".so";
                        File file = new File(string + string2);
                        if (!file.exists()) {
                            Log.i((String)QtNative.QtTAG, (String)("Can't find '" + file.getAbsolutePath()));
                            try {
                                ApplicationInfo applicationInfo = QtNative.getContext().getApplicationContext().getPackageManager().getApplicationInfo(QtNative.getContext().getPackageName(), 128);
                                String string3 = "/system/lib/";
                                if (applicationInfo.metaData.containsKey("android.app.system_libs_prefix")) {
                                    string3 = applicationInfo.metaData.getString("android.app.system_libs_prefix");
                                }
                                file = new File(string3 + string2);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        if (file.exists()) {
                            System.load(file.getAbsolutePath());
                            continue;
                        }
                        Log.i((String)QtNative.QtTAG, (String)("Can't find '" + file.getAbsolutePath()));
                    }
                    catch (Exception exception) {
                        Log.i((String)QtNative.QtTAG, (String)("Can't load '" + string4 + "'"), (Throwable)exception);
                    }
                }
            }
        });
    }

    public static String loadMainLibrary(final String string, final String string2) {
        final String[] stringArray = new String[]{null};
        m_qtThread.run(new Runnable(){

            @Override
            public void run() {
                try {
                    String string3 = "lib" + string + ".so";
                    File file = new File(string2 + string3);
                    if (!file.exists()) {
                        try {
                            ApplicationInfo applicationInfo = QtNative.getContext().getApplicationContext().getPackageManager().getApplicationInfo(QtNative.getContext().getPackageName(), 128);
                            String string22 = "/system/lib/";
                            if (applicationInfo.metaData.containsKey("android.app.system_libs_prefix")) {
                                string22 = applicationInfo.metaData.getString("android.app.system_libs_prefix");
                            }
                            file = new File(string22 + string3);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            return;
                        }
                    }
                    if (!file.exists()) {
                        return;
                    }
                    System.load(file.getAbsolutePath());
                    stringArray[0] = file.getAbsolutePath();
                }
                catch (Exception exception) {
                    Log.e((String)QtNative.QtTAG, (String)("Can't load '" + string + "'"), (Throwable)exception);
                }
            }
        });
        return stringArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setActivity(Activity activity, QtActivityDelegate qtActivityDelegate) {
        Object object = m_mainActivityMutex;
        synchronized (object) {
            m_activity = activity;
            m_activityDelegate = qtActivityDelegate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setService(Service service, QtServiceDelegate qtServiceDelegate) {
        Object object = m_mainActivityMutex;
        synchronized (object) {
            m_service = service;
            m_serviceDelegate = qtServiceDelegate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setApplicationState(int n) {
        Object object = m_mainActivityMutex;
        synchronized (object) {
            switch (n) {
                case 4: {
                    m_activityPaused = false;
                    Iterator<Runnable> iterator = m_lostActions.iterator();
                    while (iterator.hasNext()) {
                        QtNative.runAction(iterator.next());
                    }
                    m_lostActions.clear();
                    break;
                }
                default: {
                    m_activityPaused = true;
                }
            }
        }
        QtNative.updateApplicationState(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runAction(Runnable runnable) {
        Object object = m_mainActivityMutex;
        synchronized (object) {
            boolean bl;
            Looper looper = Looper.getMainLooper();
            Handler handler = new Handler(looper);
            boolean bl2 = bl = !m_activityPaused && m_activity != null && looper != null && handler.post(runnable);
            if (!bl) {
                m_lostActions.add(runnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runPendingCppRunnablesOnAndroidThread() {
        Object object = m_mainActivityMutex;
        synchronized (object) {
            if (m_activity != null) {
                if (!m_activityPaused) {
                    m_activity.runOnUiThread(runPendingCppRunnablesRunnable);
                } else {
                    QtNative.runAction(runPendingCppRunnablesRunnable);
                }
            } else {
                Looper looper = Looper.getMainLooper();
                Thread thread = looper.getThread();
                if (thread.equals(Thread.currentThread())) {
                    runPendingCppRunnablesRunnable.run();
                } else {
                    Handler handler = new Handler(looper);
                    handler.post(runPendingCppRunnablesRunnable);
                }
            }
        }
    }

    private static void setViewVisibility(final View view, final boolean bl) {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                view.setVisibility(bl ? 0 : 8);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean startApplication(String string, final String string2, String string3) throws Exception {
        if (string == null) {
            string = "-platform\tandroid";
        }
        final boolean[] blArray = new boolean[]{false};
        Object object = m_mainActivityMutex;
        synchronized (object) {
            if (string.length() > 0 && !string.startsWith("\t")) {
                string = "\t" + string;
            }
            final String string4 = string3 + string;
            m_qtThread.run(new Runnable(){

                @Override
                public void run() {
                    blArray[0] = QtNative.startQtAndroidPlugin(string4, string2);
                    QtNative.setDisplayMetrics(m_displayMetricsScreenWidthPixels, m_displayMetricsScreenHeightPixels, m_displayMetricsDesktopWidthPixels, m_displayMetricsDesktopHeightPixels, m_displayMetricsXDpi, m_displayMetricsYDpi, m_displayMetricsScaledDensity, m_displayMetricsDensity, m_displayMetricsRefreshRate);
                }
            });
            m_qtThread.post(new Runnable(){

                @Override
                public void run() {
                    QtNative.startQtApplication();
                }
            });
            QtNative.waitForServiceSetup();
            m_started = true;
        }
        return blArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setApplicationDisplayMetrics(int n, int n2, int n3, int n4, double d, double d2, double d3, double d4, float f) {
        if (d < 120.0) {
            d = 120.0;
        }
        if (d2 < 120.0) {
            d2 = 120.0;
        }
        Object object = m_mainActivityMutex;
        synchronized (object) {
            if (m_started) {
                QtNative.setDisplayMetrics(n, n2, n3, n4, d, d2, d3, d4, f);
            } else {
                m_displayMetricsScreenWidthPixels = n;
                m_displayMetricsScreenHeightPixels = n2;
                m_displayMetricsDesktopWidthPixels = n3;
                m_displayMetricsDesktopHeightPixels = n4;
                m_displayMetricsXDpi = d;
                m_displayMetricsYDpi = d2;
                m_displayMetricsScaledDensity = d3;
                m_displayMetricsDensity = d4;
                m_displayMetricsRefreshRate = f;
            }
        }
    }

    public static native boolean startQtAndroidPlugin(String var0, String var1);

    public static native void startQtApplication();

    public static native void waitForServiceSetup();

    public static native void quitQtCoreApplication();

    public static native void quitQtAndroidPlugin();

    public static native void terminateQt();

    private static void quitApp() {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                QtNative.quitQtAndroidPlugin();
                if (m_activity != null) {
                    m_activity.finish();
                }
                if (m_service != null) {
                    m_service.stopSelf();
                }
            }
        });
    }

    private static int getAction(int n, MotionEvent motionEvent) {
        int n2 = motionEvent.getActionMasked();
        if (n2 == 2) {
            int n3 = motionEvent.getHistorySize();
            if (n3 > 0) {
                float f = motionEvent.getX(n);
                float f2 = motionEvent.getY(n);
                for (int i = 0; i < n3; ++i) {
                    if (motionEvent.getHistoricalX(n, i) == f && motionEvent.getHistoricalY(n, i) == f2) continue;
                    return 1;
                }
                return 2;
            }
            return 1;
        }
        if (n2 == 0 || n2 == 5 && n == motionEvent.getActionIndex()) {
            return 0;
        }
        if (n2 == 1 || n2 == 6 && n == motionEvent.getActionIndex()) {
            return 3;
        }
        return 2;
    }

    public static void sendTouchEvent(MotionEvent motionEvent, int n) {
        int n2 = 0;
        if (m_tabletEventSupported == null) {
            m_tabletEventSupported = QtNative.isTabletEventSupported();
        }
        switch (motionEvent.getToolType(0)) {
            case 2: {
                n2 = 1;
                break;
            }
            case 4: {
                n2 = 3;
            }
        }
        if (motionEvent.getToolType(0) == 3) {
            QtNative.sendMouseEvent(motionEvent, n);
        } else if (m_tabletEventSupported.booleanValue() && n2 != 0) {
            QtNative.tabletEvent(n, motionEvent.getDeviceId(), motionEvent.getEventTime(), motionEvent.getAction(), n2, motionEvent.getButtonState(), motionEvent.getX(), motionEvent.getY(), motionEvent.getPressure());
        } else {
            QtNative.touchBegin(n);
            for (int i = 0; i < motionEvent.getPointerCount(); ++i) {
                QtNative.touchAdd(n, motionEvent.getPointerId(i), QtNative.getAction(i, motionEvent), i == 0, (int)motionEvent.getX(i), (int)motionEvent.getY(i), motionEvent.getTouchMajor(i), motionEvent.getTouchMinor(i), motionEvent.getOrientation(i), motionEvent.getPressure(i));
            }
            switch (motionEvent.getAction()) {
                case 0: {
                    QtNative.touchEnd(n, 0);
                    break;
                }
                case 1: {
                    QtNative.touchEnd(n, 2);
                    break;
                }
                case 3: {
                    QtNative.touchCancel(n);
                    break;
                }
                default: {
                    QtNative.touchEnd(n, 1);
                }
            }
        }
    }

    public static void sendTrackballEvent(MotionEvent motionEvent, int n) {
        QtNative.sendMouseEvent(motionEvent, n);
    }

    public static boolean sendGenericMotionEvent(MotionEvent motionEvent, int n) {
        if ((motionEvent.getAction() & 0xF) == 0 || (motionEvent.getSource() & 2) != 2) {
            return false;
        }
        return QtNative.sendMouseEvent(motionEvent, n);
    }

    public static boolean sendMouseEvent(MotionEvent motionEvent, int n) {
        switch (motionEvent.getActionMasked()) {
            case 1: {
                QtNative.mouseUp(n, (int)motionEvent.getX(), (int)motionEvent.getY());
                break;
            }
            case 0: {
                QtNative.mouseDown(n, (int)motionEvent.getX(), (int)motionEvent.getY());
                m_oldx = (int)motionEvent.getX();
                m_oldy = (int)motionEvent.getY();
                break;
            }
            case 2: 
            case 7: {
                if (motionEvent.getToolType(0) == 3) {
                    QtNative.mouseMove(n, (int)motionEvent.getX(), (int)motionEvent.getY());
                    break;
                }
                int n2 = (int)(motionEvent.getX() - (float)m_oldx);
                int n3 = (int)(motionEvent.getY() - (float)m_oldy);
                if (Math.abs(n2) <= 5 && Math.abs(n3) <= 5) break;
                QtNative.mouseMove(n, (int)motionEvent.getX(), (int)motionEvent.getY());
                m_oldx = (int)motionEvent.getX();
                m_oldy = (int)motionEvent.getY();
                break;
            }
            case 8: {
                QtNative.mouseWheel(n, (int)motionEvent.getX(), (int)motionEvent.getY(), motionEvent.getAxisValue(10), motionEvent.getAxisValue(9));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public static Context getContext() {
        if (m_activity != null) {
            return m_activity;
        }
        return m_service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int checkSelfPermission(String string) {
        int n = -1;
        Object object = m_mainActivityMutex;
        synchronized (object) {
            Context context = QtNative.getContext();
            try {
                if (Build.VERSION.SDK_INT >= 23) {
                    if (m_checkSelfPermissionMethod == null) {
                        m_checkSelfPermissionMethod = Context.class.getMethod("checkSelfPermission", String.class);
                    }
                    n = (Integer)m_checkSelfPermissionMethod.invoke((Object)context, string);
                } else {
                    PackageManager packageManager = context.getPackageManager();
                    n = packageManager.checkPermission(string, context.getApplicationContext().getPackageName());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n;
    }

    private static void updateSelection(final int n, final int n2, final int n3, final int n4) {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activityDelegate != null) {
                    m_activityDelegate.updateSelection(n, n2, n3, n4);
                }
            }
        });
    }

    private static void updateHandles(final int n, final int n2, final int n3, final int n4, final int n5, final int n6, final int n7, final int n8, final boolean bl) {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                m_activityDelegate.updateHandles(n, n2, n3, n4, n5, n6, n7, n8, bl);
            }
        });
    }

    private static void showSoftwareKeyboard(final int n, final int n2, final int n3, final int n4, final int n5, final int n6) {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activityDelegate != null) {
                    m_activityDelegate.showSoftwareKeyboard(n, n2, n3, n4, n5, n6);
                }
            }
        });
    }

    private static void resetSoftwareKeyboard() {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activityDelegate != null) {
                    m_activityDelegate.resetSoftwareKeyboard();
                }
            }
        });
    }

    private static void hideSoftwareKeyboard() {
        m_isKeyboardHiding = true;
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activityDelegate != null) {
                    m_activityDelegate.hideSoftwareKeyboard();
                }
            }
        });
    }

    private static void setFullScreen(final boolean bl) {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activityDelegate != null) {
                    m_activityDelegate.setFullScreen(bl);
                }
                QtNative.updateWindow();
            }
        });
    }

    public static boolean isSoftwareKeyboardVisible() {
        if (m_activityDelegate == null) {
            return false;
        }
        return m_activityDelegate.isKeyboardVisible() && !m_isKeyboardHiding;
    }

    private static void notifyAccessibilityLocationChange(final int n) {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activityDelegate != null) {
                    m_activityDelegate.notifyAccessibilityLocationChange(n);
                }
            }
        });
    }

    private static void notifyObjectHide(final int n, final int n2) {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activityDelegate != null) {
                    m_activityDelegate.notifyObjectHide(n, n2);
                }
            }
        });
    }

    private static void notifyObjectFocus(final int n) {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activityDelegate != null) {
                    m_activityDelegate.notifyObjectFocus(n);
                }
            }
        });
    }

    private static void notifyValueChanged(final int n, final String string) {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activityDelegate != null) {
                    m_activityDelegate.notifyValueChanged(n, string);
                }
            }
        });
    }

    public static void notifyQtAndroidPluginRunning(boolean bl) {
        m_activityDelegate.notifyQtAndroidPluginRunning(bl);
    }

    private static void registerClipboardManager() {
        if (m_service == null || m_activity != null) {
            final Semaphore semaphore = new Semaphore(0);
            QtNative.runAction(new Runnable(){

                @Override
                public void run() {
                    if (m_activity != null) {
                        m_clipboardManager = (ClipboardManager)m_activity.getSystemService("clipboard");
                    }
                    if (m_clipboardManager != null) {
                        m_clipboardManager.addPrimaryClipChangedListener(new ClipboardManager.OnPrimaryClipChangedListener(){

                            public void onPrimaryClipChanged() {
                                QtNative.onClipboardDataChanged();
                            }
                        });
                    }
                    semaphore.release();
                }
            });
            try {
                semaphore.acquire();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static void clearClipData() {
        if (Build.VERSION.SDK_INT >= 28 && m_clipboardManager != null) {
            m_clipboardManager.clearPrimaryClip();
        }
        m_usePrimaryClip = false;
    }

    private static void setClipboardText(String string) {
        if (m_clipboardManager != null) {
            ClipData clipData = ClipData.newPlainText((CharSequence)"text/plain", (CharSequence)string);
            QtNative.updatePrimaryClip(clipData);
        }
    }

    public static boolean hasClipboardText() {
        try {
            if (m_clipboardManager != null && m_clipboardManager.hasPrimaryClip()) {
                ClipDescription clipDescription = m_clipboardManager.getPrimaryClipDescription();
                return clipDescription.hasMimeType("text/*");
            }
        }
        catch (Exception exception) {
            Log.e((String)QtTAG, (String)"Failed to get clipboard data", (Throwable)exception);
        }
        return false;
    }

    private static String getClipboardText() {
        try {
            if (m_clipboardManager != null && m_clipboardManager.hasPrimaryClip()) {
                ClipData clipData = m_clipboardManager.getPrimaryClip();
                for (int i = 0; i < clipData.getItemCount(); ++i) {
                    if (clipData.getItemAt(i).getText() == null) continue;
                    return clipData.getItemAt(i).getText().toString();
                }
            }
        }
        catch (Exception exception) {
            Log.e((String)QtTAG, (String)"Failed to get clipboard data", (Throwable)exception);
        }
        return "";
    }

    private static void updatePrimaryClip(ClipData clipData) {
        try {
            if (m_usePrimaryClip) {
                ClipData clipData2 = m_clipboardManager.getPrimaryClip();
                if (Build.VERSION.SDK_INT >= 26) {
                    Objects.requireNonNull(clipData2).addItem(m_activity.getContentResolver(), clipData.getItemAt(0));
                } else {
                    Objects.requireNonNull(clipData2).addItem(clipData.getItemAt(0));
                }
                m_clipboardManager.setPrimaryClip(clipData2);
            } else {
                m_clipboardManager.setPrimaryClip(clipData);
                m_usePrimaryClip = true;
            }
        }
        catch (Exception exception) {
            Log.e((String)QtTAG, (String)"Failed to set clipboard data", (Throwable)exception);
        }
    }

    private static void setClipboardHtml(String string, String string2) {
        if (m_clipboardManager != null) {
            ClipData clipData = ClipData.newHtmlText((CharSequence)"text/html", (CharSequence)string, (String)string2);
            QtNative.updatePrimaryClip(clipData);
        }
    }

    public static boolean hasClipboardHtml() {
        try {
            if (m_clipboardManager != null && m_clipboardManager.hasPrimaryClip()) {
                ClipDescription clipDescription = m_clipboardManager.getPrimaryClipDescription();
                return clipDescription.hasMimeType("text/html");
            }
        }
        catch (Exception exception) {
            Log.e((String)QtTAG, (String)"Failed to get clipboard data", (Throwable)exception);
        }
        return false;
    }

    private static String getClipboardHtml() {
        try {
            if (m_clipboardManager != null && m_clipboardManager.hasPrimaryClip()) {
                ClipData clipData = m_clipboardManager.getPrimaryClip();
                for (int i = 0; i < clipData.getItemCount(); ++i) {
                    if (clipData.getItemAt(i).getHtmlText() == null) continue;
                    return clipData.getItemAt(i).getHtmlText().toString();
                }
            }
        }
        catch (Exception exception) {
            Log.e((String)QtTAG, (String)"Failed to get clipboard data", (Throwable)exception);
        }
        return "";
    }

    private static void setClipboardUri(String string) {
        if (m_clipboardManager != null) {
            ClipData clipData = ClipData.newUri((ContentResolver)m_activity.getContentResolver(), (CharSequence)"text/uri-list", (Uri)Uri.parse((String)string));
            QtNative.updatePrimaryClip(clipData);
        }
    }

    public static boolean hasClipboardUri() {
        try {
            if (m_clipboardManager != null && m_clipboardManager.hasPrimaryClip()) {
                ClipDescription clipDescription = m_clipboardManager.getPrimaryClipDescription();
                return clipDescription.hasMimeType("text/uri-list");
            }
        }
        catch (Exception exception) {
            Log.e((String)QtTAG, (String)"Failed to get clipboard data", (Throwable)exception);
        }
        return false;
    }

    private static String[] getClipboardUris() {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (m_clipboardManager != null && m_clipboardManager.hasPrimaryClip()) {
                stringArray = m_clipboardManager.getPrimaryClip();
                for (int i = 0; i < stringArray.getItemCount(); ++i) {
                    if (stringArray.getItemAt(i).getUri() == null) continue;
                    arrayList.add(stringArray.getItemAt(i).getUri().toString());
                }
            }
        }
        catch (Exception exception) {
            Log.e((String)QtTAG, (String)"Failed to get clipboard data", (Throwable)exception);
        }
        stringArray = new String[arrayList.size()];
        stringArray = (String[])arrayList.toArray(stringArray);
        return stringArray;
    }

    private static void openContextMenu(final int n, final int n2, final int n3, final int n4) {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activityDelegate != null) {
                    m_activityDelegate.openContextMenu(n, n2, n3, n4);
                }
            }
        });
    }

    private static void closeContextMenu() {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activityDelegate != null) {
                    m_activityDelegate.closeContextMenu();
                }
            }
        });
    }

    private static void resetOptionsMenu() {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activityDelegate != null) {
                    m_activityDelegate.resetOptionsMenu();
                }
            }
        });
    }

    private static void openOptionsMenu() {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activity != null) {
                    m_activity.openOptionsMenu();
                }
            }
        });
    }

    private static byte[][] getSSLCertificates() {
        Object object;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        try {
            object = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            ((TrustManagerFactory)object).init((KeyStore)null);
            for (TrustManager trustManager : ((TrustManagerFactory)object).getTrustManagers()) {
                if (!(trustManager instanceof X509TrustManager)) continue;
                X509TrustManager x509TrustManager = (X509TrustManager)trustManager;
                for (X509Certificate x509Certificate : x509TrustManager.getAcceptedIssuers()) {
                    byte[] byArray = x509Certificate.getEncoded();
                    arrayList.add(byArray);
                }
            }
        }
        catch (Exception exception) {
            Log.e((String)QtTAG, (String)"Failed to get certificates", (Throwable)exception);
        }
        object = new byte[arrayList.size()][];
        object = (byte[][])arrayList.toArray((T[])object);
        return object;
    }

    private static void createSurface(final int n, final boolean bl, final int n2, final int n3, final int n4, final int n5, final int n6) {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activityDelegate != null) {
                    m_activityDelegate.createSurface(n, bl, n2, n3, n4, n5, n6);
                }
            }
        });
    }

    private static void insertNativeView(final int n, final View view, final int n2, final int n3, final int n4, final int n5) {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activityDelegate != null) {
                    m_activityDelegate.insertNativeView(n, view, n2, n3, n4, n5);
                }
            }
        });
    }

    private static void setSurfaceGeometry(final int n, final int n2, final int n3, final int n4, final int n5) {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activityDelegate != null) {
                    m_activityDelegate.setSurfaceGeometry(n, n2, n3, n4, n5);
                }
            }
        });
    }

    private static void bringChildToFront(final int n) {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activityDelegate != null) {
                    m_activityDelegate.bringChildToFront(n);
                }
            }
        });
    }

    private static void bringChildToBack(final int n) {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activityDelegate != null) {
                    m_activityDelegate.bringChildToBack(n);
                }
            }
        });
    }

    private static void destroySurface(final int n) {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activityDelegate != null) {
                    m_activityDelegate.destroySurface(n);
                }
            }
        });
    }

    private static void initializeAccessibility() {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                m_activityDelegate.initializeAccessibility();
            }
        });
    }

    private static void hideSplashScreen(final int n) {
        QtNative.runAction(new Runnable(){

            @Override
            public void run() {
                if (m_activityDelegate != null) {
                    m_activityDelegate.hideSplashScreen(n);
                }
            }
        });
    }

    public static void keyboardVisibilityUpdated(boolean bl) {
        m_isKeyboardHiding = false;
        QtNative.keyboardVisibilityChanged(bl);
    }

    private static String[] listAssetContent(AssetManager assetManager, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String[] stringArray = assetManager.list(string);
            if (stringArray.length > 0) {
                for (String string2 : stringArray) {
                    try {
                        String[] stringArray2 = assetManager.list(string.length() > 0 ? string + "/" + string2 : string2);
                        if (stringArray2 != null && stringArray2.length > 0) {
                            string2 = string2 + "/";
                        }
                        arrayList.add(string2);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static native void setDisplayMetrics(int var0, int var1, int var2, int var3, double var4, double var6, double var8, double var10, float var12);

    public static native void handleOrientationChanged(int var0, int var1);

    public static native void handleRefreshRateChanged(float var0);

    public static native void mouseDown(int var0, int var1, int var2);

    public static native void mouseUp(int var0, int var1, int var2);

    public static native void mouseMove(int var0, int var1, int var2);

    public static native void mouseWheel(int var0, int var1, int var2, float var3, float var4);

    public static native void touchBegin(int var0);

    public static native void touchAdd(int var0, int var1, int var2, boolean var3, int var4, int var5, float var6, float var7, float var8, float var9);

    public static native void touchEnd(int var0, int var1);

    public static native void touchCancel(int var0);

    public static native void longPress(int var0, int var1, int var2);

    public static native boolean isTabletEventSupported();

    public static native void tabletEvent(int var0, int var1, long var2, int var4, int var5, int var6, float var7, float var8, float var9);

    public static native void keyDown(int var0, int var1, int var2, boolean var3);

    public static native void keyUp(int var0, int var1, int var2, boolean var3);

    public static native void keyboardVisibilityChanged(boolean var0);

    public static native void keyboardGeometryChanged(int var0, int var1, int var2, int var3);

    public static native void handleLocationChanged(int var0, int var1, int var2);

    public static native boolean dispatchGenericMotionEvent(MotionEvent var0);

    public static native boolean dispatchKeyEvent(KeyEvent var0);

    public static native void setSurface(int var0, Object var1, int var2, int var3);

    public static native void updateWindow();

    public static native void updateApplicationState(int var0);

    public static native boolean onPrepareOptionsMenu(Menu var0);

    public static native boolean onOptionsItemSelected(int var0, boolean var1);

    public static native void onOptionsMenuClosed(Menu var0);

    public static native void onCreateContextMenu(ContextMenu var0);

    public static native void fillContextMenu(Menu var0);

    public static native boolean onContextItemSelected(int var0, boolean var1);

    public static native void onContextMenuClosed(Menu var0);

    public static native void onClipboardDataChanged();

    public static native void onActivityResult(int var0, int var1, Intent var2);

    public static native void onNewIntent(Intent var0);

    public static native void runPendingCppRunnables();

    public static native void sendRequestPermissionsResult(int var0, String[] var1, int[] var2);

    private static native void setNativeActivity(Activity var0);

    private static native void setNativeService(Service var0);

    public static native IBinder onBind(Intent var0);

    static {
        m_clipboardManager = null;
        m_checkSelfPermissionMethod = null;
        m_tabletEventSupported = null;
        m_usePrimaryClip = false;
        m_qtThread = new QtThread();
        m_cachedUris = new HashMap();
        m_knownDirs = new ArrayList();
        runPendingCppRunnablesRunnable = new Runnable(){

            @Override
            public void run() {
                QtNative.runPendingCppRunnables();
            }
        };
        m_classLoader = null;
    }
}

