/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import org.qtproject.qt.android.QtNative;

public class QtLayout
extends ViewGroup {
    private Runnable m_startApplicationRunnable;

    public QtLayout(Context context, Runnable runnable) {
        super(context);
        this.m_startApplicationRunnable = runnable;
    }

    public QtLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public QtLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        WindowInsets windowInsets = this.getRootWindowInsets();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        Display display = Build.VERSION.SDK_INT < 30 ? ((Activity)this.getContext()).getWindowManager().getDefaultDisplay() : ((Activity)this.getContext()).getDisplay();
        display.getRealMetrics(displayMetrics);
        boolean bl = n2 == displayMetrics.heightPixels;
        int n5 = bl ? windowInsets.getSystemWindowInsetLeft() : 0;
        int n6 = bl ? windowInsets.getSystemWindowInsetTop() : 0;
        int n7 = bl ? windowInsets.getSystemWindowInsetRight() : 0;
        int n8 = bl ? windowInsets.getSystemWindowInsetBottom() : 0;
        int n9 = n - n5 - n7;
        int n10 = n2 - n6 - n8;
        QtNative.setApplicationDisplayMetrics(displayMetrics.widthPixels, displayMetrics.heightPixels, n5, n6, n9, n10, displayMetrics.xdpi, displayMetrics.ydpi, displayMetrics.scaledDensity, displayMetrics.density, display.getRefreshRate());
        if (this.m_startApplicationRunnable != null) {
            this.m_startApplicationRunnable.run();
            this.m_startApplicationRunnable = null;
        }
    }

    protected void onMeasure(int n, int n2) {
        int n3 = this.getChildCount();
        int n4 = 0;
        int n5 = 0;
        this.measureChildren(n, n2);
        for (int i = 0; i < n3; ++i) {
            View view = this.getChildAt(i);
            if (view.getVisibility() == 8) continue;
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            int n6 = layoutParams.x + view.getMeasuredWidth();
            int n7 = layoutParams.y + view.getMeasuredHeight();
            n5 = Math.max(n5, n6);
            n4 = Math.max(n4, n7);
        }
        n4 = Math.max(n4, this.getSuggestedMinimumHeight());
        n5 = Math.max(n5, this.getSuggestedMinimumWidth());
        this.setMeasuredDimension(QtLayout.resolveSize((int)n5, (int)n), QtLayout.resolveSize((int)n4, (int)n2));
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2, 0, 0);
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        int n5 = this.getChildCount();
        for (int i = 0; i < n5; ++i) {
            View view = this.getChildAt(i);
            if (view.getVisibility() == 8) continue;
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            int n6 = layoutParams.x;
            int n7 = layoutParams.y;
            view.layout(n6, n7, n6 + view.getMeasuredWidth(), n7 + view.getMeasuredHeight());
        }
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new LayoutParams(layoutParams);
    }

    public void moveChild(View view, int n) {
        if (view == null) {
            return;
        }
        if (this.indexOfChild(view) == -1) {
            return;
        }
        this.detachViewFromParent(view);
        this.requestLayout();
        this.invalidate();
        this.attachViewToParent(view, n, view.getLayoutParams());
    }

    public void setLayoutParams(View view, ViewGroup.LayoutParams layoutParams, boolean bl) {
        boolean bl2;
        if (view == null) {
            return;
        }
        if (!this.checkLayoutParams(layoutParams)) {
            return;
        }
        boolean bl3 = bl2 = this == view.getParent();
        if (bl2) {
            view.setLayoutParams(layoutParams);
            if (bl) {
                this.invalidate();
            }
        } else {
            this.addView(view, layoutParams);
        }
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        public int x;
        public int y;

        public LayoutParams(int n, int n2, int n3, int n4) {
            super(n, n2);
            this.x = n3;
            this.y = n4;
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }
    }
}

