/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android.networkinformation;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkRequest;
import android.os.Build;

public class QtAndroidNetworkInformation {
    private static final String LOG_TAG = "QtAndroidNetworkInformation";
    private static QtNetworkInformationCallback m_callback = null;
    private static final Object m_lock = new Object();

    private static native void connectivityChanged();

    private static native void behindCaptivePortalChanged(boolean var0);

    private QtAndroidNetworkInformation() {
    }

    public static AndroidConnectivity state() {
        if (m_callback != null && QtAndroidNetworkInformation.m_callback.previousState != null) {
            return QtAndroidNetworkInformation.m_callback.previousState;
        }
        return AndroidConnectivity.Unknown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"MissingPermission"})
    public static void registerReceiver(Context context) {
        Object object = m_lock;
        synchronized (object) {
            if (m_callback == null) {
                ConnectivityManager connectivityManager = QtAndroidNetworkInformation.getConnectivityManager(context);
                m_callback = new QtNetworkInformationCallback();
                NetworkRequest.Builder builder = new NetworkRequest.Builder();
                builder = builder.addCapability(12);
                if (Build.VERSION.SDK_INT >= 28) {
                    builder = builder.addCapability(19);
                }
                NetworkRequest networkRequest = builder.build();
                connectivityManager.registerNetworkCallback(networkRequest, (ConnectivityManager.NetworkCallback)m_callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterReceiver(Context context) {
        Object object = m_lock;
        synchronized (object) {
            if (m_callback != null) {
                QtAndroidNetworkInformation.getConnectivityManager(context).unregisterNetworkCallback((ConnectivityManager.NetworkCallback)m_callback);
                m_callback = null;
            }
        }
    }

    public static ConnectivityManager getConnectivityManager(Context context) {
        return (ConnectivityManager)context.getSystemService("connectivity");
    }

    private static class QtNetworkInformationCallback
    extends ConnectivityManager.NetworkCallback {
        public AndroidConnectivity previousState = null;

        QtNetworkInformationCallback() {
        }

        public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
            AndroidConnectivity androidConnectivity = !networkCapabilities.hasCapability(12) ? AndroidConnectivity.Disconnected : (networkCapabilities.hasCapability(16) ? AndroidConnectivity.Connected : AndroidConnectivity.Unknown);
            this.setState(androidConnectivity);
            boolean bl = networkCapabilities.hasCapability(17);
            QtAndroidNetworkInformation.behindCaptivePortalChanged(bl);
        }

        private void setState(AndroidConnectivity androidConnectivity) {
            if (this.previousState != androidConnectivity) {
                this.previousState = androidConnectivity;
                QtAndroidNetworkInformation.connectivityChanged();
            }
        }

        public void onLost(Network network) {
            this.setState(AndroidConnectivity.Disconnected);
        }
    }

    static enum AndroidConnectivity {
        Connected,
        Unknown,
        Disconnected;

    }
}

