import CheckConfigResponseInfo, { ICheckConfigResponseInfo } from './CheckConfigResponseInfo';
import CheckConfigStaticIpInfo, { ICheckConfigStaticIpInfo } from './CheckConfigStaticIpInfo';

// This file was autogenerated. Please do not change.
// All changes will be overwrited on commit.
export interface ICheckConfigResponse {
    dns: ICheckConfigResponseInfo;
    static_ip: ICheckConfigStaticIpInfo;
    web: ICheckConfigResponseInfo;
}

export default class CheckConfigResponse {
    readonly _dns: CheckConfigResponseInfo;

    get dns(): CheckConfigResponseInfo {
        return this._dns;
    }

    readonly _static_ip: CheckConfigStaticIpInfo;

    get staticIp(): CheckConfigStaticIpInfo {
        return this._static_ip;
    }

    readonly _web: CheckConfigResponseInfo;

    get web(): CheckConfigResponseInfo {
        return this._web;
    }

    constructor(props: ICheckConfigResponse) {
        this._dns = new CheckConfigResponseInfo(props.dns);
        this._static_ip = new CheckConfigStaticIpInfo(props.static_ip);
        this._web = new CheckConfigResponseInfo(props.web);
    }

    serialize(): ICheckConfigResponse {
        const data: ICheckConfigResponse = {
            dns: this._dns.serialize(),
            static_ip: this._static_ip.serialize(),
            web: this._web.serialize(),
        };
        return data;
    }

    validate(): string[] {
        const validate = {
            dns: this._dns.validate().length === 0,
            web: this._web.validate().length === 0,
            static_ip: this._static_ip.validate().length === 0,
        };
        const isError: string[] = [];
        Object.keys(validate).forEach((key) => {
            if (!(validate as any)[key]) {
                isError.push(key);
            }
        });
        return isError;
    }

    update(props: Partial<ICheckConfigResponse>): CheckConfigResponse {
        return new CheckConfigResponse({ ...this.serialize(), ...props });
    }
}
