// This file was autogenerated. Please do not change.
// All changes will be overwrited on commit.
export interface ITlsConfig {
    certificate_chain?: string;
    certificate_path?: string;
    dns_names?: string[];
    enabled?: boolean;
    force_https?: boolean;
    issuer?: string;
    key_type?: string;
    not_after?: string;
    not_before?: string;
    port_dns_over_quic?: number;
    port_dns_over_tls?: number;
    port_https?: number;
    private_key?: string;
    private_key_path?: string;
    server_name?: string;
    subject?: string;
    valid_cert?: boolean;
    valid_chain?: boolean;
    valid_key?: boolean;
    valid_pair?: boolean;
    warning_validation?: string;
}

export default class TlsConfig {
    readonly _certificate_chain: string | undefined;

    /** */
    get certificateChain(): string | undefined {
        return this._certificate_chain;
    }

    readonly _certificate_path: string | undefined;

    /** */
    get certificatePath(): string | undefined {
        return this._certificate_path;
    }

    readonly _dns_names: string[] | undefined;

    /**
     * Description: The value of SubjectAltNames field of the first certificate in the chain.
     *
     * Example: *.example.org
     */
    get dnsNames(): string[] | undefined {
        return this._dns_names;
    }

    readonly _enabled: boolean | undefined;

    /**
     * Description: enabled is the encryption (DOT/DOH/HTTPS) status
     * Example: true
     */
    get enabled(): boolean | undefined {
        return this._enabled;
    }

    readonly _force_https: boolean | undefined;

    /**
     * Description: if true, forces HTTP->HTTPS redirect
     * Example: true
     */
    get forceHttps(): boolean | undefined {
        return this._force_https;
    }

    readonly _issuer: string | undefined;

    /**
     * Description: The issuer of the first certificate in the chain.
     * Example: CN=Let's Encrypt Authority X3,O=Let's Encrypt,C=US
     */
    get issuer(): string | undefined {
        return this._issuer;
    }

    readonly _key_type: string | undefined;

    /**
     * Description: Key type.
     * Example: RSA
     */
    get keyType(): string | undefined {
        return this._key_type;
    }

    readonly _not_after: string | undefined;

    /**
     * Description: The NotAfter field of the first certificate in the chain.
     *
     * Example: 2019-05-01T10:47:32Z
     */
    get notAfter(): string | undefined {
        return this._not_after;
    }

    readonly _not_before: string | undefined;

    /**
     * Description: The NotBefore field of the first certificate in the chain.
     *
     * Example: 2019-01-31T10:47:32Z
     */
    get notBefore(): string | undefined {
        return this._not_before;
    }

    readonly _port_dns_over_quic: number | undefined;

    /**
     * Description: DNS-over-QUIC port. If 0, DOQ will be disabled.
     * Example: 784
     */
    get portDnsOverQuic(): number | undefined {
        return this._port_dns_over_quic;
    }

    readonly _port_dns_over_tls: number | undefined;

    /**
     * Description: DNS-over-TLS port. If 0, DOT will be disabled.
     * Example: 853
     */
    get portDnsOverTls(): number | undefined {
        return this._port_dns_over_tls;
    }

    readonly _port_https: number | undefined;

    /**
     * Description: HTTPS port. If 0, HTTPS will be disabled.
     * Example: 443
     */
    get portHttps(): number | undefined {
        return this._port_https;
    }

    readonly _private_key: string | undefined;

    /** */
    get privateKey(): string | undefined {
        return this._private_key;
    }

    readonly _private_key_path: string | undefined;

    /** */
    get privateKeyPath(): string | undefined {
        return this._private_key_path;
    }

    readonly _server_name: string | undefined;

    /**
     * Description: server_name is the hostname of your HTTPS/TLS server
     * Example: example.org
     */
    get serverName(): string | undefined {
        return this._server_name;
    }

    readonly _subject: string | undefined;

    /**
     * Description: The subject of the first certificate in the chain.
     * Example: CN=example.org
     */
    get subject(): string | undefined {
        return this._subject;
    }

    readonly _valid_cert: boolean | undefined;

    /**
     * Description: Set to true if the specified certificates chain is a valid chain of X509 certificates.
     *
     * Example: true
     */
    get validCert(): boolean | undefined {
        return this._valid_cert;
    }

    readonly _valid_chain: boolean | undefined;

    /**
     * Description: Set to true if the specified certificates chain is verified and issued by a known CA.
     *
     * Example: true
     */
    get validChain(): boolean | undefined {
        return this._valid_chain;
    }

    readonly _valid_key: boolean | undefined;

    /**
     * Description: Set to true if the key is a valid private key.
     * Example: true
     */
    get validKey(): boolean | undefined {
        return this._valid_key;
    }

    readonly _valid_pair: boolean | undefined;

    /**
     * Description: Set to true if both certificate and private key are correct.
     *
     * Example: true
     */
    get validPair(): boolean | undefined {
        return this._valid_pair;
    }

    readonly _warning_validation: string | undefined;

    /**
     * Description: A validation warning message with the issue description.
     *
     * Example: You have specified an empty certificate
     */
    get warningValidation(): string | undefined {
        return this._warning_validation;
    }

    constructor(props: ITlsConfig) {
        if (typeof props.certificate_chain === 'string') {
            this._certificate_chain = props.certificate_chain.trim();
        }
        if (typeof props.certificate_path === 'string') {
            this._certificate_path = props.certificate_path.trim();
        }
        if (props.dns_names) {
            this._dns_names = props.dns_names;
        }
        if (typeof props.enabled === 'boolean') {
            this._enabled = props.enabled;
        }
        if (typeof props.force_https === 'boolean') {
            this._force_https = props.force_https;
        }
        if (typeof props.issuer === 'string') {
            this._issuer = props.issuer.trim();
        }
        if (typeof props.key_type === 'string') {
            this._key_type = props.key_type.trim();
        }
        if (typeof props.not_after === 'string') {
            this._not_after = props.not_after.trim();
        }
        if (typeof props.not_before === 'string') {
            this._not_before = props.not_before.trim();
        }
        if (typeof props.port_dns_over_quic === 'number') {
            this._port_dns_over_quic = props.port_dns_over_quic;
        }
        if (typeof props.port_dns_over_tls === 'number') {
            this._port_dns_over_tls = props.port_dns_over_tls;
        }
        if (typeof props.port_https === 'number') {
            this._port_https = props.port_https;
        }
        if (typeof props.private_key === 'string') {
            this._private_key = props.private_key.trim();
        }
        if (typeof props.private_key_path === 'string') {
            this._private_key_path = props.private_key_path.trim();
        }
        if (typeof props.server_name === 'string') {
            this._server_name = props.server_name.trim();
        }
        if (typeof props.subject === 'string') {
            this._subject = props.subject.trim();
        }
        if (typeof props.valid_cert === 'boolean') {
            this._valid_cert = props.valid_cert;
        }
        if (typeof props.valid_chain === 'boolean') {
            this._valid_chain = props.valid_chain;
        }
        if (typeof props.valid_key === 'boolean') {
            this._valid_key = props.valid_key;
        }
        if (typeof props.valid_pair === 'boolean') {
            this._valid_pair = props.valid_pair;
        }
        if (typeof props.warning_validation === 'string') {
            this._warning_validation = props.warning_validation.trim();
        }
    }

    serialize(): ITlsConfig {
        const data: ITlsConfig = {
        };
        if (typeof this._certificate_chain !== 'undefined') {
            data.certificate_chain = this._certificate_chain;
        }
        if (typeof this._certificate_path !== 'undefined') {
            data.certificate_path = this._certificate_path;
        }
        if (typeof this._dns_names !== 'undefined') {
            data.dns_names = this._dns_names;
        }
        if (typeof this._enabled !== 'undefined') {
            data.enabled = this._enabled;
        }
        if (typeof this._force_https !== 'undefined') {
            data.force_https = this._force_https;
        }
        if (typeof this._issuer !== 'undefined') {
            data.issuer = this._issuer;
        }
        if (typeof this._key_type !== 'undefined') {
            data.key_type = this._key_type;
        }
        if (typeof this._not_after !== 'undefined') {
            data.not_after = this._not_after;
        }
        if (typeof this._not_before !== 'undefined') {
            data.not_before = this._not_before;
        }
        if (typeof this._port_dns_over_quic !== 'undefined') {
            data.port_dns_over_quic = this._port_dns_over_quic;
        }
        if (typeof this._port_dns_over_tls !== 'undefined') {
            data.port_dns_over_tls = this._port_dns_over_tls;
        }
        if (typeof this._port_https !== 'undefined') {
            data.port_https = this._port_https;
        }
        if (typeof this._private_key !== 'undefined') {
            data.private_key = this._private_key;
        }
        if (typeof this._private_key_path !== 'undefined') {
            data.private_key_path = this._private_key_path;
        }
        if (typeof this._server_name !== 'undefined') {
            data.server_name = this._server_name;
        }
        if (typeof this._subject !== 'undefined') {
            data.subject = this._subject;
        }
        if (typeof this._valid_cert !== 'undefined') {
            data.valid_cert = this._valid_cert;
        }
        if (typeof this._valid_chain !== 'undefined') {
            data.valid_chain = this._valid_chain;
        }
        if (typeof this._valid_key !== 'undefined') {
            data.valid_key = this._valid_key;
        }
        if (typeof this._valid_pair !== 'undefined') {
            data.valid_pair = this._valid_pair;
        }
        if (typeof this._warning_validation !== 'undefined') {
            data.warning_validation = this._warning_validation;
        }
        return data;
    }

    validate(): string[] {
        const validate = {
            enabled: !this._enabled ? true : typeof this._enabled === 'boolean',
            server_name: !this._server_name ? true : typeof this._server_name === 'string' && !this._server_name ? true : this._server_name,
            force_https: !this._force_https ? true : typeof this._force_https === 'boolean',
            port_https: !this._port_https ? true : typeof this._port_https === 'number',
            port_dns_over_tls: !this._port_dns_over_tls ? true : typeof this._port_dns_over_tls === 'number',
            port_dns_over_quic: !this._port_dns_over_quic ? true : typeof this._port_dns_over_quic === 'number',
            certificate_chain: !this._certificate_chain ? true : typeof this._certificate_chain === 'string' && !this._certificate_chain ? true : this._certificate_chain,
            private_key: !this._private_key ? true : typeof this._private_key === 'string' && !this._private_key ? true : this._private_key,
            certificate_path: !this._certificate_path ? true : typeof this._certificate_path === 'string' && !this._certificate_path ? true : this._certificate_path,
            private_key_path: !this._private_key_path ? true : typeof this._private_key_path === 'string' && !this._private_key_path ? true : this._private_key_path,
            valid_cert: !this._valid_cert ? true : typeof this._valid_cert === 'boolean',
            valid_chain: !this._valid_chain ? true : typeof this._valid_chain === 'boolean',
            subject: !this._subject ? true : typeof this._subject === 'string' && !this._subject ? true : this._subject,
            issuer: !this._issuer ? true : typeof this._issuer === 'string' && !this._issuer ? true : this._issuer,
            not_before: !this._not_before ? true : typeof this._not_before === 'string' && !this._not_before ? true : this._not_before,
            not_after: !this._not_after ? true : typeof this._not_after === 'string' && !this._not_after ? true : this._not_after,
            dns_names: !this._dns_names ? true : this._dns_names.reduce((result, p) => result && typeof p === 'string', true),
            valid_key: !this._valid_key ? true : typeof this._valid_key === 'boolean',
            key_type: !this._key_type ? true : typeof this._key_type === 'string' && !this._key_type ? true : this._key_type,
            warning_validation: !this._warning_validation ? true : typeof this._warning_validation === 'string' && !this._warning_validation ? true : this._warning_validation,
            valid_pair: !this._valid_pair ? true : typeof this._valid_pair === 'boolean',
        };
        const isError: string[] = [];
        Object.keys(validate).forEach((key) => {
            if (!(validate as any)[key]) {
                isError.push(key);
            }
        });
        return isError;
    }

    update(props: Partial<ITlsConfig>): TlsConfig {
        return new TlsConfig({ ...this.serialize(), ...props });
    }
}
