import DhcpConfigV4, { IDhcpConfigV4 } from './DhcpConfigV4';
import DhcpConfigV6, { IDhcpConfigV6 } from './DhcpConfigV6';

// This file was autogenerated. Please do not change.
// All changes will be overwrited on commit.
export interface IDhcpConfig {
    enabled?: boolean;
    interface_name?: string;
    v4?: IDhcpConfigV4;
    v6?: IDhcpConfigV6;
}

export default class DhcpConfig {
    readonly _enabled: boolean | undefined;

    get enabled(): boolean | undefined {
        return this._enabled;
    }

    readonly _interface_name: string | undefined;

    get interfaceName(): string | undefined {
        return this._interface_name;
    }

    readonly _v4: DhcpConfigV4 | undefined;

    get v4(): DhcpConfigV4 | undefined {
        return this._v4;
    }

    readonly _v6: DhcpConfigV6 | undefined;

    get v6(): DhcpConfigV6 | undefined {
        return this._v6;
    }

    constructor(props: IDhcpConfig) {
        if (typeof props.enabled === 'boolean') {
            this._enabled = props.enabled;
        }
        if (typeof props.interface_name === 'string') {
            this._interface_name = props.interface_name.trim();
        }
        if (props.v4) {
            this._v4 = new DhcpConfigV4(props.v4);
        }
        if (props.v6) {
            this._v6 = new DhcpConfigV6(props.v6);
        }
    }

    serialize(): IDhcpConfig {
        const data: IDhcpConfig = {
        };
        if (typeof this._enabled !== 'undefined') {
            data.enabled = this._enabled;
        }
        if (typeof this._interface_name !== 'undefined') {
            data.interface_name = this._interface_name;
        }
        if (typeof this._v4 !== 'undefined') {
            data.v4 = this._v4.serialize();
        }
        if (typeof this._v6 !== 'undefined') {
            data.v6 = this._v6.serialize();
        }
        return data;
    }

    validate(): string[] {
        const validate = {
            enabled: !this._enabled ? true : typeof this._enabled === 'boolean',
            interface_name: !this._interface_name ? true : typeof this._interface_name === 'string' && !this._interface_name ? true : this._interface_name,
            v4: !this._v4 ? true : this._v4.validate().length === 0,
            v6: !this._v6 ? true : this._v6.validate().length === 0,
        };
        const isError: string[] = [];
        Object.keys(validate).forEach((key) => {
            if (!(validate as any)[key]) {
                isError.push(key);
            }
        });
        return isError;
    }

    update(props: Partial<IDhcpConfig>): DhcpConfig {
        return new DhcpConfig({ ...this.serialize(), ...props });
    }
}
