// This file was autogenerated. Please do not change.
// All changes will be overwrited on commit.
export interface IVersionInfo {
    announcement?: string;
    announcement_url?: string;
    can_autoupdate?: boolean;
    disabled: boolean;
    new_version?: string;
}

export default class VersionInfo {
    readonly _announcement: string | undefined;

    /**
     * Description: undefined
     * Example: AdGuard Home v0.9 is now available!
     */
    get announcement(): string | undefined {
        return this._announcement;
    }

    readonly _announcement_url: string | undefined;

    /**
     * Description: undefined
     * Example: https://github.com/AdguardTeam/AdGuardHome/releases/tag/v0.9
     *
     */
    get announcementUrl(): string | undefined {
        return this._announcement_url;
    }

    readonly _can_autoupdate: boolean | undefined;

    get canAutoupdate(): boolean | undefined {
        return this._can_autoupdate;
    }

    readonly _disabled: boolean;

    /** */
    get disabled(): boolean {
        return this._disabled;
    }

    static disabledValidate(disabled: boolean): boolean {
        return typeof disabled === 'boolean';
    }

    readonly _new_version: string | undefined;

    /**
     * Description: undefined
     * Example: v0.9
     */
    get newVersion(): string | undefined {
        return this._new_version;
    }

    constructor(props: IVersionInfo) {
        if (typeof props.announcement === 'string') {
            this._announcement = props.announcement.trim();
        }
        if (typeof props.announcement_url === 'string') {
            this._announcement_url = props.announcement_url.trim();
        }
        if (typeof props.can_autoupdate === 'boolean') {
            this._can_autoupdate = props.can_autoupdate;
        }
        this._disabled = props.disabled;
        if (typeof props.new_version === 'string') {
            this._new_version = props.new_version.trim();
        }
    }

    serialize(): IVersionInfo {
        const data: IVersionInfo = {
            disabled: this._disabled,
        };
        if (typeof this._announcement !== 'undefined') {
            data.announcement = this._announcement;
        }
        if (typeof this._announcement_url !== 'undefined') {
            data.announcement_url = this._announcement_url;
        }
        if (typeof this._can_autoupdate !== 'undefined') {
            data.can_autoupdate = this._can_autoupdate;
        }
        if (typeof this._new_version !== 'undefined') {
            data.new_version = this._new_version;
        }
        return data;
    }

    validate(): string[] {
        const validate = {
            disabled: typeof this._disabled === 'boolean',
            new_version: !this._new_version ? true : typeof this._new_version === 'string' && !this._new_version ? true : this._new_version,
            announcement: !this._announcement ? true : typeof this._announcement === 'string' && !this._announcement ? true : this._announcement,
            announcement_url: !this._announcement_url ? true : typeof this._announcement_url === 'string' && !this._announcement_url ? true : this._announcement_url,
            can_autoupdate: !this._can_autoupdate ? true : typeof this._can_autoupdate === 'boolean',
        };
        const isError: string[] = [];
        Object.keys(validate).forEach((key) => {
            if (!(validate as any)[key]) {
                isError.push(key);
            }
        });
        return isError;
    }

    update(props: Partial<IVersionInfo>): VersionInfo {
        return new VersionInfo({ ...this.serialize(), ...props });
    }
}
