## How to contribute to Chan-SCCP

#### **Did you find a bug?**

* **Ensure the bug was not already reported** by searching on GitHub under [Issues](https://github.com/chan-sccp/chan-sccp/issues).

* If you're unable to find an open issue addressing the problem, [open a new one](https://github.com/chan-sccp/chan-sccp/issues/new). 
Be sure to include 
   * a **title and clear description**
   * as much relevant information as possible, like:
      * platform (cpu / 32/64 bit / endianness)
      * operating system + version
      * **asterisk version** (includeing revision if relevant)
      * **chan-sccp version** (including revision if relevant)
   * and a **code sample** or an **reproducable test case** demonstrating the expected behavior that is not occurring.
   * when refering to the mailinglist, please include the subject title and date of the first mail in that thread.
   
Note: How more information is provided upfront, the easier it is to get into the debugging phase. And the sooner the issue is resolved.

* If possible, use the relevant bug report templates to create the issue. Simply copy the content of the appropriate template into a .txt file, make the necessary changes to demonstrate the issue, and **paste the content into the issue description**:
  * [**Generic template** for issues](https://github.com/chan-sccp/chan-sccp/blob/master/.github/ISSUE_TEMPLATE.md)

* For more detailed information on submitting a bug report and creating an issue, visit our [reporting bugs guideline](https://github.com/chan-sccp/chan-sccp/wiki/Reporting%20Bugs).

#### **Did you write a patch that fixes a bug?**

* Open a new GitHub pull request with the patch.

* Ensure the Pull Request description clearly describes the problem and solution. Include the relevant issue number if applicable.

* Before submitting, please read the [Contributing to Chan-SCCP](https://github.com/chan-sccp/chan-sccp/wiki/Contributing) guide to know more about coding conventions and benchmarks.

BTW: Thanks for being a team player and helping out, this is really appreciated !

#### **Do you intend to add a new feature or change an existing one?**

* Suggest your change in the [chan-sccp mailing list](https://sourceforge.net/p/chan-sccp-b/mailman/chan-sccp-b-discussion/) and start writing code.

* Do not open an issue on GitHub until you have collected positive feedback about the change. GitHub issues are primarily intended for bug reports and fixes.

#### **Do you have questions about the source code?**

* Ask any question about how to use Chan-SCCP in the [chan-sccp mailing list](https://sourceforge.net/p/chan-sccp-b/mailman/chan-sccp-b-discussion/).

#### **Do you want to contribute to the Chan-SCCP WIKI documentation?**

* Open a new GitHub pull request with the patch against [wiki](https://github.com/chan-sccp/chan-sccp.wiki.git). We will review the change and post it as soon as possible.

</br>
Chan-SCCP is a volunteer effort. We encourage you to pitch in and [join the team](http://github.com/chan-sccp/)!

Thanks!

The Chan-SCCP Team
