/**
 * @packageDocumentation
 * @module mqtt5
 */
import * as mqtt from "mqtt";
import * as mqtt5 from "./mqtt5";
export declare const MAXIMUM_VARIABLE_LENGTH_INTEGER: number;
export declare const MAXIMUM_PACKET_SIZE: number;
export declare const DEFAULT_RECEIVE_MAXIMUM: number;
export declare const DEFAULT_CONNECT_TIMEOUT_MS: number;
export declare const DEFAULT_MIN_RECONNECT_DELAY_MS: number;
export declare const DEFAULT_MAX_RECONNECT_DELAY_MS: number;
export declare const DEFAULT_MIN_CONNECTED_TIME_TO_RESET_RECONNECT_DELAY_MS: number;
/** @internal */
export declare function transform_mqtt_js_connack_to_crt_connack(mqtt_js_connack: mqtt.IConnackPacket): mqtt5.ConnackPacket;
/** @internal */
export declare function create_negotiated_settings(config: mqtt5.Mqtt5ClientConfig, connack: mqtt5.ConnackPacket): mqtt5.NegotiatedSettings;
/** @internal */
export declare function getOrderedReconnectDelayBounds(configMin?: number, configMax?: number): [number, number];
/** @internal */
export declare function compute_mqtt_js_reconnect_delay_from_crt_max_delay(maxReconnectDelayMs: number): number;
/** @internal */
export declare function create_mqtt_js_client_config_from_crt_client_config(crtConfig: mqtt5.Mqtt5ClientConfig): mqtt.IClientOptions;
/** @internal */
export declare function transform_crt_user_properties_to_mqtt_js_user_properties(userProperties?: mqtt5.UserProperty[]): mqtt.UserProperties | undefined;
/** @internal */
export declare function transform_mqtt_js_user_properties_to_crt_user_properties(userProperties?: mqtt.UserProperties): mqtt5.UserProperty[] | undefined;
/** @internal */
export declare function transform_crt_disconnect_to_mqtt_js_disconnect(disconnect: mqtt5.DisconnectPacket): mqtt.IDisconnectPacket;
/** @internal **/
export declare function transform_mqtt_js_disconnect_to_crt_disconnect(disconnect: mqtt.IDisconnectPacket): mqtt5.DisconnectPacket;
/** @internal **/
export declare function transform_crt_subscribe_to_mqtt_js_subscription_map(subscribe: mqtt5.SubscribePacket): mqtt.ISubscriptionMap;
/** @internal **/
export declare function transform_crt_subscribe_to_mqtt_js_subscribe_options(subscribe: mqtt5.SubscribePacket): mqtt.IClientSubscribeOptions;
/** @internal **/
export declare function transform_mqtt_js_subscription_grants_to_crt_suback(subscriptionsGranted: mqtt.ISubscriptionGrant[]): mqtt5.SubackPacket;
/** @internal */
export declare function transform_crt_publish_to_mqtt_js_publish_options(publish: mqtt5.PublishPacket): mqtt.IClientPublishOptions;
/** @internal **/
export declare function transform_mqtt_js_publish_to_crt_publish(publish: mqtt.IPublishPacket): mqtt5.PublishPacket;
/** @internal **/
export declare function transform_mqtt_js_puback_to_crt_puback(puback: mqtt.IPubackPacket): mqtt5.PubackPacket;
/** @internal **/
export declare function transform_crt_unsubscribe_to_mqtt_js_unsubscribe_options(unsubscribe: mqtt5.UnsubscribePacket): Object;
/** @internal **/
export declare function transform_mqtt_js_unsuback_to_crt_unsuback(packet: mqtt.IUnsubackPacket): mqtt5.UnsubackPacket;
