"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.using = void 0;
/**
 * Use this function to create a resource in an async context. This will make sure the
 * resources are cleaned up before returning.
 *
 * Example:
 * ```
 * await using(res = new SomeResource(), async (res) =>  {
 *     res.do_the_thing();
 * });
 * ```
 *
 * @module aws-crt
 * @category System
 */
function using(resource, func) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            yield func(resource);
        }
        finally {
            resource.close();
        }
    });
}
exports.using = using;
//# sourceMappingURL=resource_safety.js.map