/*
 * Copyright 2010-2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

//node.js deps
var tls = require('tls');

//npm deps

//app deps

function buildBuilder(mqttClient, opts) {
   var connection;

   connection = tls.connect(opts);

   function handleTLSerrors(err) {
      mqttClient.emit('error', err);
      connection.end();
   }

   connection.on('secureConnect', function() {
      if (!connection.authorized) {
         connection.emit('error', new Error('TLS not authorized'));
      } else {
         connection.removeListener('error', handleTLSerrors);
      }
   });

   connection.on('error', handleTLSerrors);
   return connection;
}

module.exports = buildBuilder;
