"use strict";
/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var msRest = require("@azure/ms-rest-js");
var Mappers = require("../models/queryMappers");
var Parameters = require("../models/parameters");
/** Class representing a Query. */
var Query = /** @class */ (function () {
    /**
     * Create a Query.
     * @param {IotHubGatewayServiceAPIsContext} client Reference to the service client.
     */
    function Query(client) {
        this.client = client;
    }
    Query.prototype.getTwins = function (querySpecification, options, callback) {
        return this.client.sendOperationRequest({
            querySpecification: querySpecification,
            options: options
        }, getTwinsOperationSpec, callback);
    };
    return Query;
}());
exports.Query = Query;
// Operation Specifications
var serializer = new msRest.Serializer(Mappers);
var getTwinsOperationSpec = {
    httpMethod: "POST",
    path: "devices/query",
    queryParameters: [
        Parameters.apiVersion
    ],
    headerParameters: [
        Parameters.xMsContinuation,
        Parameters.xMsMaxItemCount
    ],
    requestBody: {
        parameterPath: "querySpecification",
        mapper: __assign(__assign({}, Mappers.QuerySpecification), { required: true })
    },
    responses: {
        200: {
            bodyMapper: {
                serializedName: "parsedResponse",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "Twin"
                        }
                    }
                }
            },
            headersMapper: Mappers.QueryGetTwinsHeaders
        },
        default: {}
    },
    serializer: serializer
};
//# sourceMappingURL=query.js.map