"use strict";
/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Jobs = void 0;
const msRest = require("@azure/ms-rest-js");
const Mappers = require("../models/jobsMappers");
const Parameters = require("../models/parameters");
/** Class representing a Jobs. */
class Jobs {
    /**
     * Create a Jobs.
     * @param {IotHubGatewayServiceAPIsContext} client Reference to the service client.
     */
    constructor(client) {
        this.client = client;
    }
    createImportExportJob(jobProperties, options, callback) {
        return this.client.sendOperationRequest({
            jobProperties,
            options
        }, createImportExportJobOperationSpec, callback);
    }
    getImportExportJobs(options, callback) {
        return this.client.sendOperationRequest({
            options
        }, getImportExportJobsOperationSpec, callback);
    }
    getImportExportJob(id, options, callback) {
        return this.client.sendOperationRequest({
            id,
            options
        }, getImportExportJobOperationSpec, callback);
    }
    cancelImportExportJob(id, options, callback) {
        return this.client.sendOperationRequest({
            id,
            options
        }, cancelImportExportJobOperationSpec, callback);
    }
    getScheduledJob(id, options, callback) {
        return this.client.sendOperationRequest({
            id,
            options
        }, getScheduledJobOperationSpec, callback);
    }
    createScheduledJob(id, jobRequest, options, callback) {
        return this.client.sendOperationRequest({
            id,
            jobRequest,
            options
        }, createScheduledJobOperationSpec, callback);
    }
    cancelScheduledJob(id, options, callback) {
        return this.client.sendOperationRequest({
            id,
            options
        }, cancelScheduledJobOperationSpec, callback);
    }
    queryScheduledJobs(options, callback) {
        return this.client.sendOperationRequest({
            options
        }, queryScheduledJobsOperationSpec, callback);
    }
}
exports.Jobs = Jobs;
// Operation Specifications
const serializer = new msRest.Serializer(Mappers);
const createImportExportJobOperationSpec = {
    httpMethod: "POST",
    path: "jobs/create",
    queryParameters: [
        Parameters.apiVersion
    ],
    requestBody: {
        parameterPath: "jobProperties",
        mapper: {
            ...Mappers.JobProperties,
            required: true
        }
    },
    responses: {
        200: {
            bodyMapper: Mappers.JobProperties
        },
        default: {}
    },
    serializer
};
const getImportExportJobsOperationSpec = {
    httpMethod: "GET",
    path: "jobs",
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: {
                serializedName: "parsedResponse",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "JobProperties"
                        }
                    }
                }
            }
        },
        default: {}
    },
    serializer
};
const getImportExportJobOperationSpec = {
    httpMethod: "GET",
    path: "jobs/{id}",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: Mappers.JobProperties
        },
        default: {}
    },
    serializer
};
const cancelImportExportJobOperationSpec = {
    httpMethod: "DELETE",
    path: "jobs/{id}",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: {
                serializedName: "parsedResponse",
                type: {
                    name: "Object"
                }
            }
        },
        204: {},
        default: {}
    },
    serializer
};
const getScheduledJobOperationSpec = {
    httpMethod: "GET",
    path: "jobs/v2/{id}",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: Mappers.JobResponse
        },
        default: {}
    },
    serializer
};
const createScheduledJobOperationSpec = {
    httpMethod: "PUT",
    path: "jobs/v2/{id}",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    requestBody: {
        parameterPath: "jobRequest",
        mapper: {
            ...Mappers.JobRequest,
            required: true
        }
    },
    responses: {
        200: {
            bodyMapper: Mappers.JobResponse
        },
        default: {}
    },
    serializer
};
const cancelScheduledJobOperationSpec = {
    httpMethod: "POST",
    path: "jobs/v2/{id}/cancel",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: Mappers.JobResponse
        },
        default: {}
    },
    serializer
};
const queryScheduledJobsOperationSpec = {
    httpMethod: "GET",
    path: "jobs/v2/query",
    queryParameters: [
        Parameters.jobType,
        Parameters.jobStatus,
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: Mappers.QueryResult
        },
        default: {}
    },
    serializer
};
//# sourceMappingURL=jobs.js.map