"use strict";
/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Modules = void 0;
const msRest = require("@azure/ms-rest-js");
const Mappers = require("../models/modulesMappers");
const Parameters = require("../models/parameters");
/** Class representing a Modules. */
class Modules {
    /**
     * Create a Modules.
     * @param {IotHubGatewayServiceAPIsContext} client Reference to the service client.
     */
    constructor(client) {
        this.client = client;
    }
    getTwin(id, mid, options, callback) {
        return this.client.sendOperationRequest({
            id,
            mid,
            options
        }, getTwinOperationSpec, callback);
    }
    replaceTwin(id, mid, deviceTwinInfo, options, callback) {
        return this.client.sendOperationRequest({
            id,
            mid,
            deviceTwinInfo,
            options
        }, replaceTwinOperationSpec, callback);
    }
    updateTwin(id, mid, deviceTwinInfo, options, callback) {
        return this.client.sendOperationRequest({
            id,
            mid,
            deviceTwinInfo,
            options
        }, updateTwinOperationSpec, callback);
    }
    getModulesOnDevice(id, options, callback) {
        return this.client.sendOperationRequest({
            id,
            options
        }, getModulesOnDeviceOperationSpec, callback);
    }
    getIdentity(id, mid, options, callback) {
        return this.client.sendOperationRequest({
            id,
            mid,
            options
        }, getIdentityOperationSpec, callback);
    }
    createOrUpdateIdentity(id, mid, module, options, callback) {
        return this.client.sendOperationRequest({
            id,
            mid,
            module,
            options
        }, createOrUpdateIdentityOperationSpec, callback);
    }
    deleteIdentity(id, mid, options, callback) {
        return this.client.sendOperationRequest({
            id,
            mid,
            options
        }, deleteIdentityOperationSpec, callback);
    }
    invokeMethod(deviceId, moduleId, directMethodRequest, options, callback) {
        return this.client.sendOperationRequest({
            deviceId,
            moduleId,
            directMethodRequest,
            options
        }, invokeMethodOperationSpec, callback);
    }
}
exports.Modules = Modules;
// Operation Specifications
const serializer = new msRest.Serializer(Mappers);
const getTwinOperationSpec = {
    httpMethod: "GET",
    path: "twins/{id}/modules/{mid}",
    urlParameters: [
        Parameters.id,
        Parameters.mid
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: Mappers.Twin
        },
        default: {}
    },
    serializer
};
const replaceTwinOperationSpec = {
    httpMethod: "PUT",
    path: "twins/{id}/modules/{mid}",
    urlParameters: [
        Parameters.id,
        Parameters.mid
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    headerParameters: [
        Parameters.ifMatch
    ],
    requestBody: {
        parameterPath: "deviceTwinInfo",
        mapper: {
            ...Mappers.Twin,
            required: true
        }
    },
    responses: {
        200: {
            bodyMapper: Mappers.Twin
        },
        default: {}
    },
    serializer
};
const updateTwinOperationSpec = {
    httpMethod: "PATCH",
    path: "twins/{id}/modules/{mid}",
    urlParameters: [
        Parameters.id,
        Parameters.mid
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    headerParameters: [
        Parameters.ifMatch
    ],
    requestBody: {
        parameterPath: "deviceTwinInfo",
        mapper: {
            ...Mappers.Twin,
            required: true
        }
    },
    responses: {
        200: {
            bodyMapper: Mappers.Twin
        },
        default: {}
    },
    serializer
};
const getModulesOnDeviceOperationSpec = {
    httpMethod: "GET",
    path: "devices/{id}/modules",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: {
                serializedName: "parsedResponse",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "Module"
                        }
                    }
                }
            }
        },
        default: {}
    },
    serializer
};
const getIdentityOperationSpec = {
    httpMethod: "GET",
    path: "devices/{id}/modules/{mid}",
    urlParameters: [
        Parameters.id,
        Parameters.mid
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: Mappers.Module
        },
        default: {}
    },
    serializer
};
const createOrUpdateIdentityOperationSpec = {
    httpMethod: "PUT",
    path: "devices/{id}/modules/{mid}",
    urlParameters: [
        Parameters.id,
        Parameters.mid
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    headerParameters: [
        Parameters.ifMatch
    ],
    requestBody: {
        parameterPath: "module",
        mapper: {
            ...Mappers.Module,
            required: true
        }
    },
    responses: {
        200: {
            bodyMapper: Mappers.Module
        },
        201: {
            bodyMapper: Mappers.Module
        },
        default: {}
    },
    serializer
};
const deleteIdentityOperationSpec = {
    httpMethod: "DELETE",
    path: "devices/{id}/modules/{mid}",
    urlParameters: [
        Parameters.id,
        Parameters.mid
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    headerParameters: [
        Parameters.ifMatch
    ],
    responses: {
        204: {},
        default: {}
    },
    serializer
};
const invokeMethodOperationSpec = {
    httpMethod: "POST",
    path: "twins/{deviceId}/modules/{moduleId}/methods",
    urlParameters: [
        Parameters.deviceId,
        Parameters.moduleId
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    requestBody: {
        parameterPath: "directMethodRequest",
        mapper: {
            ...Mappers.CloudToDeviceMethod,
            required: true
        }
    },
    responses: {
        200: {
            bodyMapper: Mappers.CloudToDeviceMethodResult
        },
        default: {}
    },
    serializer
};
//# sourceMappingURL=modules.js.map