"use strict";
/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Devices = void 0;
const msRest = require("@azure/ms-rest-js");
const Mappers = require("../models/devicesMappers");
const Parameters = require("../models/parameters");
/** Class representing a Devices. */
class Devices {
    /**
     * Create a Devices.
     * @param {IotHubGatewayServiceAPIsContext} client Reference to the service client.
     */
    constructor(client) {
        this.client = client;
    }
    getDevices(options, callback) {
        return this.client.sendOperationRequest({
            options
        }, getDevicesOperationSpec, callback);
    }
    getIdentity(id, options, callback) {
        return this.client.sendOperationRequest({
            id,
            options
        }, getIdentityOperationSpec, callback);
    }
    createOrUpdateIdentity(id, device, options, callback) {
        return this.client.sendOperationRequest({
            id,
            device,
            options
        }, createOrUpdateIdentityOperationSpec, callback);
    }
    deleteIdentity(id, options, callback) {
        return this.client.sendOperationRequest({
            id,
            options
        }, deleteIdentityOperationSpec, callback);
    }
    getTwin(id, options, callback) {
        return this.client.sendOperationRequest({
            id,
            options
        }, getTwinOperationSpec, callback);
    }
    replaceTwin(id, deviceTwinInfo, options, callback) {
        return this.client.sendOperationRequest({
            id,
            deviceTwinInfo,
            options
        }, replaceTwinOperationSpec, callback);
    }
    updateTwin(id, deviceTwinInfo, options, callback) {
        return this.client.sendOperationRequest({
            id,
            deviceTwinInfo,
            options
        }, updateTwinOperationSpec, callback);
    }
    invokeMethod(deviceId, directMethodRequest, options, callback) {
        return this.client.sendOperationRequest({
            deviceId,
            directMethodRequest,
            options
        }, invokeMethodOperationSpec, callback);
    }
}
exports.Devices = Devices;
// Operation Specifications
const serializer = new msRest.Serializer(Mappers);
const getDevicesOperationSpec = {
    httpMethod: "GET",
    path: "devices",
    queryParameters: [
        Parameters.top,
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: {
                serializedName: "parsedResponse",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "Device"
                        }
                    }
                }
            }
        },
        default: {}
    },
    serializer
};
const getIdentityOperationSpec = {
    httpMethod: "GET",
    path: "devices/{id}",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: Mappers.Device
        },
        default: {}
    },
    serializer
};
const createOrUpdateIdentityOperationSpec = {
    httpMethod: "PUT",
    path: "devices/{id}",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    headerParameters: [
        Parameters.ifMatch
    ],
    requestBody: {
        parameterPath: "device",
        mapper: {
            ...Mappers.Device,
            required: true
        }
    },
    responses: {
        200: {
            bodyMapper: Mappers.Device
        },
        default: {}
    },
    serializer
};
const deleteIdentityOperationSpec = {
    httpMethod: "DELETE",
    path: "devices/{id}",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    headerParameters: [
        Parameters.ifMatch
    ],
    responses: {
        204: {},
        default: {}
    },
    serializer
};
const getTwinOperationSpec = {
    httpMethod: "GET",
    path: "twins/{id}",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: Mappers.Twin
        },
        default: {}
    },
    serializer
};
const replaceTwinOperationSpec = {
    httpMethod: "PUT",
    path: "twins/{id}",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    headerParameters: [
        Parameters.ifMatch
    ],
    requestBody: {
        parameterPath: "deviceTwinInfo",
        mapper: {
            ...Mappers.Twin,
            required: true
        }
    },
    responses: {
        200: {
            bodyMapper: Mappers.Twin
        },
        default: {}
    },
    serializer
};
const updateTwinOperationSpec = {
    httpMethod: "PATCH",
    path: "twins/{id}",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    headerParameters: [
        Parameters.ifMatch
    ],
    requestBody: {
        parameterPath: "deviceTwinInfo",
        mapper: {
            ...Mappers.Twin,
            required: true
        }
    },
    responses: {
        200: {
            bodyMapper: Mappers.Twin
        },
        default: {}
    },
    serializer
};
const invokeMethodOperationSpec = {
    httpMethod: "POST",
    path: "twins/{deviceId}/methods",
    urlParameters: [
        Parameters.deviceId
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    requestBody: {
        parameterPath: "directMethodRequest",
        mapper: {
            ...Mappers.CloudToDeviceMethod,
            required: true
        }
    },
    responses: {
        200: {
            bodyMapper: Mappers.CloudToDeviceMethodResult
        },
        default: {}
    },
    serializer
};
//# sourceMappingURL=devices.js.map