/*! Copyright (c) Microsoft. All rights reserved.
 *! Licensed under the MIT license. See LICENSE file in the project root for full license information.
 */
'use strict';
Object.defineProperty(exports, "__esModule", { value: true });
exports.SharedAccessSignatureUpdated = exports.TransportConfigured = exports.Disconnected = exports.Connected = exports.MessageAbandoned = exports.MessageRejected = exports.MessageCompleted = exports.MessageEnqueued = void 0;
/**
 * Result returned when a message was successfully enqueued.
 */
class MessageEnqueued {
    /**
     * @private
     * @constructor
     * @param transportObj optional transport object to help with debugging.
     */
    constructor(transportObj) {
        this.transportObj = transportObj;
    }
}
exports.MessageEnqueued = MessageEnqueued;
/**
 * Result returned when a message was successfully rejected.
 */
class MessageCompleted {
    /**
     * @private
     * @constructor
     * @param transportObj optional transport object to help with debugging.
     */
    constructor(transportObj) {
        this.transportObj = transportObj;
    }
}
exports.MessageCompleted = MessageCompleted;
/**
 * Result returned when a message was successfully rejected.
 */
class MessageRejected {
    /**
     * @private
     * @constructor
     * @param transportObj optional transport object to help with debugging.
     */
    constructor(transportObj) {
        this.transportObj = transportObj;
    }
}
exports.MessageRejected = MessageRejected;
/**
 * Result returned when a message was successfully abandoned.
 */
class MessageAbandoned {
    /**
     * @private
     * @constructor
     * @param transportObj optional transport object to help with debugging.
     */
    constructor(transportObj) {
        this.transportObj = transportObj;
    }
}
exports.MessageAbandoned = MessageAbandoned;
/**
 * Result returned when a transport is successfully connected.
 */
class Connected {
    /**
     * @private
     * @constructor
     * @param transportObj optional transport object to help with debugging.
     */
    constructor(transportObj) {
        this.transportObj = transportObj;
    }
}
exports.Connected = Connected;
/**
 * Result returned when a transport is successfully disconnected.
 */
class Disconnected {
    /**
     * @private
     * @constructor
     * @param transportObj optional transport object to help with debugging.
     */
    constructor(transportObj, reason) {
        this.transportObj = transportObj;
        this.reason = reason;
    }
}
exports.Disconnected = Disconnected;
/**
 * Result returned when a transport is successfully configured.
 */
class TransportConfigured {
    /**
     * @private
     * @constructor
     * @param transportObj optional transport object to help with debugging.
     */
    constructor(transportObj) {
        this.transportObj = transportObj;
    }
}
exports.TransportConfigured = TransportConfigured;
/**
 * Result returned when a SAS token has been successfully updated.
 */
class SharedAccessSignatureUpdated {
    /**
     * @private
     * @constructor
     * @param transportObj optional transport object to help with debugging.
     */
    constructor(needToReconnect) {
        this.needToReconnect = needToReconnect;
    }
}
exports.SharedAccessSignatureUpdated = SharedAccessSignatureUpdated;
//# sourceMappingURL=results.js.map