Installing beep
===============

This document describes how to install `beep` from sources and how to
set up the system afterwards.

If you are using `beep` as shipped in a binary distribution package,
that package should have done most of those steps for you.  The one
notable exception should be the step adding users to the `beep` group.


Build requirements
==================

  * GNU make
  * clang or gcc
  * Linux kernel headers


Compile and Install
===================

The easy way is

```
[user@host beep]$ make
[user@host beep]$ make install
```

By default, `make install` will put the executable `beep` in
`/usr/local/bin`.  If you do not like this, set override the common
GNU Makefile convention variables (`prefix`, `bindir`, `docdir`,
`htmldir`, `mandir`, etc.) as appropriate, e.g.

```
[user@host beep]$ make prefix=$HOME/.local
[user@host beep]$ make prefix=$HOME/.local install
```

or

```
[user@host beep]$ cat>local.mk<<EOF
CC = clang
prefix = \$(HOME)/.local
EOF
[user@host beep]$ make
[user@host beep]$ make install
[user@host beep]$ make install-html
```

or

```
[user@host beep]$ make
[user@host beep]$ make DESTDIR=$PWD/__installroot install
```

For the complete list of those variables, see the top of
[`GNUmakefile`](GNUmakefile).

Some more compilation related variables mostly useful for distribution
packagers are documented in [`PACKAGING.md`](PACKAGING.md).


System configuration
====================

  * The Linux kernel driver `pcspkr` must be loaded to provide
    access to the PC speaker via the evdev and console APIs.

  * To have the system load the `pcspkr` kernel module by default
    during each system boot, add a line

        alias platform:pcspkr pcspkr

    to a modprobe config file, like
    e.g. `/etc/modprobe.d/pcspkr-beep.conf`.

  * To load the `pcspkr` kernel module right now without needing to
    boot, run

        modprobe pcspkr

    To unload the `pcspkr` driver again, run

        modprobe -r pcspkr

  * Set up the udev rules which set the device special file
    permissions for non-root users according to
    [`PERMISSIONS.md`](PERMISSIONS.md).

    You can test whether the permission setup work by unloading and
    then loading the `pcspkr` kernel module, as loading the module
    will cause all the udev rules to run.

  * On some systems with integrated speakers like e.g. laptops from
    the IBM/Lenovo Thinkpad series, there is no separate physical
    speaker for the PC speaker.

	Instead, the square wave sound generated by the PC speaker goes to
    the integrated speakers through a mixer chip, where it is mixed
    with PCM sound, CD drive audio, line in, microphone in, and other
    sources.

	On these systems, you might need to configure the mixer to make
    the PC speaker audible through the laptop speakers, e.g.

	  * Start alsamixer.
	  * Find the correct card (switch with the `F6` key).
	  * Maybe enable loopback.
	  * Unmute the appropriate PC speaker source (`m` key) and turn up
        its volume.
	  * Weirdly, a microphone volume below 0% apparently can also
        silence the PC speaker beeps.

    Some experimentation might be required.

    Of course, these mixer settings must be saved before the next
    system reboot so that the reboot can restore the mixer
    settings. Some systems save the mixer settings as part of their
    shutdown procedure, others may need you to save them explicitly.
