"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const TD = __importStar(require("@node-wot/td-tools"));
const core_1 = require("@node-wot/core");
const coap_1 = require("coap");
const slugify_1 = __importDefault(require("slugify"));
const stream_1 = require("stream");
class CoapServer {
    constructor(port, address) {
        this.scheme = "coap";
        this.PROPERTY_DIR = "properties";
        this.ACTION_DIR = "actions";
        this.EVENT_DIR = "events";
        this.port = 5683;
        this.address = undefined;
        this.server = (0, coap_1.createServer)({ reuseAddr: false }, (req, res) => {
            this.handleRequest(req, res);
        });
        this.things = new Map();
        if (port !== undefined) {
            this.port = port;
        }
        if (address !== undefined) {
            this.address = address;
        }
        (0, coap_1.registerFormat)(core_1.ContentSerdes.JSON_LD, 2100);
    }
    start(servient) {
        console.info("[binding-coap]", `CoapServer starting on ${this.address !== undefined ? this.address + " " : ""}port ${this.port}`);
        return new Promise((resolve, reject) => {
            this.server.once("error", (err) => {
                reject(err);
            });
            this.server.listen(this.port, this.address, () => {
                this.server.on("error", (err) => {
                    console.error("[binding-coap]", `CoapServer for port ${this.port} failed: ${err.message}`);
                });
                resolve();
            });
        });
    }
    stop() {
        console.info("[binding-coap]", `CoapServer stopping on port ${this.getPort()}`);
        return new Promise((resolve, reject) => {
            this.server.once("error", (err) => {
                reject(err);
            });
            this.server.close(() => {
                resolve();
            });
        });
    }
    getSocket() {
        return this.server._sock;
    }
    getPort() {
        if (this.server._sock) {
            const socket = this.server._sock;
            return socket.address().port;
        }
        else {
            return -1;
        }
    }
    expose(thing, tdTemplate) {
        let urlPath = (0, slugify_1.default)(thing.title, { lower: true });
        if (this.things.has(urlPath)) {
            urlPath = core_1.Helpers.generateUniqueName(urlPath);
        }
        console.debug("[binding-coap]", `CoapServer on port ${this.getPort()} exposes '${thing.title}' as unique '/${urlPath}'`);
        if (this.getPort() !== -1) {
            this.things.set(urlPath, thing);
            for (const address of core_1.Helpers.getAddresses()) {
                for (const type of core_1.ContentSerdes.get().getOfferedMediaTypes()) {
                    const base = this.scheme + "://" + address + ":" + this.getPort() + "/" + encodeURIComponent(urlPath);
                    for (const propertyName in thing.properties) {
                        const href = base + "/" + this.PROPERTY_DIR + "/" + encodeURIComponent(propertyName);
                        const form = new TD.Form(href, type);
                        core_1.ProtocolHelpers.updatePropertyFormWithTemplate(form, tdTemplate, propertyName);
                        if (thing.properties[propertyName].readOnly) {
                            form.op = ["readproperty"];
                        }
                        else if (thing.properties[propertyName].writeOnly) {
                            form.op = ["writeproperty"];
                        }
                        else {
                            form.op = ["readproperty", "writeproperty"];
                        }
                        if (thing.properties[propertyName].observable) {
                            if (!form.op) {
                                form.op = [];
                            }
                            form.op.push("observeproperty");
                            form.op.push("unobserveproperty");
                        }
                        thing.properties[propertyName].forms.push(form);
                        console.debug("[binding-coap]", `CoapServer on port ${this.getPort()} assigns '${href}' to Property '${propertyName}'`);
                    }
                    for (const actionName in thing.actions) {
                        const href = base + "/" + this.ACTION_DIR + "/" + encodeURIComponent(actionName);
                        const form = new TD.Form(href, type);
                        core_1.ProtocolHelpers.updateActionFormWithTemplate(form, tdTemplate, actionName);
                        form.op = "invokeaction";
                        thing.actions[actionName].forms.push(form);
                        console.debug("[binding-coap]", `CoapServer on port ${this.getPort()} assigns '${href}' to Action '${actionName}'`);
                    }
                    for (const eventName in thing.events) {
                        const href = base + "/" + this.EVENT_DIR + "/" + encodeURIComponent(eventName);
                        const form = new TD.Form(href, type);
                        core_1.ProtocolHelpers.updateEventFormWithTemplate(form, tdTemplate, eventName);
                        form.op = ["subscribeevent", "unsubscribeevent"];
                        thing.events[eventName].forms.push(form);
                        console.debug("[binding-coap]", `CoapServer on port ${this.getPort()} assigns '${href}' to Event '${eventName}'`);
                    }
                }
            }
        }
        return new Promise((resolve, reject) => {
            resolve();
        });
    }
    destroy(thingId) {
        console.debug("[binding-coap]", `CoapServer on port ${this.getPort()} destroying thingId '${thingId}'`);
        return new Promise((resolve, reject) => {
            let removedThing;
            for (const name of Array.from(this.things.keys())) {
                const expThing = this.things.get(name);
                if ((expThing === null || expThing === void 0 ? void 0 : expThing.id) === thingId) {
                    this.things.delete(name);
                    removedThing = expThing;
                }
            }
            if (removedThing) {
                console.info("[binding-coap]", `CoapServer succesfully destroyed '${removedThing.title}'`);
            }
            else {
                console.info("[binding-coap]", `CoapServer failed to destroy thing with thingId '${thingId}'`);
            }
            resolve(removedThing !== undefined);
        });
    }
    handleRequest(req, res) {
        return __awaiter(this, void 0, void 0, function* () {
            console.debug("[binding-coap]", `CoapServer on port ${this.getPort()} received '${req.method}(${req._packet.messageId}) ${req.url}' from ${core_1.Helpers.toUriLiteral(req.rsinfo.address)}:${req.rsinfo.port}`);
            res.on("finish", () => {
                console.debug("[binding-coap]", `CoapServer replied with '${res.code}' to ${core_1.Helpers.toUriLiteral(req.rsinfo.address)}:${req.rsinfo.port}`);
            });
            const requestUri = req.url;
            let contentType = req.headers["Content-Format"];
            if (req.method === "PUT" || req.method === "POST") {
                if (!contentType && req.payload) {
                    console.warn("[binding-coap]", `CoapServer on port ${this.getPort()} received no Content-Format from ${core_1.Helpers.toUriLiteral(req.rsinfo.address)}:${req.rsinfo.port}`);
                    contentType = core_1.ContentSerdes.DEFAULT;
                }
                else if (core_1.ContentSerdes.get().getSupportedMediaTypes().indexOf(core_1.ContentSerdes.getMediaType(contentType)) < 0) {
                    res.code = "4.15";
                    res.end("Unsupported Media Type");
                    return;
                }
            }
            let parsedRequestUri = requestUri;
            if (parsedRequestUri.indexOf("?") !== -1) {
                parsedRequestUri = parsedRequestUri.substring(0, parsedRequestUri.indexOf("?"));
            }
            const segments = decodeURI(parsedRequestUri).split("/");
            if (segments[1] === "") {
                if (req.method === "GET") {
                    res.setHeader("Content-Format", core_1.ContentSerdes.DEFAULT);
                    res.code = "2.05";
                    const list = [];
                    for (const address of core_1.Helpers.getAddresses()) {
                        for (const name of Array.from(this.things.keys())) {
                            list.push(this.scheme +
                                "://" +
                                core_1.Helpers.toUriLiteral(address) +
                                ":" +
                                this.getPort() +
                                "/" +
                                encodeURIComponent(name));
                        }
                    }
                    res.end(JSON.stringify(list));
                }
                else {
                    res.code = "4.05";
                    res.end("Method Not Allowed");
                }
                return;
            }
            else {
                const thing = this.things.get(segments[1]);
                if (thing) {
                    if (segments.length === 2 || segments[2] === "") {
                        if (req.method === "GET") {
                            res.setOption("Content-Format", core_1.ContentSerdes.TD);
                            res.code = "2.05";
                            res.end(JSON.stringify(thing.getThingDescription()));
                        }
                        else {
                            res.code = "4.05";
                            res.end("Method Not Allowed");
                        }
                        return;
                    }
                    else if (segments[2] === this.PROPERTY_DIR) {
                        const property = thing.properties[segments[3]];
                        if (property) {
                            if (req.method === "GET") {
                                if (req.headers.Observe === undefined) {
                                    try {
                                        const options = {
                                            formIndex: core_1.ProtocolHelpers.findRequestMatchingFormIndex(property.forms, this.scheme, req.url, contentType),
                                        };
                                        const uriVariables = core_1.Helpers.parseUrlParameters(req.url, thing.uriVariables, property.uriVariables);
                                        if (!this.isEmpty(uriVariables)) {
                                            options.uriVariables = uriVariables;
                                        }
                                        const content = yield thing.handleReadProperty(segments[3], options);
                                        res.setOption("Content-Format", content.type);
                                        res.code = "2.05";
                                        content.body.pipe(res);
                                    }
                                    catch (err) {
                                        console.error("[binding-coap]", `CoapServer on port ${this.getPort()} got internal error on read '${requestUri}': ${err.message}`);
                                        res.code = "5.00";
                                        res.end(err.message);
                                    }
                                }
                                else {
                                    const listener = (content) => __awaiter(this, void 0, void 0, function* () {
                                        try {
                                            res.setOption("Content-Format", content.type);
                                            res.code = "2.05";
                                            content.body.pipe(res, { end: true });
                                        }
                                        catch (err) {
                                            console.error("[binding-coap]", `CoapServer on port ${this.getPort()} got internal error on read '${requestUri}': ${err.message}`);
                                            res.code = "5.00";
                                            res.end(err.message);
                                        }
                                    });
                                    thing
                                        .handleObserveProperty(segments[3], listener, null)
                                        .then(() => res.end())
                                        .catch(() => res.end());
                                    res.on("finish", (err) => {
                                        if (err) {
                                            console.error("[binding-coap]", `CoapServer on port ${this.port} failed on observe with: ${err.message}`);
                                        }
                                        thing.handleUnobserveProperty(segments[3], listener, null);
                                    });
                                    setTimeout(() => thing.handleUnobserveProperty(segments[3], listener, null), 60 * 60 * 1000);
                                }
                            }
                            else if (req.method === "PUT") {
                                if (!property.readOnly) {
                                    try {
                                        const options = {
                                            formIndex: core_1.ProtocolHelpers.findRequestMatchingFormIndex(property.forms, this.scheme, req.url, contentType),
                                        };
                                        yield thing.handleWriteProperty(segments[3], { body: stream_1.Readable.from(req.payload), type: contentType }, options);
                                        res.code = "2.04";
                                        res.end("Changed");
                                    }
                                    catch (err) {
                                        console.error("[binding-coap]", `CoapServer on port ${this.getPort()} got internal error on write '${requestUri}': ${err.message}`);
                                        res.code = "5.00";
                                        res.end(err.message);
                                    }
                                }
                                else {
                                    res.code = "4.00";
                                    res.end("Property readOnly");
                                }
                            }
                            else {
                                res.code = "4.05";
                                res.end("Method Not Allowed");
                            }
                            return;
                        }
                    }
                    else if (segments[2] === this.ACTION_DIR) {
                        const action = thing.actions[segments[3]];
                        if (action) {
                            if (req.method === "POST") {
                                const options = {
                                    formIndex: core_1.ProtocolHelpers.findRequestMatchingFormIndex(action.forms, this.scheme, req.url, contentType),
                                };
                                const uriVariables = core_1.Helpers.parseUrlParameters(req.url, thing.uriVariables, action.uriVariables);
                                if (!this.isEmpty(uriVariables)) {
                                    options.uriVariables = uriVariables;
                                }
                                try {
                                    const output = yield thing.handleInvokeAction(segments[3], { body: stream_1.Readable.from(req.payload), type: contentType }, options);
                                    if (output) {
                                        res.setOption("Content-Format", output.type);
                                        res.code = "2.05";
                                        output.body.pipe(res, { end: true });
                                    }
                                    else {
                                        res.code = "2.04";
                                        res.end();
                                    }
                                }
                                catch (err) {
                                    console.error("[binding-coap]", `CoapServer on port ${this.getPort()} got internal error on invoke '${requestUri}': ${err.message}`);
                                    res.code = "5.00";
                                    res.end(err.message);
                                }
                            }
                            else {
                                res.code = "4.05";
                                res.end("Method Not Allowed");
                            }
                            return;
                        }
                    }
                    else if (segments[2] === this.EVENT_DIR) {
                        const event = thing.events[segments[3]];
                        if (event) {
                            if (req.method === "GET") {
                                if (req.headers.Observe === 0) {
                                    const packet = res._packet;
                                    packet.code = "0.00";
                                    packet.payload = Buffer.from("");
                                    packet.reset = false;
                                    packet.ack = true;
                                    packet.token = Buffer.alloc(0);
                                    res._send(res, packet);
                                    res._packet.confirmable = res._request.confirmable;
                                    res._packet.token = res._request.token;
                                    const options = {
                                        formIndex: core_1.ProtocolHelpers.findRequestMatchingFormIndex(event.forms, this.scheme, req.url, contentType),
                                    };
                                    const uriVariables = core_1.Helpers.parseUrlParameters(req.url, thing.uriVariables, event.uriVariables);
                                    if (!this.isEmpty(uriVariables)) {
                                        options.uriVariables = uriVariables;
                                    }
                                    const listener = (value) => __awaiter(this, void 0, void 0, function* () {
                                        try {
                                            console.debug("[binding-coap]", `CoapServer on port ${this.getPort()} sends '${segments[3]}' notification to ${core_1.Helpers.toUriLiteral(req.rsinfo.address)}:${req.rsinfo.port}`);
                                            res.setOption("Content-Format", value.type);
                                            res.code = "2.05";
                                            value.body.pipe(res);
                                        }
                                        catch (err) {
                                            console.debug("[binding-coap]", `CoapServer on port ${this.getPort()} failed '${segments[3]}' subscription`);
                                            res.code = "5.00";
                                            res.end();
                                        }
                                    });
                                    thing
                                        .handleSubscribeEvent(segments[3], listener, options)
                                        .then(() => res.end())
                                        .catch(() => res.end());
                                    res.on("finish", () => {
                                        console.debug("[binding-coap]", `CoapServer on port ${this.getPort()} ends '${segments[3]}' observation from ${core_1.Helpers.toUriLiteral(req.rsinfo.address)}:${req.rsinfo.port}`);
                                        thing.handleUnsubscribeEvent(segments[3], listener, options);
                                    });
                                }
                                else if (req.headers.Observe > 0) {
                                    console.debug("[binding-coap]", `CoapServer on port ${this.getPort()} sends '${segments[3]}' response to ${core_1.Helpers.toUriLiteral(req.rsinfo.address)}:${req.rsinfo.port}`);
                                    res.code = "5.01";
                                    res.end("node-coap issue: no GET cancellation, send RST");
                                }
                                else {
                                    console.debug("[binding-coap]", `CoapServer on port ${this.getPort()} rejects '${segments[3]}' read from ${core_1.Helpers.toUriLiteral(req.rsinfo.address)}:${req.rsinfo.port}`);
                                    res.code = "4.00";
                                    res.end("No Observe Option");
                                }
                            }
                            else {
                                res.code = "4.05";
                                res.end("Method Not Allowed");
                            }
                            return;
                        }
                    }
                }
            }
            res.code = "4.04";
            res.end("Not Found");
        });
    }
    isEmpty(obj) {
        for (const key in obj) {
            if (Object.prototype.hasOwnProperty.call(obj, key))
                return false;
        }
        return true;
    }
}
exports.default = CoapServer;
//# sourceMappingURL=coap-server.js.map