"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ClientOAuth2 = require("client-oauth2");
var https_1 = require("https");
var url_1 = require("url");
var credential_1 = require("./credential");
function createRequestFunction(rejectUnauthorized) {
    return function (method, url, body, headers) {
        return new Promise(function (resolve, reject) {
            var parsedURL = url_1.parse(url);
            var options = {
                method: method,
                host: parsedURL.hostname,
                port: parseInt(parsedURL.port),
                path: parsedURL.path,
                headers: headers
            };
            options.rejectUnauthorized = rejectUnauthorized;
            var req = https_1.request(options);
            req.on("response", function (response) {
                response.setEncoding('utf8');
                var body = [];
                response.on('data', function (data) { body.push(data); });
                response.on('end', function () {
                    resolve({
                        status: response.statusCode,
                        body: body.toString()
                    });
                });
            });
            req.on("error", function (er) {
                reject(er);
            });
            req.write(body);
            req.end();
        });
    };
}
var OAuthManager = (function () {
    function OAuthManager() {
        this.tokenStore = new Map();
    }
    OAuthManager.prototype.handleClientCredential = function (securityScheme, credentials) {
        var clientFlow = new ClientOAuth2({
            clientId: credentials.clientId,
            clientSecret: credentials.clientSecret,
            accessTokenUri: securityScheme.token,
            scopes: securityScheme.scopes,
            body: {}
        }, createRequestFunction(false));
        var token = clientFlow.credentials.getToken();
        return new credential_1.OAuthCredential(token, clientFlow.credentials.getToken.bind(clientFlow.credentials));
    };
    OAuthManager.prototype.handleResourceOwnerCredential = function (securityScheme, credentials) {
        var clientFlow = new ClientOAuth2({
            clientId: credentials.clientId,
            clientSecret: credentials.clientSecret,
            accessTokenUri: securityScheme.token,
            scopes: securityScheme.scopes,
        }, createRequestFunction(false));
        var token = clientFlow.owner.getToken(credentials.username, credentials.password);
        return new credential_1.OAuthCredential(token);
    };
    return OAuthManager;
}());
exports.default = OAuthManager;
//# sourceMappingURL=oauth-manager.js.map