"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const http_client_1 = __importDefault(require("./http-client"));
const oauth_manager_1 = __importDefault(require("./oauth-manager"));
class HttpClientFactory {
    constructor(config = null) {
        this.scheme = "http";
        this.config = null;
        this.oAuthManager = new oauth_manager_1.default();
        this.config = config;
    }
    getClient() {
        if (this.config && this.config.proxy && this.config.proxy.href && this.config.proxy.href.startsWith("https:")) {
            console.warn("[binding-http]", `HttpClientFactory creating client for 'https' due to secure proxy configuration`);
            return new http_client_1.default(this.config, true, this.oAuthManager);
        }
        else {
            console.debug("[binding-http]", `HttpClientFactory creating client for '${this.scheme}'`);
            return new http_client_1.default(this.config);
        }
    }
    init() {
        return true;
    }
    destroy() {
        return true;
    }
}
exports.default = HttpClientFactory;
//# sourceMappingURL=http-client-factory.js.map